$(document).ready(function(){
	function isValidPhoneNumber(phoneNumber) {
		// Define the regex pattern for a valid Nigerian phone number.
		// This pattern matches phone numbers in the formats: 08168290811, 2348168290811, +2348168290811.
		const pattern = /^(?:\+?234|0)?(7\d|8\d|9\d)\d{8}$/;
		
		// Test the phone number against the regex pattern.
		return pattern.test(phoneNumber);
	}
	var currentPage = $("#currentPage").val();
    //alert(currentPage);

    if(currentPage=='dashboard'){
            
		$("#startVehicleAdd").on('click', function(){
			let formdata = new FormData();
			
			var vehicleNum = $("#startNumberPlate").val();
			if(vehicleNum){
				$("#startNumberPlate").removeClass('is-invalid');
				formdata.append('numberPlate', vehicleNum);
				formdata.append('action','check-number');
				
				$.ajax({
					type: 'POST',
					url:'resources/scripts.php',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend: function(){
						$("#startMsg").html('');
						$("#startVehicleAdd").attr('disabled','disabled').html('<i class="fas fa-spinner fa-spin"></i>...Please wait');
					},
					success:function(responseData){
						if(responseData.header==='successful'){
							$("#startForm").attr('style', 'display: none;');
							$("#addCard").attr('style', 'display: block;');
							$("#vehicleEnumPage").addClass('modal-lg');
							$("#numberPlate").val(responseData.vnumber).attr('disabled','disabled');
						}  
						else{
							$("#startMsg").html('<h6 class="text-danger"><i class="fas fa-times-circle"></i> '+responseData.message+'</h6>');
							$("#startVehicleAdd").removeAttr('disabled').html('<i class="fas fa-arrow-right"></i> Proceed');
						} 
					}
				});
			}
			else{
				$("#startMsg").html('<h6 class="text-danger"><i class="fas fa-times-circle"></i> Vehicle Number Required</h6>');
			}
		});
		
		$("#verifyVehicle").on('click', function(){
			let formdata = new FormData();
			
			var vehicleNum = $("#vehicleNumber").val();
			if(vehicleNum){
				$("#vehicleNumber").removeClass('is-invalid');
				formdata.append('search-data', vehicleNum);
				formdata.append('action','search-vehicle');
				
				$.ajax({
					type: 'POST',
					url:'resources/scripts.php',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend: function(){
						$("#searchMsg").html('');
						$("#verifyVehicle").attr('disabled','disabled').html('<i class="fas fa-spinner fa-spin"></i>...Please wait');
					},
					success:function(responseData){
						if(responseData.header==='successful'){
							$("#searchBody").addClass('transaction-details');
							$("#searchVehiclePanel").attr('style','display: none;');
							$("#displayResultPanel").attr('style','display: block;');
							$("#displayResultPanel").html(responseData.message);
						}  
						else{
							$("#searchMsg").html('<h6 class="text-danger"><i class="fas fa-times-circle"></i> '+responseData.message+'</h6>');
							$("#verifyVehicle").removeAttr('disabled').html('<i class="fas fa-search"></i> Search Details');
						} 
					}
				});
			}
			else{
				$("#searchMsg").html('<h6 class="text-danger"><i class="fas fa-times-circle"></i> Search Criteria required</h6>');
			}
		});
		
		///////////reset the form and start over//////
		$("#startOver").on('click', function(){
			$("#startForm").attr('style', 'display: block;');
			$("#addCard").attr('style', 'display: none;');
			$("#vehicleEnumPage").removeClass('modal-lg');
			$("#startNumberPlate").val('');
			$("#numberPlate").val('').removeAttr('disabled');
			resetAddVehicleForm();
			$("#startVehicleAdd").removeAttr('disabled').html('<i class="fas fa-arrow-right"></i> Proceed');
		});
		
		$("#ownerPhone").on('blur', function(){
			const data = $(this).val();
			if(data){
				if(isValidPhoneNumber(data)){
					$("#ownerPhone").removeClass('is-invalid');
				}
				else{
					$("#ownerPhone").addClass('is-invalid');
				}
			}
			else{
				$("#ownerPhone").addClass('is-invalid');
			}
		});
		
		$("#ownerName").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#ownerName").removeClass('is-invalid');
			}
			else{
				$("#ownerName").addClass('is-invalid');
			}
		});
		$("#ownerAddress").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#ownerAddress").removeClass('is-invalid');
			}
			else{
				$("#ownerAddress").addClass('is-invalid');
			}
		});
		$("#state").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#state").removeClass('is-invalid');
			}
			else{
				$("#state").addClass('is-invalid');
			}
		});
		$("#city").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#city").removeClass('is-invalid');
			}
			else{
				$("#city").addClass('is-invalid');
			}
		});
		$("#vehicleMake").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#vehicleMake").removeClass('is-invalid');
			}
			else{
				$("#vehicleMake").addClass('is-invalid');
			}
		});
		$("#vehicleColor").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#vehicleColor").removeClass('is-invalid');
			}
			else{
				$("#vehicleColor").addClass('is-invalid');
			}
		});
		     
		$("#vehicleType").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#vehicleType").removeClass('is-invalid');
			}
			else{
				$("#vehicleType").addClass('is-invalid');
			}
		});
		$("#stickerNumber").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#stickerNumber").removeClass('is-invalid');
			}
			else{
				$("#stickerNumber").addClass('is-invalid');
			}
		});
		$("#numberPlate").on('blur', function(){
			const data = $(this).val();
			if(data){
				$("#numberPlate").removeClass('is-invalid');
			}
			else{
				$("#numberPlate").addClass('is-invalid');
			}
		});
		        
		$("#addVehicle").on('click', function(){
			var formdata = new FormData();
			var errorPhone = '';
			var ownerName = $("#ownerName").val();
			if(ownerName){
				$("#ownerName").removeClass('is-invalid');
				formdata.append('ownerName',ownerName);
			}
			else{
				$("#ownerName").addClass('is-invalid');
			}
			
			var ownerPhone = $("#ownerPhone").val();
			if(ownerPhone){
				if(isValidPhoneNumber(ownerPhone)){
					$("#ownerPhone").removeClass('is-invalid');
					formdata.append('ownerPhone',ownerPhone);
				}
				else{
					$("#ownerPhone").addClass('is-invalid');
					var errorPhone = 'Invalid Phone';
				}
			}
			else{
				$("#ownerPhone").addClass('is-invalid');
			}
			var ownerAddress = $("#ownerAddress").val();
			if(ownerAddress){
				$("#ownerAddress").removeClass('is-invalid');
				formdata.append('ownerAddress',ownerAddress);
			}
			else{
				$("#ownerAddress").addClass('is-invalid');
			}
			
			var state = $("#state").val();
			if(state){
				$("#state").removeClass('is-invalid');
				formdata.append('state',state);
			}
			else{
				$("#state").addClass('is-invalid');
			}
			
			var city = $("#city").val();
			if(city){
				$("#city").removeClass('is-invalid');
				formdata.append('city',city);
			}
			else{
				$("#city").addClass('is-invalid');
			}
	
			var vehicleMake = $("#vehicleMake").val();
			if(vehicleMake){
				$("#vehicleMake").removeClass('is-invalid');
				formdata.append('vehicleMake',vehicleMake);
			}
			else{
				$("#vehicleMake").addClass('is-invalid');
			}
			
			var vehicleColor = $("#vehicleColor").val();
			if(vehicleColor){
				$("#vehicleColor").removeClass('is-invalid');
				formdata.append('vehicleColor',vehicleColor);
			}
			else{
				$("#vehicleColor").addClass('is-invalid');
			}
			
			var vehicleType = $("#vehicleType").val();
			if(vehicleType){
				$("#vehicleType").removeClass('is-invalid');
				formdata.append('vehicleType',vehicleType);
			}
			else{
				$("#vehicleType").addClass('is-invalid');
			}
			
			var stickerNumber = $("#stickerNumber").val();
			if(stickerNumber){
				$("#stickerNumber").removeClass('is-invalid');
				formdata.append('stickerNumber',stickerNumber);
			}
			else{
				$("#stickerNumber").addClass('is-invalid');
			}
			
			var numberPlate = $("#numberPlate").val();
			if(numberPlate){
				$("#numberPlate").removeClass('is-invalid');
				formdata.append('numberPlate',numberPlate);
			}
			else{
				$("#numberPlate").addClass('is-invalid');
			}
			
			if(ownerName && ownerAddress && state && city && numberPlate && vehicleMake && vehicleColor && vehicleType && stickerNumber && ownerPhone && isValidPhoneNumber(ownerPhone)){
				//alert(formdata);
				formdata.append('action','add-vehicle');
				$.ajax({
					type: 'POST',
					url:'resources/scripts.php',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend: function(){
						$("#addMsg").html('');
						$("#addVehicle").attr('disabled','disabled').html('<i class="fa fa-spinner fa-spin"></i>...Please wait');
					},
					success:function(responseData){
						if(responseData.header==='successful'){
							$("#addMsg").html('<h6 class="text-primary"><i class="fa fa-check-circle"></i> '+responseData.message+'</h6>');
							setTimeout(function(){
								resetAddVehicleForm();
								$(this).removeAttr('disabled').html('<i class="fas fa-plus"></i> Add New Vehicle');
								$("#addMsg").html('');
								$("#startForm").attr('style', 'display: block;');
								$("#addCard").attr('style', 'display: none;');
								$("#vehicleEnumPage").removeClass('modal-lg');
								$("#startNumberPlate").val('');
								$("#startVehicleAdd").removeAttr('disabled').html('<i class="fas fa-arrow-right"></i> Proceed');
							},4000);
						}  
						else{
							$("#addMsg").html('<h6 class="text-danger"><i class="fa fa-times-circle"></i> '+responseData.message+'</h6>');
							$(this).removeAttr('disabled').html('<i class="fas fa-redo"></i> Try Again');
						} 
					}
				});
			}
			else{
				$("#addMsg").html('<h6 class="text-danger"><i class="fa fa-times-circle"></i> Please, fill all the fields properly</h6>');
			}
		});
		
		/////reset all the fields///////
		function resetAddVehicleForm(){
			$("#ownerName").val('');
			$("#ownerAddress").val('');
			$("#numberPlate").val('');
			$("#stickerNumber").val('');
			$("#ownerPhone").val('');
			$.ajax({
				type:'POST',
				url:'resources/scripts.php',
				data:'action=load-states',
				success:function(responseData){
					$("#state").html(responseData);
					$('#city').html('<option value="">Select State first</option>');
				}
			});
			$.ajax({
				type:'POST',
				url:'resources/scripts.php',
				data:'action=load-vehicle-type',
				success:function(responseData){
					$("#vehicleType").html(responseData);
				}
			});
			$.ajax({
				type:'POST',
				url:'resources/scripts.php',
				data:'action=load-vehicle-colour',
				success:function(responseData){
					$("#vehicleColor").html(responseData);
				}
			});
			$.ajax({
				type:'POST',
				url:'resources/scripts.php',
				data:'action=load-vehicle-make',
				success:function(responseData){
					$("#vehicleMake").html(responseData);
				}
			});
		}
    }

	$('#state').on('change', function(){
		var state = $(this).val();
		if(state){
			$.ajax({
				type:'POST',
				url:'resources/scripts.php',
				data:'action=get-state&state='+state,
				success:function(retValState){
					$('#city').html(retValState);
				}
			});
		}
		else{
			$('#city').html('<option value="">Select State first</option>');
		}
	});
	
	if(currentPage=='payment methods'){
		$.ajax({
			type:'POST',
			url:'scripts/dashboard.php',
			data:'action=load-crypto-addresses',
			beforeSend: function(){
				$("#cryptoAddressPanel").html('<h3 class="text-center text-primary"><i class="fa fa-spinner fa-spin"></i>...Loading Crypto Addresses</h3>');
			},
			success:function(response){
				$("#cryptoAddressPanel").html(response);
			}
		});
		
		$.ajax({
			type:'POST',
			url:'scripts/dashboard.php',
			data:'action=load-banks',
			beforeSend: function(){
				$("#bankAccountPanel").html('<h3 class="text-center text-primary"><i class="fa fa-spinner fa-spin"></i>...Loading Bank Accounts</h3>');
			},
			success:function(response){
				$("#bankAccountPanel").html(response);
			}
		});
	}
	
	setInterval(function(){
		$("#availableBalance").load('scripts/dashboard.php?action=fetch-balance'),
		$("#passwordLastUpdate").load('scripts/dashboard.php?action=password-last-update')
	}, 500);
	
	////////update the exchange rate///////
	setInterval(function(){
		$("#exchangeRate").load('scripts/dashboard.php?action=update-exchange-rate')
	}, 5000);
	
	
	/////////////PAYMENT METHOD SETTING////////////
	//////add crypto withdrawal address/////
	$("#addNewAddress").on('click', function(){
		var addUsdtAddress = $("#addUsdtAddress").val();
		if(!addUsdtAddress){
			$("#addUsdtAddress").addClass('is-invalid');
		}
		else{
			$("#addUsdtAddress").removeClass('is-invalid');
		}
		var addNetwork = $("#addNetwork").val();
		if(!addNetwork){
			$("#addNetwork").addClass('is-invalid');
		}
		else{
			$("#addNetwork").removeClass('is-invalid');
		}
		
		if(addNetwork && addUsdtAddress){
			$("#addUsdtAddress").removeClass('is-invalid');
			$.ajax({
				type: 'POST',
				url:'scripts/dashboard.php',
				data:'action=add-usdt-address&address='+addUsdtAddress+'&network='+addNetwork,
				dataType: 'JSON',
				beforeSend: function(){
					$("#addNewAddress").html('<i class="fa fa-spinner fa-spin"></i>...submitting').attr('disabled', 'disabled');
					//$("#usdtMsgBox").html('<br><i class="fa fa-spinner fa-spin"></i>...adding. Please, wait.').addClass('text-center text-info');
				},
				success: function(response){
					if(response.header=='successful'){
						$("#addCryptoCard").html(response.message);
						setTimeout(function(){
							$("#addNewAddress").html('<i class="fa fa-save"></i> Save Changes').removeAttr('disabled');
							$.ajax({
								type:'POST',
								url:'scripts/dashboard.php',
								data:'action=load-crypto-card',
								success:function(response){
									$("#addCryptoCard").html(response);
								}
							});
							
							$.ajax({
								type:'POST',
								url:'scripts/dashboard.php',
								data:'action=load-crypto-addresses',
								beforeSend: function(){
									$("#cryptoAddressPanel").html('<h3 class="text-center text-primary"><i class="fa fa-spinner fa-spin"></i>...loading</h3>');
								},
								success:function(response){
									$("#cryptoAddressPanel").html(response);
								}
							});
						},4000);
					}
					else{
						$("#addUsdtAddress").addClass('is-invalid');
						$("#addNewAddress").html('<i class="fa fa-save"></i> Save Changes').removeAttr('disabled');
						$("#usdtMsgBox").html('<br><i class="fa fa-times"></i>'+response.message).removeClass('text-info').addClass('text-danger');
					}
				}
			});
		}
	});
	
	///////bank account setting//////////
	$("#inputCountry").on('change', function(){
		var countryId = $(this).val();
		$.ajax({
            type:'POST',
            url:'scripts/dashboard.php',
            data:'action=get-banks&countryid='+countryId,
            beforeSend: function(){
                $("#loadBanks").html('<h5 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading</h5>');
            },
            success:function(responseData){
                $("#loadBanks").html(responseData);
            }
        });
	})
	
	$("#completeProcess").on('click', function(){
		var errorMsg = '';
		var verificationCode = $("#verificationCode").val();
		if(!verificationCode){
			errorMsg = '<i class="fa fa-times"></i> Verification Code required';
			$("#verificationCode").addClass('is-invalid');
		}
		else{
			$("#verificationCode").removeClass('is-invalid');
		}
		
		//alert(verificationCode);
		if(errorMsg){
			$("#msgBox").html('<h4 class="text-center"><br>'+errorMsg).addClass('text-danger').removeClass('text-info');
		}
		else{
			$.ajax({
				type:'POST',
				url:'scripts/dashboard.php',
				data:'action=submit-bank-account&code='+verificationCode,
				dataType: 'JSON',
				beforeSend: function(){
					$("#completeProcess").html('<i class="fa fa-spinner fa-spin"></i>...Veirifying');
				},
				success:function(responseData){
					if(responseData.header=='successful'){
						setTimeout(function(){
							$("#addbankaccount").html(responseData.message);
						},4000);
					}
					else{
						$("#completeProcess").removeAttr('disabled').html('VERIFY NOW');
						$("#msgBox").html('<h5 class="text-center text-danger"><br><i class="fa fa-times"></i> '+responseData.message+'</h5>').addClass('text-danger').removeClass('text-info');
					}
				}
			});
		}
	});
	
	$("#resendCode").on('click', function(){
		var errorMsg = '';
		$.ajax({
			type:'POST',
			url:'scripts/dashboard.php',
			data:'action=resend-code',
			dataType: 'JSON',
			beforeSend: function(){
				$("#resendCode").html('<i class="fa fa-spinner fa-spin"></i>...Sending');
			},
			success:function(responseData){
				if(responseData.header=='successful'){
					setTimeout(function(){
						$("#resendCode").removeAttr('disabled').html('RESEND CODE');
					},4000);
				}
				else{
					$("#resendCode").removeAttr('disabled').html('RESEND CODE');
					$("#msgBox").html('<h4 class="text-center"><br><i class="fa fa-times"></i> '+responseData.message+'</h4>').addClass('text-danger').removeClass('text-info');
				}
			}
		});
	});
	
////////////SECURITY SETTINGS///////	

	//////password update////////////////
	$("#updatePassword").on('click', function(){
		var errorMsg = '';
		var existingPassword = $("#existingPassword").val();
		if(!existingPassword){
			$("#existingPassword").addClass('is-invalid');
			errorMsg = '<i class="fa fa-times"></i> Existing password required';
		}
		else{
			$("#existingPassword").removeClass('is-invalid');
		}
		var newPassword = $("#newPassword").val();
		if(!newPassword){
			$("#newPassword").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> New password required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> New password required';
			}
		}
		else{
			$("#newPassword").removeClass('is-invalid');
		}
		var confirmPassword = $("#confirmPassword").val();
		if(!confirmPassword){
			$("#confirmPassword").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Confirm password required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Confirm password required';
			}
		}
		else{
			$("#confirmPassword").removeClass('is-invalid');
		}
		
		if(newPassword && confirmPassword){
			if(newPassword != confirmPassword){
				if(errorMsg){
					errorMsg += '<br><i class="fa fa-times"></i> Passwords do not Match';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Passwords do not Match';
				}
			}
		}
		
		if(errorMsg){
			$("#errorMsg").html('<br>'+errorMsg).addClass('text-danger');
		}
		else{
			$.ajax({
				type:'POST',
				url:'scripts/dashboard.php',
				data:'action=update-password&current='+existingPassword+'&newpassword='+newPassword+'&confirmpassword='+confirmPassword,
				dataType: 'JSON',
				beforeSend: function(){
					$("#errorMsg").html('<br><i class="fa fa-spinner fa-spin"></i>...Updating').addClass('text-info text-center').removeClass('text-danger');
				},
				success:function(responseData){
					if(responseData.header=='successful'){
						setTimeout(function(){
							$("#errorMsg").html('<br><i class="fa fa-check"></i> Password successfully updated').addClass('text-primary').removeClass('text-info');
							$("#existingPassword").val('');
							$("#newPassword").val('');
							$("#confirmPassword").val('');
						},4000);
					}
					else{
						$("#errorMsg").html('<br><i class="fa fa-times"></i> '+responseData.message).addClass('text-danger').removeClass('text-info');
					}
				}
			});
		}
	});
	
	/////security questions/////////////
	$("#question1").on('change', function(){
		var dataSelect = $(this).val();
		
		if(dataSelect){
			$("#question1").removeClass('is-invalid');
			$.ajax({
				type:'POST',
				url:'scripts/dashboard.php',
				data:'action=select-question&selected='+dataSelect,
				beforeSend:function(){
					$("#errorMsgQuestions").html('<br><h5><i class="fa fa-spinner fa-spin"></i>...Loading</h5>').addClass('text-center');
				},
				success:function(responseData){
					$("#errorMsgQuestions").html('');
					$("#ans1").attr('style','display: block;');
					$("#set2").attr('style','display: block;');
					$("#question2").html(responseData);
				}
			});
		}
		else{
			$("#question1").addClass('is-invalid');
			$("#set2").attr('style','display: none;');
			$("#set3").attr('style','display: none;');
			$("#ans1").attr('style','display: none;');
			$("#ans2").attr('style','display: none;');
			$("#ans3").attr('style','display: none;');
			$("#question2").html('<option value="">Select Security Question 1</option>');
		}
		
	});
	
	$("#question2").on('change', function(){
		var dataSelect = $(this).val();
		var question1 = $("#question1").val()
		
		if(dataSelect){
			$("#question2").removeClass('is-invalid');
			$.ajax({
				type:'POST',
				url:'scripts/dashboard.php',
				data:'action=select-question&selected='+dataSelect+'_'+question1,
				beforeSend:function(){
					$("#errorMsgQuestions").html('<br><h5><i class="fa fa-spinner fa-spin"></i>...Loading</h5>').addClass('text-center');
				},
				success:function(responseData){
					$("#errorMsgQuestions").html('');
					$("#ans2").attr('style','display: block;');
					$("#set3").attr('style','display: block;');
					$("#question3").html(responseData);
				}
			});
		}
		else{
			$("#question2").addClass('is-invalid');
			$("#set3").attr('style','display: none;');
			$("#ans2").attr('style','display: none;');
			$("#ans3").attr('style','display: none;');
			$("#btnSet").attr('style','display: none;');
			$("#question3").html('<option value="">Select Security Question 2 First</option>');
		}
		
	});
	
	$("#question3").on('change', function(){
		var dataSelect = $(this).val();
		
		if(dataSelect){
			$("#ans3").attr('style','display: block;');
			$("#btnSet").attr('style','display: block;');
		}
		else{
			$("#question2").addClass('is-invalid');
			$("#ans3").attr('style','display: none;');
			$("#btnSet").attr('style','display: none;');
		}
	});
	
	$("#securityQuestionBtn").on('click', function(){
		var question1 = $("#question1").val();
		if(!question1){
			$("#question1").addClass('is-invalid');
		}
		else{
			$("#question1").removeClass('is-invalid');
		}
		var answers1 = $("#answers1").val();
		if(!answers1){
			$("#answers1").addClass('is-invalid');
		}
		else{
			$("#answers1").removeClass('is-invalid');
		}
		var question2 = $("#question2").val();
		if(!question2){
			$("#question2").addClass('is-invalid');
		}
		else{
			$("#question2").removeClass('is-invalid');
		}
		var answers2 = $("#answers2").val();
		if(!answers2){
			$("#answers2").addClass('is-invalid');
		}
		else{
			$("#answers2").removeClass('is-invalid');
		}
		var question3 = $("#question3").val();
		if(!question3){
			$("#question3").addClass('is-invalid');
		}
		else{
			$("#question3").removeClass('is-invalid');
		}
		var answers3 = $("#answers3").val();
		if(!answers3){
			$("#answers3").addClass('is-invalid');
		}
		else{
			$("#answers3").removeClass('is-invalid');
		}
		
		if(question1 && answers1 && question2 && answers2 && question3 && answers3){
			$.ajax({
				type:'POST',
				url:'scripts/dashboard.php',
				dataType:'JSON',
				data:'action=add-questions&question1='+question1+'&answers1='+answers1+'&question2='+question2+'&answers2='+answers2+'&question3='+question3+'&answers3='+answers3,
				beforeSend:function(){
					$("#errorMsgQuestions").html('<br><h5><i class="fa fa-spinner fa-spin"></i>...Submitting</h5>').addClass('text-center');
					$("#securityQuestionBtn").html('<i class="fa fa-spinner fa-spin"></i>...loading').attr('disabled');
				},
				success:function(responseData){
					if(responseData.header=='successful'){
						$("#errorMsgQuestions").html('<br><i class="fa fa-check"></i> '+responseData.message).addClass('text-center text-primary');
						setTimeout(function(){
							location.href='./';
						},4000);
					}
					else{
						$("#securityQuestionBtn").html('<i class="fa fa-save"></i> Save Changes').removeAttr('disabled');
						$("#errorMsgQuestions").html('<br><i class="fa fa-times"></i> '+responseData.message).addClass('text-center text-danger');
					}
				}
			});
		}
		
	});
	
	////copy refrral link////////
	$("#copyAddress").on('click', function(){
		var copyText = document.getElementById("refLink");
		copyText.select();
		copyText.setSelectionRange(0, 99999)
		navigator.clipboard.writeText(copyText.value);	
		$("#copyAddress").html('<i class="fa fa-check"></i> Copied');
		setTimeout(function(){
			$("#copyAddress").html('<i class="fa fa-copy"></i>');
		}, 2000);
	});
	
	$("#generateRefCode").on('click', function(){
		$.ajax({
			type:'POST',
			url:'scripts/dashboard.php',
			data:'action=generate-ref-code',
			dataType: 'JSON',
			beforeSend: function(){
				$("#generateRefCode").html('<i class="fa fa-spinner fa-spin"></i>...generating').attr('disabled','disabled');
			},
			success:function(responseData){
				if(responseData.header=='successful'){
					$("#generateRefCode").html('<i class="fa fa-check"></i> DONE');
					$("#refLink").val(responseData.message);
					setTimeout(function(){
						$("#generateRefCode").html('<i class="fa fa-copy"></i>').attr('id', 'copyAddress').removeAttr('disabled');
					},2000);
				}
				else{
					$("#generateRefCode").removeAttr('disabled').html('RETRY');
				}
			}
		});
	});
	
	///////LOAD INVESTMENT DETAIL//////////
	$(document).delegate("[data-target='#transaction-detail']", "click", function() {
        var paymentId = $(this).attr('data-id');
		
		alert(paymentId);
        
        $.ajax({
            type:'POST',
            url:'scripts/dashboard.php',
            data:'action=get-investment-details&investmentid='+paymentId,
            success:function(responseData){
                $("#detailsBody").html(responseData);
            }
        });
    });
	
	///////////////WITHDRAWAL/////////////////
	$("#withdrawBtn").on('click', function(){
		let withdrawalAmount = $("#withdrawAmount").val();
		let withdrawalAddress = $("#withdrawto").val();
	
		if(!withdrawalAmount){
			$("#withdrawAmount").addClass('is-invalid');
		}
		else{
			$("#withdrawAmount").removeClass('is-invalid');
			$.ajax({
				type: 'POST',
				url:'scripts/dashboard.php',
				data:'action=make-withdrawal&amount='+withdrawalAmount+'&address='+withdrawalAddress,
				dataType: 'JSON',
				beforeSend: function(){
					$("#withdrawBtn").html('<i class="fa fa-spinner fa-spin"></i>...Sending Request');
				},
				success: function(response){
					if(response.header=='successful'){
						$("#withdrawalPanel").html(response.message);
						location.href='./';
					}
					else{
						$("#withdrawBtn").html('Continue');
						$("#msgBox").html('<br><i class="fa fa-times"></i>'+response.message).removeClass('text-info').addClass('text-danger');
					}
				}
			});
		}
	})
	
	$("#withdrawAll").on('click', function(){
		$.ajax({
			type: 'POST',
			url:'scripts/dashboard.php',
			data:'action=get-all-balance',
			dataType: 'JSON',
			beforeSend: function(){
					$("#withdrawAll").html('<i class="fa fa-spinner fa-spin"></i>...wait');
					$("#withdrawAmount").attr('disabled', 'disabled');
				},
			success: function(response){
				if(response.header=='successful'){
					$("#withdrawAmount").val(response.message).removeAttr('disabled');
					$("#withdrawAll").html('WITHDRAW ALL');
				}
				else{
					$("#withdrawBtn").html('Try Again');
				}
			}
		});
	});
	
	$("#makeWithdrawal").on('click', function(){
		let withdrawalAmount = $("#amount").val();
		let withdrawalAddress = $("#address").val();
		$.ajax({
			type: 'POST',
			url:'scripts/dashboard.php',
			data:'action=finish-withdrawal&amount='+withdrawalAmount+'&address='+withdrawalAddress,
			dataType: 'JSON',
			beforeSend: function(){
				$("#makeWithdrawal").html('<i class="fa fa-spinner fa-spin"></i>...Submitting Request');
			},
			success: function(response){
				if(response.header=='successful'){
					$("#withdrawalPanel").html(response.message);
					location.href='./';
				}
				else{
					$("#makeWithdrawal").html('<i class="fa fa-redo"></i> Try Again');
					$("#msgBox").html('<br><i class="fa fa-times"></i>'+response.message).removeClass('text-info').addClass('text-danger');
				}
			}
		});
	});
	
	/////close the withdrawal///
	$("#backToDashboard").on('click', function(){
		$.ajax({
			type: 'POST',
			url:'scripts/dashboard.php',
			data:'action=close-withdraw',
			dataType: 'JSON',
			beforeSend: function(){
				$("#backToDashboard").html('<i class="fa fa-spinner fa-spin"></i>...Submitting Request');
			},
			success: function(response){
				if(response.header=='successful'){
					location.href='./?session=dashboard';
				}
			}
		});
	});
});






