<?php

	use Box\Spout\Reader\ReaderFactory;
	use Box\Spout\Common\Type;

	require_once ('connect.php');
	require_once ('Spout/Autoloader/autoload.php');

	if(!empty($_POST['action'])){
		if($_POST['action']=='generate-certificate'){
			$pathinfo = pathinfo($_FILES['excelfile']['name']);
			if (($pathinfo['extension'] == 'xlsx' || $pathinfo['extension'] == 'xls') && $_FILES['excelfile']['size'] > 0 ){
				$file = $_FILES['excelfile']['tmp_name'];
				$reader = ReaderFactory::create(Type::XLSX);
				$reader->open($file);
				$count = 0;
				$skipped = 0;
				$added = 0;
				$notAdded = 0;
				$errorMsg = '';
				$certGen = 0;
				$certGenFail = 0;

				foreach ($reader->getSheetIterator() as $sheet){
					foreach ($sheet->getRowIterator() as $row){
						if($count > 0 && !empty(array_filter($row))) {
							$getId = mysqli_query($con, "SELECT MemberID FROM tbl_membership ORDER BY id DESC LIMIT 1");
							if(mysqli_num_rows($getId)>0){
								$idDet = mysqli_fetch_assoc($getId);
								$memberID = $idDet['MemberID'] + 1;
							}
							else{
								$memberID = 110001;
							}
							
							$name = ucwords(strtolower($row[1]));
							$name = preg_replace_callback('/\((.*?)\)/', function($matches) {
								return '(' . ucwords($matches[1]) . ')';
							}, $name);
							$phone  = str_replace(' ','',$row[2]);
							$email = '';
							$company = trim(addslashes($row[5]));
							$category = trim($row[3]);
							if($category != 'SME'){
								$category = ucwords(strtolower($row[3]));
							}
							
							$position = trim($row[4]);
							$natureOfBusiness = trim(addslashes($row[6]));
							$baseOfMember = trim(addslashes($row[7]));
							$communityOfOrigin = trim(addslashes($row[8]));
							$dateOfReg = $row[9];
							$dateAdded = date("Y-m-d h:i:sa");

							if(mysqli_num_rows(mysqli_query($con, "SELECT * FROM tbl_membership WHERE Name='$name' AND Category='$category' AND Phone='$phone'")) > 0){
								$skipped +=1;
							} else {
								$query = mysqli_query($con, "INSERT INTO tbl_membership SET 
									MemberID=$memberID,
									Name='$name',
									Phone='$phone',
									Email='$email',
									Company='$company',
									Category='$category',
									Position='$position',
									NatureOfBusiness='$natureOfBusiness',
									BaseOfMember='$baseOfMember',
									CommunityOfOrigin='$communityOfOrigin',
									DateAdded='$dateAdded'
								");

								if($query === true){
									$certNo = $memberID;
									if($position==''){
										$position = 'a Member';
									}
									elseif($position=='TRUSTEE'){
										$position = 'a Trustee';
									}
									else{
										$pos = explode('/',$position);
										if(sizeof($pos) > 1){
											if(sizeof($pos) > 1){
												$posMain = ucwords(strtolower($pos[0]));
												$secondPart = $pos[1];
												$position = 'the '.$posMain.' '.str_replace('TRUSTEE', 'and a Trustee',$secondPart);
											}
											else{
												$position = 'the '.$posMain;
											}
										}
										else{
											$position = 'the '.ucwords(strtolower($position));
										}
									}
									
									$generate = generateCertificate($name, $category, $certNo, $position);
									if($generate['header'] == 'Successful'){
										$certFile = $generate['file'];
										$added++;
										$certGen++;
										mysqli_query($con, "INSERT INTO tbl_certificates SET 
											MemberID='$memberID',
											CertFile='$certFile',
											DateGenerated='$dateAdded'
										");
									} else {
										$certGenFail++;
									}
								} else {
									$errorMsg .= "$name Generation Error: ".mysqli_error($con)."\n";
									$notAdded++;
								}
							}
						}
						$count++;
					}
				}

				$message = "Certificate Generation Successful: \nGenerated: $certGen\nNot Generated: $certGenFail\nSuccessful: $added\nFailed: $notAdded\nError: $errorMsg\nSkipped: $skipped\n";

				$reader->close();

				$dataDetails = array(
					"header"  => "successful",
					"message" => $message
				);
				echo json_encode($dataDetails);

			}
			else{
				$dataDetails = array(
					"header"	=>	"Error Occurred",
					"message"	=>	"Please, upload a valid excel file"
				);
				echo json_encode($dataDetails);
			}
		}
	}else{
		$dataDetails = array(
			"header"	=>	"Error Occurred",
			"message"	=>	"Error Accessing Script"
		);
		echo json_encode($dataDetails);
	}

?>
