<?php
	$hostname = 'localhost';
	$username = 'root';
	$password = '';
	$dbname = 'saltccima';

	$con = mysqli_connect($hostname,$username,$password, $dbname);
	
	if (!$con) {
		die("Database connection failed: " . mysqli_connect_error());
	}
	
	function generateCertificate($name,$category,$certNo,$position){
		$PNG_TEMP_DIR = 'images'.DIRECTORY_SEPARATOR;
		
		include_once __DIR__ ."/QR/qrlib.php";    
		
		//ofcourse we need rights to create temp dir
		if (!file_exists($PNG_TEMP_DIR))
			mkdir($PNG_TEMP_DIR);
		
		$filename = $PNG_TEMP_DIR.strtolower(str_replace(' ','-',$name)).mt_rand(000,999).'.png';
		
		$matrixPointSize = 12;
		$errorCorrectionLevel = 'L';
		QRcode::png("https://saltccima.com/certificate/verify/?vid=$certNo", $filename, $errorCorrectionLevel, $matrixPointSize, 2);
		
		if (!file_exists('sample-certificate.jpg')) {
			return [
				"header" => "Error Occurred",
				"message" => "Background certificate image not found."
			];
		}
		$image = imagecreatefromjpeg('sample-certificate.jpg'); // Or use imagecreatefromjpeg() for JPG

		$black = imagecolorallocate($image, 0, 0, 0);

		$imageWidth = imagesx($image);

		$texts = [
			[
				'text' => $certNo,
				'font_size' => 60,
				'font_path' => __DIR__ . '/fonts/tahoma.ttf',
				'y' => 2210,
				'align' => 'left'
			],
			[
				'text' => 'This is to certify that',
				'font_size' => 60,
				'font_path' => __DIR__ . '/fonts/tahoma.ttf',
				'y' => 1200,
				'align' => 'center'
			],
			[
				'text' => $name,
				'font_size' => 80,
				'font_path' => __DIR__ . '/fonts/Lucy-The-Cat.ttf',
				'y' => 1480,
				'align' => 'center'
			],
			[
				'text' => "is $position of the Chamber",
				'font_size' => 50,
				'font_path' => __DIR__ . '/fonts/tahoma.ttf',
				'y' => 1650,
				'align' => 'center'
			],
			[
				'text' => "[Category: $category]",
				'font_size' => 50,
				'font_path' => __DIR__ . '/fonts/SoulDaisy.otf',
				'y' => 1750,
				'align' => 'center'
			],
			[
				'text' => 'Dated this '.date('jS').' day of '.date('F, Y'),
				'font_size' => 45,
				'font_path' => __DIR__ . '/fonts/tahoma.ttf',
				'y' => 2000,
				'align' => 'center'
			]
		];

		// Loop through each text item
		foreach ($texts as $item) {
			if (!file_exists($item['font_path'])) {
				$response = array(
					"header" => "Error Orrurred",
					"message" => "Font file not found: " . $item['font_path']
				);
				return $response;
				exit;
			}

			$bbox = imagettfbbox($item['font_size'], 0, $item['font_path'], $item['text']);
			$textWidth = $bbox[2] - $bbox[0];

			// Alignment logic
			switch ($item['align']) {
				case 'center':
					$x = ($imageWidth - $textWidth) / 2;
					break;
				case 'right':
					$x = $imageWidth - $textWidth - 340;
					break;
				case 'left':
				default:
					$x = 650;
					break;
			}

			// Draw text
			imagettftext(
				$image,
				$item['font_size'],
				0,
				$x,
				$item['y'],
				$black,
				$item['font_path'],
				$item['text']
			);
		}

		// Save final image
		$qrImg = imagecreatefrompng($filename);
		$qrSize = imagesx($qrImg);
		
		$qrX = 600;
		$qrY = 1750;

		imagecopy($image, $qrImg, $qrX, $qrY, 0, 0, $qrSize, $qrSize);
		imagedestroy($qrImg);

		// Save final image
		$outputDir = __DIR__ . '/output/';
		if (!file_exists($outputDir)) {
			mkdir($outputDir, 0777, true);
		}
		$outputFile = __DIR__ . '/output/'.$certNo.'.jpg';
		imagejpeg($image, $outputFile);
		imagedestroy($image);
		unlink($filename);
		$response = array(
			"header"	=>	"Successful",
			"message"	=>	"Image saved as $certNo",
			"file"		=>	$certNo.'.jpg'
		);
		return $response;
	}
?>
