<?php
	$dir = '../../../';
	require_once($dir.'../connection.php');
	
	if(isset($_POST['action'])){
		if($_POST['action']=='load-plans'){
			$queryPlans = mysqli_query($db_conn, "SELECT * FROM tbl_plans WHERE status=1 ORDER BY amount ASC");
			$dataResponse = '<div class="card-header">
                <h3 class="card-title">List of Investment Plans ('.mysqli_num_rows($queryPlans).')</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" title="Refresh List" id="refreshPlans">
                    <i class="fas fa-sync-alt"></i>
                  </button>
                </div>
              </div>
              <div class="card-body">
			  <table id="example2" class="table table-bordered table-hover">
				<thead>
				  <tr>
					<th>S/N</th>
					<th>Plan Name</th>
					<th class="text-center">Amount</th>
					<th class="text-center">% ROI</th>
					<th class="text-center">Daily ROI</th>
					<th class="text-center">Weekly ROI</th>
					<th class="text-center">Monthly ROI</th>
					<th class="text-center">Total ROI</th>
					<th class="text-center">Investment Days</th>
					<th class="text-center">Subscribed</th>
					<th class="text-center">Status</th>
					<th><i class="fa fa-cogs"></i></th>
				  </tr>
				</thead>
            <tbody>';
			
			$number = 1;
            while($plan = mysqli_fetch_assoc(($queryPlans))){
                $planCode = $plan['plan_code'];
                $subscribedUsers = mysqli_query($db_conn, "SELECT COUNT(*) as total FROM tbl_payments WHERE plan_code='$planCode'");
				$subscribedUsers = mysqli_fetch_assoc($subscribedUsers);
				$subscribedUsers = $subscribedUsers['total'];
                if($plan['status']==1){
                    $status = '<label class="badge badge-success">Active</label>';
                    $btn = '<button type="button" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-plan" name="'.$plan['plan_name'].'" title="Edit '.$plan['plan_name'].'" data-id="'.$plan['plan_code'].'"><i class="fa fa-edit"></i></button>
                    <button type="button" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-plan" name="'.$plan['plan_name'].'" title="Delete '.$plan['plan_name'].'" data-id="'.$plan['plan_code'].'"><i class="fa fa-trash"></i></button>';
                }
                elseif($plan['status']==2){
                    $status = '<label class="badge badge-danger">Deleted</label>';
                    $btn = '<button type="button" class="btn btn-xs btn-success" data-toggle="modal" data-target="#restore-plan" name="'.$plan['plan_name'].'" title="Restore '.$plan['plan_name'].'" data-id="'.$plan['plan_code'].'"><i class="fas fa-trash-restore"></i></button>
                    <button type="button" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#perm-delete-plan" name="'.$plan['plan_name'].'" title="Permanently Delete '.$plan['plan_name'].'" data-id="'.$plan['plan_code'].'"><i class="fa fa-trash"></i></button>';
                }
                $dataResponse .= '<tr>
                <td>'.$number.'</td>
                <td><h6><b>'.$plan['plan_name'].'</b> ('.$plan['plan_code'].')'.'</h6></td>
                <td class="text-center"><b>$'.numberFormat($plan['amount']).'</b></td>
                <td class="text-center">'.$plan['percent_roi'].'</td>
                <td class="text-center">'.$plan['daily_roi'].'</td>
                <td class="text-center">'.$plan['weekly_roi'].'</td>
                <td class="text-center">'.$plan['monthly_roi'].'</td>
                <td class="text-center">'.$plan['full_roi'].'</td>
                <td class="text-center">'.$plan['investment_days'].'</td>
                <td class="text-center">'.$subscribedUsers.'</td>
                <td class="text-center">'.$status.'</td>
                <td>'.$btn.'</td>
                </tr>';
                $number++;
            }
            $dataResponse .= '</tbody></table></div><script>
			  $(function () {
				$("#example2").DataTable({
				  "responsive": true, "lengthChange": false, "autoWidth": false,
				  "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
				}).buttons().container().appendTo(\'#example2_wrapper .col-md-6:eq(0)\');
			  });
				$("#refreshPlans").on(\'click\', function(){
					$.ajax({
						type: \'POST\',
						url: \'resources/scripts/settings/plans.php\',
						data: \'action=load-plans\',
						success:function(response){
							$("#planDetails").html(response);
						}
					});
				});
			</script>';

            echo $dataResponse;
		}
		elseif($_POST['action']=='add-plan'){
			$errorMsg = '';
			$file = $_FILES['file']['name'];
			if(!is_dir($dir."../img/plans/")){
				mkdir($dir."../img/plans/");
			}
			$target_webdir = $dir."../img/plans/";
			$image = $target_webdir . basename($file);
			$imageFileType = strtolower(pathinfo($image,PATHINFO_EXTENSION));
			///check image selected//////
			if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
				$dataDetails = [
					"header"=> "error",
					"data"=> "",
					"message" => "You have to select an image file"
				]; 
			}
			else{
				$planName = mysqli_real_escape_string($db_conn, $_POST['planName']);
				$planAmount = mysqli_real_escape_string($db_conn, $_POST['planAmount']);
				$dailyRoi = mysqli_real_escape_string($db_conn, $_POST['dailyRoi']);
				$investmentPeriod = mysqli_real_escape_string($db_conn, $_POST['investmentPeriod']);
				$planDescription = addslashes(mysqli_real_escape_string($db_conn, $_POST['planDescription']));
				
				$getPlan = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_plans WHERE plan_name='$planName'"));
				$getAmount = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_plans WHERE amount=$planAmount"));
				if($getPlan > 0){
					$errorMsg = '<i class="fa fa-times"></i> <b>'.$planName.'</b> already added';
				}
				if($getPlan > 0){
					if($errorMsg){
						$errorMsg .= '<br><i class="fa fa-times"></i> A plan with this amount already exists';
					}
					else{
						$errorMsg = '<i class="fa fa-times"></i> A plan with this amount already exists';
					}
				}
				
				if(!$errorMsg){
					$ext = explode(".", $image);
					$ext = strtolower(end($ext));
					$newName = strtolower($planName."-".mt_rand(00000000000, time()).'.'.$ext);
					$newName = str_replace(' ', '-', $newName);
					if(move_uploaded_file($_FILES["file"]["tmp_name"], $target_webdir.$newName)) {
						$planCode = mt_rand(00000000,99999999);
						$dailyEarning = ($dailyRoi/100) * $planAmount;
						$weeklyRoi = $dailyEarning * 7;
						$monthlyRoi = $dailyEarning * 30;
						$fullRoi = $dailyRoi * $investmentPeriod;
						$dateAdded = date('Y-m-d h:i:sa', time());
						$addedBy = $user['unique_id'];
						 
						$submitPlan = mysqli_query($db_conn, "INSERT INTO tbl_plans SET
							plan_code='$planCode',
							plan_name='$planName',
							amount=$planAmount,
							percent_roi=$dailyRoi,
							daily_roi=$dailyEarning,
							weekly_roi=$weeklyRoi,
							monthly_roi=$monthlyRoi,
							full_roi=$fullRoi,
							description='$planDescription',
							investment_days='$investmentPeriod',
							banner='$newName',
							added_by='$addedBy',
							date_added='$dateAdded'
						");
						if($submitPlan === true){
							$dataDetails = [
								"header"=> "successful",
								"data"=> "",
								"message" => "plan successfully added"
							]; 
						}
						else{
							$error = mysqli_error($db_conn);
							$dataDetails = [
								"header"=> "error",
								"data"=> "",
								"message" => "Error Occurred: $error"
							]; 
						}
					}else {
						$dataDetails = [
							"header"=> "error",
							"data"=> "",
							"message" => "Could not upload the image file"
						]; 
					}
				}
				else{
					$dataDetails = [
						"header"=> "error",
						"data"=> "",
						"message" => "$errorMsg"
					];
				}
			}
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='edit-plan'){
			$planCode = $_POST['plancode'];
			$getPlan = mysqli_query($db_conn, "SELECT * FROM tbl_plans WHERE plan_code='$planCode' LIMIT 1");
			if(mysqli_num_rows($getPlan)<1){
				echo 'No record Found';
			}
			else{
				$planDetails = mysqli_fetch_assoc($getPlan);
				echo '<div class="row">
				  <div class="form-group col-md-4 col-lg-3 col-xl-3 col-sm-6 col-xs-12">
					<label for="planName">Plan Name</label>
					<input placeholder="Enter Plan Name" id="editPlanName" value="'.$planDetails['plan_name'].'" required type="text" class="form-control" >
				  </div>
				  
				  <div class="form-group col-md-4 col-lg-3 col-xl-3 col-sm-6 col-xs-12">
					  <label>Amount</label>
					  <div class="input-group">
						<div class="input-group-prepend">
						  <span class="input-group-text"><i class="fa fa-dollar"></i></span>
						</div>
						<input type="number" placeholder="Enter plan amount ($)" min="10" max="10000" value="'.$planDetails['amount'].'" step="5" class="form-control" id="editPlanAmount">
					  </div>
					  <!-- /.input group -->
				  </div>
				  <div class="form-group col-md-4 col-lg-3 col-xl-3 col-sm-6 col-xs-12">
					  <label>Daily ROI</label>
					  <div class="input-group">
						<input type="number" min="3" value="3" placeholder="Enter expected daily ROI" max="10000" value="'.$planDetails['plan_name'].'" step="5" class="form-control" id="editDailyRoi">
						<div class="input-group-append">
						  <span class="input-group-text"><i class="fa fa-percent"></i></span>
						</div>
					  </div>
					  <!-- /.input group -->
				  </div>
				  <div class="form-group col-md-4 col-lg-3 col-xl-3 col-sm-6 col-xs-12">
					<label for="investmentPeriod">Investment Period(days)</label>
					<input placeholder="Enter Investment days" value="90" min="30" id="editInvestmentPeriod" value="" type="number" class="form-control" />
				  </div>
				  <div class="form-group col-md-12">
					  <label for="planDescription">Plan Description</label>
					  <textarea placeholder="Enter Plan Description" type="text" id="editPlanDescription" rows="5" class="form-control">'.stripslashes($planDetails['description']).'</textarea>
				  </div>
				  <input type="hidden" id="editPlanCode" value="'.$planCode.'" />
				  
				  
				  <div class="col-12"><h6><span id="editPlanMsg" class="text-center"></span></h6></div>
				</div>';
			}
		}
	}
?>