<?php
    $dir = '../../../';
    require_once($dir.'../connection.php');
    $myId = $user['unique_id'];
	use Box\Spout\Reader\ReaderFactory;
	use Box\Spout\Common\Type;
	require_once('Spout/Autoloader/autoload.php');

    if(isset($_POST['action'])){
		function addBusinessRecord($newBusiness) {
			// Append new record to the session array
			$_SESSION['businessDetails'][] = $newBusiness;
		}
		function addFarmRecord($newBusiness) {
			// Append new record to the session array
			$_SESSION['farmDetails'][] = $newFarm;
		}
		
		function exitEnumeration(){
			unset($_SESSION['matanid']);
			unset($_SESSION['nin']);
			unset($_SESSION['bvn']);
			unset($_SESSION['dateOfBirth']);
			unset($_SESSION['gender']);
			unset($_SESSION['maritalStatus']);
			unset($_SESSION['genotype']);
			unset($_SESSION['bloodGroup']);
			unset($_SESSION['stateOfOrigin']);
			unset($_SESSION['lgaOfOrigin']);
			unset($_SESSION['houseNumber']);
			unset($_SESSION['streetName']);
			unset($_SESSION['stateOfResidence']);
			unset($_SESSION['residenceCity']);
			unset($_SESSION['lgaOfResidence']); 
			unset($_SESSION['firstname']);
			unset($_SESSION['lastname']);
			unset($_SESSION['middlename']);
			unset($_SESSION['email']);
			unset($_SESSION['phone']);
			unset($_SESSION['title']);
			unset($_SESSION['matanid']);
			unset($_SESSION['signature']);
			unset($_SESSION['passport']);
			
			unset($_SESSION['accountnumber']);
			unset($_SESSION['accountname']);
			unset($_SESSION['bankname']);
			unset($_SESSION['jtbtin']);
			
			unset($_SESSION['businessAdded']);
			unset($_SESSION['businessDetails']);
			unset($_SESSION['page']);
			
			$dataDetails = array(
				"header"=> "successful",
				"data"=> "",
				"message" => "Details reset"
			); 
			
			return json_encode($dataDetails);
		}
		
        if($_POST['action']=='upload-image'){
            
            /* Getting file name */
            $filename = $_FILES['file']['name'];
            
            $target_webdir = $dir."dist/img/users/";
            $image = $target_webdir . basename($filename);
            $imageFileType = strtolower(pathinfo($image,PATHINFO_EXTENSION));
            if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" ) {
                $dataDetails = [
                    "header"=> "Invalid file",
                    "data"=> "",
                    "message" => "You have to select an image file"
                ]; 
            }
            else{
                ////get the image extension////////
                $ext = explode(".", $image);
                $ext = strtolower(end($ext));
                $newName = strtolower($user['first_name'].'-'.$user['last_name'])."-".mt_rand(00000000000, time()).'.'.$ext;
                $newName = str_replace(' ', '', $newName);
                if(move_uploaded_file($_FILES["file"]["tmp_name"], $target_webdir.$newName)) {
                    
                    $updateProfile = mysqli_query($db_conn, "UPDATE tbl_users SET image='$newName' WHERE unique_id='".$myId."' LIMIT 1");
                    if($updateProfile === true){
                        if($formerName!='default.png' AND !empty($formerName)){ unlink($target_webdir.$formerName); }
                        
                        mysqli_query($db_conn, "INSERT INTO activity_log SET activity='Account profile image update on $appName', action='Account Profile Update', actor='".$user['unique_id']."', user='".$user['unique_id']."', date='".date("Y-m-d h:i:s a", time())."', time=".time().", level='High', ip='$ipAddress', browser='$browser', os='$operatingSystem'");
                        $displayImage = str_replace($dir,'',$target_webdir.$newName);
                        
                        $dataDetails = [
                            "header"=> "successful",
                            "data"=> "$displayImage",
                            "message" => "successfully updated"
                        ]; 
                    }
                    else{
                        $dataDetails = [
                            "header"=> "Profile not updated",
                            "data"=> "",
                            "message" => "Could not update profile"
                        ]; 
                    }
                }else {
                    $dataDetails = [
                        "header"=> "file not uploaded",
                        "data"=> "",
                        "message" => "Could not upload the image file"
                    ]; 
                }
            }

            echo json_encode($dataDetails);
        }
        elseif($_POST['action']=='upload-bg'){
            
            /* Getting file name */
            $filename = $_FILES['file']['name'];
            
            $target_webdir = $dir.'dist/img/bg/';
            $image = $target_webdir . basename($filename);
            $imageFileType = strtolower(pathinfo($image,PATHINFO_EXTENSION));
            if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" ) {
                $dataDetails = [
                    "header"=> "Invalid file",
                    "data"=> "",
                    "message" => "You have to select an image file"
                ]; 
            }
            else{
                ////get the image extension////////
                $ext = explode(".", $image);
                $ext = strtolower(end($ext));
                $newName = strtolower($user['first_name'].'-'.$user['last_name'])."-".mt_rand(00000000000, time()).'.'.$ext;
                $newName = str_replace(' ', '', $newName);
                if(move_uploaded_file($_FILES["file"]["tmp_name"], $target_webdir.$newName)) {
                    
                    $updateProfile = mysqli_query($db_conn, "UPDATE tbl_users SET cover_bg='$newName' WHERE unique_id='".$myId."' LIMIT 1");
                    if($updateProfile === true){
                        if($formerBg!='default.jpg' AND !empty($formerBg)){
                            unlink($target_webdir.$formerBg); 
                        }
                        
                        mysqli_query($db_conn, "INSERT INTO activity_log SET activity='Account profile image update on $appName', action='Account Profile Update', actor='".$user['unique_id']."', user='".$user['unique_id']."', date='".date("Y-m-d h:i:s a", time())."', time=".time().", level='High', ip='$ipAddress', browser='$browser', os='$operatingSystem'");
                        $displayBg = str_replace($dir,'',$target_webdir.$newName);
                        $displayBg = "background: url('$displayBg') center center;";
                        
                        $dataDetails = [
                            "header"=> "successful",
                            "data"=> "$displayBg",
                            "message" => "successfully updated"
                        ]; 
                    }
                    else{
                        $dataDetails = [
                            "header"=> "Cover not updated",
                            "data"=> "",
                            "message" => "Could not update cover"
                        ]; 
                    }
                }else {
                    $dataDetails = [
                        "header"=> "file not uploaded",
                        "data"=> "",
                        "message" => "Could not upload the image file"
                    ]; 
                }
            }

            echo json_encode($dataDetails);
        }
		elseif($_POST['action']=='add-user'){
			$lastname = trim(addslashes(ucwords(strtolower(mysqli_real_escape_string($db_conn, $_POST['lastname'])))));
			$firstname = trim(addslashes(ucwords(strtolower(mysqli_real_escape_string($db_conn, $_POST['firstname'])))));
			$middlename = trim(addslashes(ucwords(strtolower(mysqli_real_escape_string($db_conn, $_POST['middlename'])))));
			$email = mysqli_real_escape_string($db_conn, $_POST['email']);
			$phone = mysqli_real_escape_string($db_conn, $_POST['phone']);
			$address = mysqli_real_escape_string($db_conn, $_POST['address']);
			$state = mysqli_real_escape_string($db_conn, $_POST['state']);
			$city = mysqli_real_escape_string($db_conn, $_POST['city']);
			$userType = mysqli_real_escape_string($db_conn, $_POST['user-type']);
			$project = mysqli_real_escape_string($db_conn, $_POST['project']);
			
			/////check if email already exists/////////////////
			$emailExists = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_users WHERE email='$email'"));
			if($emailExists>0){
				$dataDetails = array("header"=>"error", "message"=>"Email address already in use");
			}
			else{
				$projectName = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT project_name FROM tbl_projects WHERE project_id='$project'"));
				$projectName = $projectName['project_name'];
				$errorMsg = '';
				if($userType=='National Project Manager'){
					$checkProject = mysqli_query($db_conn, "SELECT * FROM tbl_users WHERE user_type='$userType' AND dept_id='$project'");
					if(mysqli_num_rows($checkProject)>0){
						$errorMsg = "National Project Manager already exist for <b>$projectName</b>";
					}
				}
				elseif($userType=='State Project Manager'){
					$checkProject = mysqli_query($db_conn, "SELECT * FROM tbl_users WHERE user_type='$userType' AND dept_id='$project' AND state='$state'");
					if(mysqli_num_rows($checkProject)>0){
						$errorMsg = "State Project Manager already exist for <b>$projectName</b>";
					}
				}
				elseif($userType=='LG Project Manager'){
					$checkProject = mysqli_query($db_conn, "SELECT * FROM tbl_users WHERE user_type='$userType' AND dept_id='$project' AND state='$state' AND city='$city'");
					if(mysqli_num_rows($checkProject)>0){
						$errorMsg = "LG Project Manager already exist for <b>$projectName</b>";
					}
				}
				
				if(!empty($errorMsg)){
					$dataDetails = array("header"=>"error", "message"=>"$errorMsg");
				}
				else{
					$uniqueId = md5($email);
					$dateAdded = date("Y-m-d h:i:sa", time());
					$userPassword = password_generate(10);
					$password = md5($userPassword);
					if($user['user_type']=='Super Administrator'){
						$activeStatus = 1;
					}
					else{
						$activeStatus = 0;
					}
					$insertUser = mysqli_query($db_conn, "INSERT INTO tbl_users SET 
						unique_id='$uniqueId',
						first_name='$firstname',
						last_name='$lastname',
						middle_name='$middlename',
						email='$email',
						phone='$phone',
						dept_id='$project',
						active_status='$activeStatus',
						added_on='$dateAdded',
						added_by='$myId',
						password='$password',
						user_type='$userType',
						state='$state',
						city='$city'
					");
					
					if($insertUser===true){
						$firstName = $firstname;
						///////send mail to the user with login details///////////////////
						include_once($dir.'resources/scripts/mail.php');
						$body = $superOtpMail;
						$to = $email; 
						$subject = "$userType Account Creation";
						$from = "$appName <no-reply$mailLink>";
						$reply_to = "no-reply$mailLink";
						// To send HTML mail, the Content-type header must be set

						$headers  = 'MIME-Version: 1.0' . "\r\n";

						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

						// Create email headers
						$headers .= 'From: '.$from."\r\n".
							'Reply-To: '.$reply_to."\r\n" .
							'X-Mailer: PHP/' . phpversion();

						// Sending email
						if(mail($to, $subject, $body, $headers)===true){
							/////////update the user table/////////
							mysqli_query($db_conn, "UPDATE tbl_users SET profile_updated='Yes' WHERE unique_id='$uniqueId' LIMIT 1");
							$dataDetails = array("header"=>"successful", "message"=>"successfully added");
						}
						else{
							$dataDetails = array("header"=>"error", "message"=>"User added but mail not sent");
						}
							
					}
					else{
						$error = mysqli_error($db_conn);
						$dataDetails = array("header"=>"error", "message"=>"$error");
					}
				}
			}
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='add-market'){
			$marketName = mysqli_real_escape_string($db_conn, $_POST['marketname']);
			$marketState = mysqli_real_escape_string($db_conn, $_POST['marketstate']);
			$marketCity = mysqli_real_escape_string($db_conn, $_POST['marketcity']);
			$marketAddress = mysqli_real_escape_string($db_conn, $_POST['marketaddress']);
			
			/////check if the market already exists///
			if(mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_markets WHERE market_name='$marketName' AND state='$marketState' AND city='$marketCity'"))>0){
				$dataDetails = [
					"header"=> "error",
					"message" => "<b>$marketName</b> already exists on the system"
				];
			}
			else{
				///create the table for markets////////////
				mysqli_query($db_conn, "CREATE TABLE IF NOT EXISTS tbl_markets(
					id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
					market_id VARCHAR(50) NOT NULL UNIQUE KEY,
					market_name VARCHAR(200) NULL,
					state VARCHAR(60) NULL,
					city VARCHAR(60) NULL,
					address TEXT,
					status INT NOT NULL DEFAULT '1',
					added_by VARCHAR(60) NOT NULL,
					added_on VARCHAR(60) NOT NULL 
					)
				");
				
				if(strlen($marketState) < 2){
					$stateCode = '0'.$marketState;
				}
				else{
					$stateCode = $marketState;
				}
				if(strlen($marketCity) < 2){
					$cityCode = '0'.$marketCity;
				}
				else{
					$cityCode = $marketCity;
				}
				
				$marketId = 'MKTID-'.$stateCode.'-'.$cityCode.'-'.mt_rand(10000000,99999999);
				$dateAdded = date("Y-m-d h:i:sa", time());
				
				///////insert the market details////////////////
				$addMarket = mysqli_query($db_conn, "INSERT INTO tbl_markets SET
					market_id='$marketId',
					market_name='$marketName',
					state='$marketState',
					city='$marketCity',
					address='$marketAddress',
					added_by='$myId',
					added_on='$dateAdded' 
				");
				
				if($addMarket){
					$dataDetails = [
						"header"=> "successful",
						"message" => "$marketName Successfully Added"
					];   
				}
				else{
					$error = mysqli_error($db_conn);
					$dataDetails = [
						"header"=> "error",
						"message" => "Error: $error"
					];   
				}
			}
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='get-edit-market'){
			$mktId = $_POST['mktid'];
			$getMarket = mysqli_query($db_conn, "SELECT * FROM tbl_markets WHERE mmarket_id='$mktId' LIMIT 1");
			$mktDetail = mysqli_fetch_assoc($getMarket);
			
			$dataVal = '<div class="col-lg-12 col-sm-12">
				<div class="input-block mb-3">
					<label>Market Name</label>
					<input type="text" id="editmarketname" value="'.$mktDetail['market_name'].'" class="form-control" placeholder="Enter Market Name">
					<div class="invalid-feedback">
						Input Market name
					</div>
				</div>
			</div>
			<div class="col-lg-6 col-6">
				<div class="input-block mb-3">
					<label>State</label>
					<select class="select" id="editstate">';
?>
					<?php
						$mktState = $mktDetail['state'];
						$queryState = mysqli_query($db_conn, "SELECT * FROM states WHERE country_id='$nigeriaId' ORDER BY state_name ASC");
						
						while($state=mysqli_fetch_assoc($queryState)){
							if($state['state_id']==$mktState){
								$dataVal .= '<option value="'.$state['state_id'].'" selected="selected">'.$state['state_name'].'</option>';
							}
							else{
								$dataVal .= '<option value="'.$state['state_id'].'">'.$state['state_name'].'</option>';
							}
						}
					
					$dataVal .= '</select>
					<div class="invalid-feedback">
						Select State
					</div>
				</div>
			</div>
			<div class="col-lg-6 col-6">
				<div class="input-block mb-3">
					<label>City/LGA</label>
					<select class="select" id="editcity">
						<option value="'.$mktDetail['city'].'">'.getCityName($mktDetail['city']).'</option>
					</select>
					<div class="invalid-feedback">
						Select LGA
					</div>
				</div>
			</div>
			<div class="col-lg-12 col-sm-12">
				<div class="input-block mb-3">
					<label>Market Address</label>
					<textarea class="form-control" id="editmarketaddress" rows="5" placeholder="Enter Market Address">'.$mktDetail['market_name'].'</textarea>
					<div class="invalid-feedback">
						Input Market Address
					</div>
				</div>
				
				<div class="text-center" id="msgBox"></div>
			</div>';
			
			echo $dataVal;
		}
		elseif($_POST['action']=='delete-market'){
			$mktId = $_POST['mktid'];
			$deleteMkt = mysqli_query($db_conn, "UPDATE tbl_markets SET status=0 WHERE market_id='$mktId' LIMIT 1");
			if($deleteMkt===true){
				$dataDetails = array("header"=>"successful", "message"=>"Successfully Deleted");
			}
			else{
				$error = mysqli_error($db_conn);
				$dataDetails = array("header"=>"error", "message"=>"$error");
			}
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='add-project'){
			$projectInitial = mysqli_real_escape_string($db_conn, $_POST['projectinitial']);
			$projectName = mysqli_real_escape_string($db_conn, $_POST['projectname']);
			$projectDescription = mysqli_real_escape_string($db_conn, $_POST['projectdescription']);
			
			/////check if the project already exists///
			if(mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_projects WHERE project_name='$projectName'"))>0){
				$dataDetails = [
					"header"=> "error",
					"message" => "<b>$projectName</b> already exists on the system"
				];
			}
			else{
				$projectId = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT project_id FROM tbl_projects WHERE status=1 ORDER BY id DESC LIMIT 1"));
				$projectId = $projectId['project_id'];
				$projectId = explode('-',$projectId);
				$projectId = $projectId[1]+1;
				$projectId = $projectInitial.'-'.$projectId;
				
				$dateAdded = date("Y-m-d h:i:sa", time());
				
				///////insert the market details////////////////
				$addProject = mysqli_query($db_conn, "INSERT INTO tbl_projects SET
					project_id='$projectId',
					project_name='$projectName',
					project_description='$projectDescription',
					added_by='$myId',
					added_on='$dateAdded' 
				");
				
				if($addProject){
					$dataDetails = [
						"header"=> "successful",
						"message" => "$projectName Successfully Added"
					];   
				}
				else{
					$error = mysqli_error($db_conn);
					$dataDetails = [
						"header"=> "error",
						"message" => "Error: $error"
					];   
				}
			}
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='trader-enumeration-bvn-validation'){
			if(!isset($_SESSION['page'])){
				$bvn = mysqli_real_escape_string($db_conn, $_POST['bvn']);
				if(isset($_SESSION['bvnfetched'])){
					$dataDetails = array("header"=>"successful","message" => "");
					$_SESSION['page'] = $_SESSION['page']+1;
				}
				else{
					$data = verifyBVN($bvn);
					$data = json_decode($data, true);
					
					$responseCode = $data['responseCode'];
					$description = $data['description'];
					$verificationType = $data['verificationType'];
					$verificationStatus = $data['verificationStatus'];
					$transactionStatus = $data['transactionStatus'];
					$transactionReference = $data['transactionReference'];
					$transactionDate = $data['transactionDate'];
					$searchParameter = $data['searchParameter'];
					$callBackUrl = $data['callBackUrl'];
					$livenessScore = $data['livenessScore'];
					$paymentRef = $data['paymentRef'];
					
					if($description=='Successful'){
						$response = $data['response'];
						$firstName = $response['first_name'];
						$lastName = $response['last_name'];
						$middleName = $response['middle_name'];
						$dob = $response['dob'];
						$phoneNumber = $response['phone_number'];
						$phoneNumber2 = $response['phone_number_2'];
						$email = $response['email'];
						$gender = $response['gender'];
						$stateOfOrigin = $response['state_of_origin'];
						$bvn = $response['bvn'];
						$nin = $response['nin'];
						
						$_SESSION['bvnfetched'] = $bvn;
						$_SESSION['stateOfOrigin'] = $stateOfOrigin;
						$_SESSION['phone'] = $phoneNumber;
						$_SESSION['firstName'] = $firstName;
						$_SESSION['lastName'] = $lastName;
						$_SESSION['middleName'] = $middleName;
						$_SESSION['dateOfBirth'] = date("d-m-Y", strtotime($dob));
						$_SESSION['bvn'] = $bvn;
						$_SESSION['nin'] = $nin;
						$_SESSION['email'] = $email;
						
						$dataValues = '<div class="col-lg-4 col-md-4 col-sm-6">
							<div class="input-block mb-3">
								<label>Surname</label>
								<input type="text" value="'.$lastName.'" class="form-control" disabled>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6">
							<div class="input-block mb-3">
								<label>First Name</label>
								<input type="text" value="'.$firstName.'" class="form-control" disabled>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6">
							<div class="input-block mb-3">
								<label>Middle Name(optional)</label>
								<input type="text" value="'.$middleName.'" class="form-control" disabled>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6">
							<div class="input-block mb-3">
								<label>Phone</label>
								<input type="text" value="'.$phoneNumber.'" class="form-control" disabled>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6">
							<div class="input-block mb-3">
								<label>Email</label>
								<input type="text" value="'.$email.'" class="form-control" disabled>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-6">
							<div class="input-block mb-3">
								<label>Date of Birth</label>
								<input type="text" value="'.$dob.'" class="form-control" disabled>
							</div>
						</div>';
						$_SESSION['dataValues'] = $dataValues;
						
						$dataDetails = array("header"=>"successful","message" => "BVN Successfully Generated","recordField"=>"$dataValues");
					}
					else{
						$dataDetails = array("header"=>"error","message" => "$description");
					}
				}
			}
		}elseif($_POST['action']=='trader-enumeration'){
			if(isset($_SESSION['edit_trader'])){
				$id = $_SESSION['matanid'];
				$extraData = "AND matan_id!='$id'";
			}
			
			if(!isset($_SESSION['page']) || $_SESSION['page']=='0'){
				if(isset($_POST['email'])){
					$email = mysqli_real_escape_string($db_conn, $_POST['email']);
					$checkEmail = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE email='$email' $extraData"));
					if($checkEmail>0){
						$errorMsg = 'Email Address already in use';
					}
					else{
						$_SESSION['email'] = $email;
					}
				}
				if(isset($_POST['phone'])){
					$phone = mysqli_real_escape_string($db_conn, $_POST['phone']);
					$checkPhone = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE phone='$phone' $extraData"));
					if($checkPhone>0){
						if($errorMsg){
							$errorMsg .= '<br>Phone Number already in use';
						}
						else{
							$errorMsg = 'Phone Number already in use';
						}
					}
					else{
						$_SESSION['phone'] = $phone;
					}
				}
				if(!$errorMsg){
					if(isset($_POST['lastname'])){
						$lastname = mysqli_real_escape_string($db_conn, $_POST['lastname']);
						$_SESSION['lastname'] = $lastname;
					}
					if(isset($_POST['title'])){
						$title = mysqli_real_escape_string($db_conn, $_POST['title']);
						$_SESSION['title'] = $title;
					}
					if(isset($_POST['firstname'])){
						$firstname = mysqli_real_escape_string($db_conn, $_POST['firstname']);
						$_SESSION['firstname'] = $firstname;
					}
					if(isset($_POST['middlename'])){
						$middlename = mysqli_real_escape_string($db_conn, $_POST['middlename']);
						$_SESSION['middlename'] = $middlename;
					}
					
					if(isset($_SESSION['edit_trader'])){
						mysqli_query($db_conn, "UPDATE tbl_traders_enumeration SET
							title = '$title',
							firstname = '$firstname',
							lastname = '$lastname',
							middlename = '$middlename',
							email = '$email',
							phone = '$phone' WHERE matan_id='$id' LIMIT 1
						");
					}
					
					$dataDetails = array("header"=>"successful","message" => "Submitted"); 
					$_SESSION['page'] = $_SESSION['page']+1;
				}
				else{
					$dataDetails = array("header"=>"error","message" => "$errorMsg"); 
				}
			}
			elseif($_SESSION['page']=='1'){
				if(isset($_POST['nin'])){
					$nin = trim(mysqli_real_escape_string($db_conn, $_POST['nin']));
					$checkNin = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE nin='$nin' $extraData"));
					if($checkNin>0){
						$errorMsg = 'NIN already in use';
					}
				}
				
				if(isset($_POST['bvn'])){
					$bvn = trim(mysqli_real_escape_string($db_conn, $_POST['bvn']));
					$checkBvn = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE bvn='$bvn' $extraData"));
					if($checkBvn>0){
						if($errorMsg){
							$errorMsg .= '<br>BVN already in use';
						}
						else{
							$errorMsg = 'BVN already in use';
						}
					}
				}
				if(!$errorMsg){
					$dateOfBirth = mysqli_real_escape_string($db_conn, $_POST['dateOfBirth']);
					$gender = mysqli_real_escape_string($db_conn, $_POST['gender']);
					$maritalStatus = mysqli_real_escape_string($db_conn, $_POST['maritalStatus']);
					$genotype = mysqli_real_escape_string($db_conn, $_POST['genotype']);
					$bloodGroup = mysqli_real_escape_string($db_conn, $_POST['bloodGroup']);
					$stateOfOrigin = mysqli_real_escape_string($db_conn, $_POST['stateOfOrigin']);
					$lgaOfOrigin = mysqli_real_escape_string($db_conn, $_POST['lgaOfOrigin']);
					
					$_SESSION['nin'] = $nin;
					$_SESSION['bvn'] = $bvn;
					$_SESSION['dateOfBirth'] = $dateOfBirth;
					$_SESSION['gender'] = $gender;
					$_SESSION['maritalStatus'] = $maritalStatus;
					$_SESSION['genotype'] = $genotype;
					$_SESSION['bloodGroup'] = $bloodGroup;
					$_SESSION['stateOfOrigin'] = $stateOfOrigin;
					$_SESSION['lgaOfOrigin'] = $lgaOfOrigin;
					
					if(isset($_SESSION['edit_trader'])){
						mysqli_query($db_conn, "UPDATE tbl_traders_enumeration SET
							nin = '$nin',
							bvn = '$bvn',
							dateofbirth = '$dateOfBirth',
							gender = '$gender',
							maritalstatus = '$maritalStatus',
							genotype = '$genotype',
							bloodgroup = '$bloodGroup',
							stateoforigin = '$stateOfOrigin',
							lgaoforigin = '$lgaOfOrigin' WHERE matan_id='$id' LIMIT 1
						");
					}
					
					$dataDetails = array("header"=>"successful","message" => "");
					$_SESSION['page'] = $_SESSION['page']+1;
				}
				else{
					$dataDetails = array("header"=>"error","message" => "$errorMsg");
				}
			}
			elseif($_SESSION['page']=='2'){
				$houseNumber = addslashes(mysqli_real_escape_string($db_conn, $_POST['houseNumber']));
				$streetName = addslashes(mysqli_real_escape_string($db_conn, $_POST['streetName']));
				$stateOfResidence = mysqli_real_escape_string($db_conn, $_POST['stateOfResidence']);
				$lgaOfResidence = mysqli_real_escape_string($db_conn, $_POST['lgaOfResidence']);
				$residenceCity = addslashes(mysqli_real_escape_string($db_conn, $_POST['residenceCity']));
				$userType = mysqli_real_escape_string($db_conn, $_POST['userType']);
				
				if($userType=='Farmer'){
					$yearsOfExperience = addslashes(mysqli_real_escape_string($db_conn, $_POST['yearsOfExperience']));
					$_SESSION['yearsOfExperience'] = $yearsOfExperience;
				}
				
				$_SESSION['houseNumber'] = $houseNumber;
				$_SESSION['streetName'] = $streetName;
				$_SESSION['stateOfResidence'] = $stateOfResidence;
				$_SESSION['residenceCity'] = $residenceCity;
				$_SESSION['lgaOfResidence'] = $lgaOfResidence; 
				
				if(isset($_SESSION['edit_trader'])){
					mysqli_query($db_conn, "UPDATE tbl_traders_enumeration SET
						housenumber = '$houseNumber',
						streetname = '$streetName',
						stateofresidence = '$stateOfResidence',
						lgaofresidence = '$lgaOfResidence',
						cityofresidence = '$residenceCity' WHERE matan_id='$id' LIMIT 1
					");
				}
				
				$dataDetails = array("header"=>"successful","message" => "");
				$_SESSION['page'] = $_SESSION['page']+1;
			}
			elseif($_SESSION['page']=='3'){
				$dataDetails = array("header"=>"successful","message" => "");
				$_SESSION['page'] = $_SESSION['page']+1;
			}
			elseif($_SESSION['page']=='4'){
				$dataDetails = array("header"=>"successful","message" => "");
				$_SESSION['page'] = $_SESSION['page']+1;
			}
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='add-business'){
			$businessState = mysqli_real_escape_string($db_conn, $_POST['businessState']);
			$businessCity = mysqli_real_escape_string($db_conn, $_POST['businessCity']);
			$market = mysqli_real_escape_string($db_conn, $_POST['market']);
			$shopNumber = addslashes(mysqli_real_escape_string($db_conn, $_POST['shopNumber']));
			$natureOfBusiness = mysqli_real_escape_string($db_conn, $_POST['natureOfBusiness']);
			$businessCategory = mysqli_real_escape_string($db_conn, $_POST['businessCategory']);
			$businessScale = mysqli_real_escape_string($db_conn, $_POST['businessScale']);
			$businessAddress = addslashes(mysqli_real_escape_string($db_conn, $_POST['businessAddress']));
			$businessTown = addslashes(mysqli_real_escape_string($db_conn, $_POST['businessTown']));
			$businessPhone = mysqli_real_escape_string($db_conn, $_POST['businessPhone']);
			$businessEmail = mysqli_real_escape_string($db_conn, $_POST['businessEmail']);
			$companyName = addslashes(mysqli_real_escape_string($db_conn, $_POST['companyName']));
			$companyNumber = addslashes(mysqli_real_escape_string($db_conn, $_POST['companyNumber']));
			$companyTin = addslashes(mysqli_real_escape_string($db_conn, $_POST['companyTin']));
			
			if(isset($_SESSION['edit_trader'])){
				/////check if this already exists///////
				$queryComp = mysqli_query($db_conn, "SELECT * FROM tbl_businesses WHERE shopnumber='$shopNumber'
					AND businessphone='$businessPhone' AND businessname='$companyName' AND businessaddress='$businessAddress'
					AND businessstate='$businessState' AND businesscale='$businessScale' AND businesscategory='$businessCategory'
				");
				if(mysqli_num_rows($queryComp)>0){
					$dataDetails = array("header"=>"error","message" => "Business already added");
				}
				else{
					//////insert the company//////
					$matanId = $_SESSION['matanid'];
					$businessId = $appInitial.'-'.mt_rand(100000,999999);
					$insertBusiness = mysqli_query($db_conn, "INSERT INTO tbl_businesses SET
						biz_id = '$businessId',
						trader_id = '$matanId',
						businessname = '$companyName',
						businessnumber = '$companyNumber',
						businessphone = '$businessPhone',
						businessemail = '$businessEmail',
						marketid = '$market',
						shopnumber = '$shopNumber',
						businessaddress = '$businessAddress',
						natureofbusiness = '$natureOfBusiness',
						businesscategory = '$businessCategory',
						businesscale = '$businessScale',
						businesstin = '$companyTin',
						businessstate = '$businessState',
						businesslga = '$businessCity',
						businesstown = '$businessTown'
					");
					
					if($insertBusiness===true){
						$dataDetails = array("header"=>"successful","message" => "Successfully added","businessAdded"=>"added");
					}
					else{
						$error = mysqli_error($db_conn);
						$dataDetails = array("header"=>"error","message" => "$error");
					}
				}
			}
			else{
				if (!isset($_SESSION['businessDetails'])) {
					$_SESSION['businessDetails'] = array();
				}
				$businessDetail = array(
					"businessState" => "$businessState",
					"businessCity" => "$businessCity",
					"market" => "$market",
					"shopNumber" => "$shopNumber",
					"natureOfBusiness" => "$natureOfBusiness",
					"businessCategory" => "$businessCategory",
					"businessScale" => "$businessScale",
					"businessAddress" => "$businessAddress",
					"businessTown" => "$businessTown",
					"businessPhone" => "$businessPhone",
					"businessEmail" => "$businessEmail",
					"companyName" => "$companyName",
					"companyNumber" => "$companyNumber",
					"companyTin" => "$companyTin"
				);
				
				// Check if the session array already exists
				if (isset($_SESSION['businessDetails'])) {
					$businessDetails = $_SESSION['businessDetails'];

					// Flag to indicate if a match is found
					$isDuplicate = false;

					// Loop through the array to check if the new data already exists
					foreach ($businessDetails as $record) {
						// Check if all fields match exactly
						if(
							$record['businessState'] == $businessDetail['businessState'] &&
							$record['businessCity'] == $businessDetail['businessCity'] &&
							$record['market'] == $businessDetail['market'] &&
							$record['shopNumber'] == $businessDetail['shopNumber'] &&
							$record['natureOfBusiness'] == $businessDetail['natureOfBusiness'] &&
							$record['businessCategory'] == $businessDetail['businessCategory'] &&
							$record['businessScale'] == $businessDetail['businessScale'] &&
							$record['businessAddress'] == $businessDetail['businessAddress'] &&
							$record['businessPhone'] == $businessDetail['businessPhone'] &&
							$record['businessEmail'] == $businessDetail['businessEmail'] &&
							$record['companyName'] == $businessDetail['companyName'] &&
							$record['companyNumber'] == $businessDetail['companyNumber'] &&
							$record['companyTin'] == $businessDetail['companyTin']
						){
							$isDuplicate = true;
							break;
						}
					}
					
					if($isDuplicate===true){
						$dataDetails = array("header"=>"error","message" => "This Record was already added");
					}
					else{
						addBusinessRecord($businessDetail);
						$_SESSION['businessAdded'] = time();
						$data = $_SESSION['businessAdded'];
						$dataDetails = array("header"=>"successful","message" => "Successfully added","businessAdded"=>"$data");
					}
				}
				else{
					addBusinessRecord($businessDetail);
					$_SESSION['businessAdded'] = time();
					$data = $_SESSION['businessAdded'];
					$dataDetails = array("header"=>"successful","message" => "Successfully added","businessAdded"=>"$data");
				}
			}
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='fetch-companies'){
			$userType = mysqli_real_escape_string($db_conn, $_POST['userType']);
			if($userType=='Trader'){
				$dataTable = '<table class="table table-center table-hover datatable">
					<thead class="thead-light">
						<tr>
							<td>S/N</td>
							<td>Nature</td>
							<td>Category</td>
							<td>State</td>
							<td>LGA</td>
							<td>Market</td>
							<td>Scale</td>
							<td>Phone</td>
							<td>Email</td>
							<td></td>
						</tr>
					</thead>
					<tbody>';
						
						$counter = 1; // To maintain the S/N

						if(!isset($_SESSION['edit_trader'])){
							// Loop through the session records and display them in the table
							foreach ($_SESSION['businessDetails'] as $index => $business) {
								$market = $business['market'];
								$market = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT market_name FROM tbl_markets WHERE market_id='$market' LIMIT 1"));
								$market = $market['market_name'];
								$dataTable .= "<tr>";
								$dataTable .= "<td>" . $counter . "</td>";
								$dataTable .= "<td>" . $business['natureOfBusiness'] . "</td>";
								$dataTable .= "<td>" . $business['businessCategory'] . "</td>";
								$dataTable .= "<td>" . getStateName($business['businessState']) . "</td>";
								$dataTable .= "<td>" . getCityName($business['businessCity']) . "</td>";
								$dataTable .= "<td>" . $market . "</td>";
								$dataTable .= "<td>" . $business['businessScale'] . "</td>";
								$dataTable .= "<td>" . $business['businessPhone'] . "</td>";
								$dataTable .= "<td>" . $business['businessEmail'] . "</td>";
								$dataTable .= '<td>
									<a href="javascript:void(0);" data-id="'.$index.'" data-bs-toggle="modal" data-bs-target="#delete_business">
										<i class="fas fa-trash text-danger"></i>
									</a> 
									<a href="javascript:void(0);" data-id="'.$index.'" data-bs-toggle="modal" data-bs-target="#edit_business">
										<i class="fas fa-edit text-primary"></i>
									</a>
								</td>';
								$dataTable .= "</tr>";
								$counter++;
							}
						}
						else{
							$matanId = $_SESSION['matanid'];
							$queryBusinesses = mysqli_query($db_conn, "SELECT * FROM tbl_businesses WHERE trader_id='$matanId' AND status!=0");
							if(mysqli_num_rows($queryBusinesses)>0){
								while($business=mysqli_fetch_assoc($queryBusinesses)) {
									$market = $business['marketid'];
									$market = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT market_name FROm tbl_markets WHERE market_id='$market' LIMIT 1"));
									$market = $market['market_name'];
									$dataTable .= "<tr>";
									$dataTable .= "<td>" . $counter . "</td>";
									$dataTable .= "<td>" . $business['natureofbusiness'] . "</td>";
									$dataTable .= "<td>" . $business['businesscategory'] . "</td>";
									$dataTable .= "<td>" . getStateName($business['businessstate']) . "</td>";
									$dataTable .= "<td>" . getCityName($business['businesslga']) . "</td>";
									$dataTable .= "<td>" . $market . "</td>";
									$dataTable .= "<td>" . $business['businesscale'] . "</td>";
									$dataTable .= "<td>" . $business['businessphone'] . "</td>";
									$dataTable .= "<td>" . $business['businessemail'] . "</td>";
									$dataTable .= '<td>
										<a href="javascript:void(0);" data-id="'.$business['biz_id'].'" data-bs-toggle="modal" data-bs-target="#delete_business">
											<i class="fas fa-trash text-danger"></i>
										</a> 
										<a href="javascript:void(0);" data-id="'.$business['biz_id'].'" data-bs-toggle="modal" data-bs-target="#edit_business">
											<i class="fas fa-edit text-primary"></i>
										</a>
									</td>';
									$dataTable .= "</tr>";
									$counter++;
								}
								
								$_SESSION['businessAdded'] = time();
							}
							else{
								unset($_SESSION['businessAdded']);
							}
						}
					$dataTable .= '</tbody>
				</table>';
			}else{
				$dataTable = '<table class="table table-center table-hover datatable">
					<thead class="thead-light">
						<tr>
							<td>S/N</td>
							<td>Nature</td>
							<td>Category</td>
							<td>State</td>
							<td>LGA</td>
							<td>Community</td>
							<td>Scale</td>
							<td>Phone</td>
							<td>Email</td>
							<td></td>
						</tr>
					</thead>
					<tbody>';
						
						$counter = 1; // To maintain the S/N

						if(!isset($_SESSION['edit_trader'])){
							// Loop through the session records and display them in the table
							foreach ($_SESSION['businessDetails'] as $index => $business) {
								$market = $business['market'];
								$market = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT market_name FROM tbl_markets WHERE market_id='$market' LIMIT 1"));
								$market = $market['market_name'];
								$dataTable .= "<tr>";
								$dataTable .= "<td>" . $counter . "</td>";
								$dataTable .= "<td>" . $business['natureOfBusiness'] . "</td>";
								$dataTable .= "<td>" . $business['businessCategory'] . "</td>";
								$dataTable .= "<td>" . getStateName($business['businessState']) . "</td>";
								$dataTable .= "<td>" . getCityName($business['businessCity']) . "</td>";
								$dataTable .= "<td>" . $market . "</td>";
								$dataTable .= "<td>" . $business['businessScale'] . "</td>";
								$dataTable .= "<td>" . $business['businessPhone'] . "</td>";
								$dataTable .= "<td>" . $business['businessEmail'] . "</td>";
								$dataTable .= '<td>
									<a href="javascript:void(0);" data-id="'.$index.'" data-bs-toggle="modal" data-bs-target="#delete_business">
										<i class="fas fa-trash text-danger"></i>
									</a> 
									<a href="javascript:void(0);" data-id="'.$index.'" data-bs-toggle="modal" data-bs-target="#edit_business">
										<i class="fas fa-edit text-primary"></i>
									</a>
								</td>';
								$dataTable .= "</tr>";
								$counter++;
							}
						}
						else{
							$matanId = $_SESSION['matanid'];
							$queryBusinesses = mysqli_query($db_conn, "SELECT * FROM tbl_businesses WHERE trader_id='$matanId' AND status!=0");
							if(mysqli_num_rows($queryBusinesses)>0){
								while($business=mysqli_fetch_assoc($queryBusinesses)) {
									$market = $business['marketid'];
									$market = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT market_name FROm tbl_markets WHERE market_id='$market' LIMIT 1"));
									$market = $market['market_name'];
									$dataTable .= "<tr>";
									$dataTable .= "<td>" . $counter . "</td>";
									$dataTable .= "<td>" . $business['natureofbusiness'] . "</td>";
									$dataTable .= "<td>" . $business['businesscategory'] . "</td>";
									$dataTable .= "<td>" . getStateName($business['businessstate']) . "</td>";
									$dataTable .= "<td>" . getCityName($business['businesslga']) . "</td>";
									$dataTable .= "<td>" . $market . "</td>";
									$dataTable .= "<td>" . $business['businesscale'] . "</td>";
									$dataTable .= "<td>" . $business['businessphone'] . "</td>";
									$dataTable .= "<td>" . $business['businessemail'] . "</td>";
									$dataTable .= '<td>
										<a href="javascript:void(0);" data-id="'.$business['biz_id'].'" data-bs-toggle="modal" data-bs-target="#delete_business">
											<i class="fas fa-trash text-danger"></i>
										</a> 
										<a href="javascript:void(0);" data-id="'.$business['biz_id'].'" data-bs-toggle="modal" data-bs-target="#edit_business">
											<i class="fas fa-edit text-primary"></i>
										</a>
									</td>';
									$dataTable .= "</tr>";
									$counter++;
								}
								
								$_SESSION['businessAdded'] = time();
							}
							else{
								unset($_SESSION['businessAdded']);
							}
						}
					$dataTable .= '</tbody>
				</table>';
			}
			
			$data = $_SESSION['businessAdded'];
			$dataDetails = array("header"=>"successful","message" => "$dataTable","businessAdded"=>"$data");
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='delete-business'){
			$businessId = mysqli_real_escape_string($db_conn, $_POST['busId']);
			if(isset($_SESSION['edit_trader'])){
				$deleteBusiness = mysqli_query($db_conn, "UPDATE tbl_businesses SET status=0 WHERE biz_id='$businessId'");
				if($deleteBusiness===true){
					$dataDetails = array("header"=>"successful","message" => "Record Deleted"); 
				}
				else{
					$error = mysqli_error($db_conn);
					$dataDetails = array("header"=>"error","message" => "$error"); 
				}
			}
			else{
				$index = intval($businessId);
				if(isset($_SESSION['businessDetails'][$index])) {
					unset($_SESSION['businessDetails'][$index]);
					$_SESSION['businessDetails'] = array_values($_SESSION['businessDetails']);
					$dataDetails = array("header"=>"successful","message" => "Record Deleted"); 
				} else {
					$dataDetails = array("header"=>"error","message" => "Record Not Found"); 
				}
			}
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='load-edit-business'){
			$indexToEdit = intval($_POST['bizIndex']);
			$businessToEdit = $_SESSION['businessDetails'][$indexToEdit];
			$editCity = '<option value="'.$businessToEdit['businessCity'].'">'.getCityName($businessToEdit['businessCity']).'</option>';
			$marketId = $businessToEdit['market'];
			$market = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT market_name FROM tbl_markets WHERE market_id='$marketId' LIMIT 1"));
			$market = $market['market_name'];
			
			$editMarket = '<option value="'.$marketId.'">'.$market.'</option>';
?>
			<script>
				$("#editState").on('change', function(){
					var state = $(this).val();
					//alert(state);
					if(state){
						$(this).removeClass('is-invalid');
						$.ajax({
							type: 'POST',
							url:'resources/scripts/settings/website.php',
							data:'action=load-new-cities&stateid='+state,
							success:function(responseData){
								$("#editCityMarket").html(responseData);
							}
						});
					}
					else{
						$("#editCityMarket").html('<option value="">Select State First</option>');
						$(this).addClass('is-invalid');
					}
				});
				
				$("#editCityMarket").on('change', function(){
					var city = $(this).val();
					//alert(state);
					if(city){
						$(this).removeClass('is-invalid');
						$.ajax({
							type: 'POST',
							url:'resources/scripts/enumeration/scripts.php',
							data:'action=load-markets&cityid='+city,
							success:function(responseData){
								//alert(responseData);
								$("#editMarket").html(responseData);
							}
						});
					}
					else{
						$(this).addClass('is-invalid');
						$("#editMarket").html('<option value="">Select Market LGA first</option>');
					}
				})
			</script>
			<div class="row">
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>State</label>
						<select class="select" id="editState">
						<?php
							$queryState = mysqli_query($db_conn, "SELECT * FROM states WHERE country_id='$nigeriaId' ORDER BY state_name ASC");
							$stateId = $businessToEdit['businessState'];
							while($state=mysqli_fetch_assoc($queryState)){
								if($stateId==$state['state_id']){
									echo '<option selected value="'.$state['state_id'].'">'.$state['state_name'].'</option>';	
								}
								else{
									echo '<option value="'.$state['state_id'].'">'.$state['state_name'].'</option>';	
								}
							}
						?>
						</select>
						<div class="invalid-feedback">
							Select State of
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>LGA</label>
						<select class="select" id="editCityMarket">
							<?php echo $editCity; ?>
						</select>
						<div class="invalid-feedback">
							Select LGA
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>Market</label>
						<select class="select" id="editMarket">
							<?php echo $editMarket; ?>
						</select>
						<div class="invalid-feedback">
							Select Market
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6" id="shopNumberPanel" style="display: none;">
					<div class="input-block mb-3">
						<label>Shop Number</label>
						<input id="editShopNumber" value="<?php echo $businessToEdit['shopNumber']; ?>" type="text" class="form-control" placeholder="Shop number">
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>Nature of Business</label>
						<input id="editNatureOfBusiness" value="<?php echo $businessToEdit['natureOfBusiness']; ?>" type="text" class="form-control" placeholder="Nature of business">
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>Business Category</label>
						<select class="select2" id="editBusinessCategory">
							<?php
								$queryCategory = mysqli_query($db_conn, "SELECT * FROM tbl_business_category WHERE status=1 ORDER BY name ASC");
								$activeCat = $businessToEdit['businessCategory'];
								while($category = mysqli_fetch_assoc($queryCategory)){
									if($category['name']==$activeCat){
										echo '<option selected value="'.$category['name'].'">'.$category['name'].'</option>';
									}
									else{
										echo '<option value="'.$category['name'].'">'.$category['name'].'</option>';
									}
								}
							?>
						</select>
						<div class="invalid-feedback">
							Select Business Category
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>Business Scale</label>
						<select class="select2" id="editBusinessScale">
							<?php
								$queryScale = mysqli_query($db_conn, "SELECT * FROM tbl_business_scale WHERE status=1");
								$bizScale = $businessToEdit['businessScale'];
								while($scale = mysqli_fetch_assoc($queryScale)){
									if($scale['scale']==$bizScale){
										echo '<option selected value="'.$scale['scale'].'">'.$scale['scale'].'</option>';
									}
									else{
										echo '<option value="'.$scale['scale'].'">'.$scale['scale'].'</option>';
									}
								}
							?>
						</select>
						<div class="invalid-feedback">
							Select Business Scale
						</div>
					</div>
				</div>
				<div class="col-md-12">
					<div class="input-block mb-3">
						<label>Business Address</label>
						<textarea class="form-control" value="<?php echo $businessToEdit['businessAddress']; ?>" id="editBusinessAddress" rows="5" placeholder="Enter Business Address"></textarea>
						<div class="invalid-feedback">
							Input Address
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>Business Phone</label>
						<input id="editBusinessPhone" value="<?php echo $businessToEdit['businessPhone']; ?>" type="text" class="form-control" placeholder="Business Phone">
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>Business Email (Optional)</label>
						<input id="editBusinessEmail" value="<?php echo $businessToEdit['businessEmail']; ?>" type="text" class="form-control" placeholder="Business Email">
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>Name of Company(Optional)</label>
						<input id="editCompanyName" value="<?php echo $businessToEdit['companyName']; ?>" type="text" class="form-control" placeholder="Name of Company">
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>RC Number(Optional)</label>
						<input id="editCompanyNumber" value="<?php echo $businessToEdit['companyNumber']; ?>" type="text" class="form-control" placeholder="Company Number">
					</div>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-6">
					<div class="input-block mb-3">
						<label>TIN Number(If Available)</label>
						<input id="editCompanyTin" value="<?php echo $businessToEdit['companyTin']; ?>" type="text" class="form-control" placeholder="Company TIN">
					</div>
				</div>
				<input type="text" id="editId" value="<?php echo $indexToEdit; ?>" />
				<div class="col-md-12" id="editBzMsgBox"></div>
			</div>
<?php
		}
		elseif($_POST['action']=='add-farms'){
			$businessState = mysqli_real_escape_string($db_conn, $_POST['businessState']);
			$businessCity = mysqli_real_escape_string($db_conn, $_POST['businessCity']);
			$market = mysqli_real_escape_string($db_conn, $_POST['market']);
			$shopNumber = addslashes(mysqli_real_escape_string($db_conn, $_POST['shopNumber']));
			$natureOfBusiness = mysqli_real_escape_string($db_conn, $_POST['natureOfBusiness']);
			$businessCategory = mysqli_real_escape_string($db_conn, $_POST['businessCategory']);
			$businessScale = mysqli_real_escape_string($db_conn, $_POST['businessScale']);
			$businessAddress = addslashes(mysqli_real_escape_string($db_conn, $_POST['businessAddress']));
			$businessTown = addslashes(mysqli_real_escape_string($db_conn, $_POST['businessTown']));
			$businessPhone = mysqli_real_escape_string($db_conn, $_POST['businessPhone']);
			$businessEmail = mysqli_real_escape_string($db_conn, $_POST['businessEmail']);
			$companyName = addslashes(mysqli_real_escape_string($db_conn, $_POST['companyName']));
			$companyNumber = addslashes(mysqli_real_escape_string($db_conn, $_POST['companyNumber']));
			$companyTin = addslashes(mysqli_real_escape_string($db_conn, $_POST['companyTin']));
			
			if(isset($_SESSION['edit_farmer'])){
				/////check if this already exists///////
				$queryFarm = mysqli_query($db_conn, "SELECT * FROM tbl_businesses WHERE shopnumber='$shopNumber'
					AND businessphone='$businessPhone' AND businessname='$companyName' AND businessaddress='$businessAddress'
					AND businessstate='$businessState' AND businesscale='$businessScale' AND businesscategory='$businessCategory'
				");
				if(mysqli_num_rows($queryComp)>0){
					$dataDetails = array("header"=>"error","message" => "Business already added");
				}
				else{
					//////insert the company//////
					$matanId = $_SESSION['matanid'];
					$businessId = $appInitial.'-'.mt_rand(100000,999999);
					$insertBusiness = mysqli_query($db_conn, "INSERT INTO tbl_businesses SET
						biz_id = '$businessId',
						trader_id = '$matanId',
						businessname = '$companyName',
						businessnumber = '$companyNumber',
						businessphone = '$businessPhone',
						businessemail = '$businessEmail',
						marketid = '$market',
						shopnumber = '$shopNumber',
						businessaddress = '$businessAddress',
						natureofbusiness = '$natureOfBusiness',
						businesscategory = '$businessCategory',
						businesscale = '$businessScale',
						businesstin = '$companyTin',
						businessstate = '$businessState',
						businesslga = '$businessCity',
						businesstown = '$businessTown'
					");
					
					if($insertBusiness===true){
						$dataDetails = array("header"=>"successful","message" => "Successfully added","businessAdded"=>"added");
					}
					else{
						$error = mysqli_error($db_conn);
						$dataDetails = array("header"=>"error","message" => "$error");
					}
				}
			}
			else{
				if (!isset($_SESSION['businessDetails'])) {
					$_SESSION['businessDetails'] = array();
				}
				$businessDetail = array(
					"businessState" => "$businessState",
					"businessCity" => "$businessCity",
					"market" => "$market",
					"shopNumber" => "$shopNumber",
					"natureOfBusiness" => "$natureOfBusiness",
					"businessCategory" => "$businessCategory",
					"businessScale" => "$businessScale",
					"businessAddress" => "$businessAddress",
					"businessTown" => "$businessTown",
					"businessPhone" => "$businessPhone",
					"businessEmail" => "$businessEmail",
					"companyName" => "$companyName",
					"companyNumber" => "$companyNumber",
					"companyTin" => "$companyTin"
				);
				
				// Check if the session array already exists
				if (isset($_SESSION['businessDetails'])) {
					$businessDetails = $_SESSION['businessDetails'];

					// Flag to indicate if a match is found
					$isDuplicate = false;

					// Loop through the array to check if the new data already exists
					foreach ($businessDetails as $record) {
						// Check if all fields match exactly
						if(
							$record['businessState'] == $businessDetail['businessState'] &&
							$record['businessCity'] == $businessDetail['businessCity'] &&
							$record['market'] == $businessDetail['market'] &&
							$record['shopNumber'] == $businessDetail['shopNumber'] &&
							$record['natureOfBusiness'] == $businessDetail['natureOfBusiness'] &&
							$record['businessCategory'] == $businessDetail['businessCategory'] &&
							$record['businessScale'] == $businessDetail['businessScale'] &&
							$record['businessAddress'] == $businessDetail['businessAddress'] &&
							$record['businessPhone'] == $businessDetail['businessPhone'] &&
							$record['businessEmail'] == $businessDetail['businessEmail'] &&
							$record['companyName'] == $businessDetail['companyName'] &&
							$record['companyNumber'] == $businessDetail['companyNumber'] &&
							$record['companyTin'] == $businessDetail['companyTin']
						){
							$isDuplicate = true;
							break;
						}
					}
					
					if($isDuplicate===true){
						$dataDetails = array("header"=>"error","message" => "This Record was already added");
					}
					else{
						addFarmRecord($businessDetail);
						$_SESSION['businessAdded'] = time();
						$data = $_SESSION['businessAdded'];
						$dataDetails = array("header"=>"successful","message" => "Successfully added","businessAdded"=>"$data");
					}
				}
				else{
					addFarmRecord($businessDetail);
					$_SESSION['businessAdded'] = time();
					$data = $_SESSION['businessAdded'];
					$dataDetails = array("header"=>"successful","message" => "Successfully added","businessAdded"=>"$data");
				}
			}
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='fetch-farms'){
			$dataTable = '<table class="table table-center table-hover datatable">
				<thead class="thead-light">
					<tr>
						<td>S/N</td>
						<td>Nature</td>
						<td>Category</td>
						<td>State</td>
						<td>LGA</td>
						<td>Market</td>
						<td>Scale</td>
						<td>Phone</td>
						<td>Email</td>
						<td></td>
					</tr>
				</thead>
				<tbody>';
					
					$counter = 1; // To maintain the S/N

					if(!isset($_SESSION['edit_trader'])){
						// Loop through the session records and display them in the table
						foreach ($_SESSION['businessDetails'] as $index => $business) {
							$market = $business['market'];
							$market = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT market_name FROM tbl_markets WHERE market_id='$market' LIMIT 1"));
							$market = $market['market_name'];
							$dataTable .= "<tr>";
							$dataTable .= "<td>" . $counter . "</td>";
							$dataTable .= "<td>" . $business['natureOfBusiness'] . "</td>";
							$dataTable .= "<td>" . $business['businessCategory'] . "</td>";
							$dataTable .= "<td>" . getStateName($business['businessState']) . "</td>";
							$dataTable .= "<td>" . getCityName($business['businessCity']) . "</td>";
							$dataTable .= "<td>" . $market . "</td>";
							$dataTable .= "<td>" . $business['businessScale'] . "</td>";
							$dataTable .= "<td>" . $business['businessPhone'] . "</td>";
							$dataTable .= "<td>" . $business['businessEmail'] . "</td>";
							$dataTable .= '<td>
								<a href="javascript:void(0);" data-id="'.$index.'" data-bs-toggle="modal" data-bs-target="#delete_business">
									<i class="fas fa-trash text-danger"></i>
								</a> 
								<a href="javascript:void(0);" data-id="'.$index.'" data-bs-toggle="modal" data-bs-target="#edit_business">
									<i class="fas fa-edit text-primary"></i>
								</a>
							</td>';
							$dataTable .= "</tr>";
							$counter++;
						}
					}
					else{
						$matanId = $_SESSION['matanid'];
						$queryBusinesses = mysqli_query($db_conn, "SELECT * FROM tbl_businesses WHERE trader_id='$matanId' AND status!=0");
						if(mysqli_num_rows($queryBusinesses)>0){
							while($business=mysqli_fetch_assoc($queryBusinesses)) {
								$market = $business['marketid'];
								$market = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT market_name FROm tbl_markets WHERE market_id='$market' LIMIT 1"));
								$market = $market['market_name'];
								$dataTable .= "<tr>";
								$dataTable .= "<td>" . $counter . "</td>";
								$dataTable .= "<td>" . $business['natureofbusiness'] . "</td>";
								$dataTable .= "<td>" . $business['businesscategory'] . "</td>";
								$dataTable .= "<td>" . getStateName($business['businessstate']) . "</td>";
								$dataTable .= "<td>" . getCityName($business['businesslga']) . "</td>";
								$dataTable .= "<td>" . $market . "</td>";
								$dataTable .= "<td>" . $business['businesscale'] . "</td>";
								$dataTable .= "<td>" . $business['businessphone'] . "</td>";
								$dataTable .= "<td>" . $business['businessemail'] . "</td>";
								$dataTable .= '<td>
									<a href="javascript:void(0);" data-id="'.$business['biz_id'].'" data-bs-toggle="modal" data-bs-target="#delete_business">
										<i class="fas fa-trash text-danger"></i>
									</a> 
									<a href="javascript:void(0);" data-id="'.$business['biz_id'].'" data-bs-toggle="modal" data-bs-target="#edit_business">
										<i class="fas fa-edit text-primary"></i>
									</a>
								</td>';
								$dataTable .= "</tr>";
								$counter++;
							}
							
							$_SESSION['businessAdded'] = time();
						}
						else{
							unset($_SESSION['businessAdded']);
						}
					}
				$dataTable .= '</tbody>
			</table>';
			
			$data = $_SESSION['businessAdded'];
			$dataDetails = array("header"=>"successful","message" => "$dataTable","businessAdded"=>"$data");
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='delete-farm'){
			$farmId = mysqli_real_escape_string($db_conn, $_POST['farmId']);
			if(isset($_SESSION['edit_farmer'])){
				$deleteFarm = mysqli_query($db_conn, "UPDATE tbl_farms SET status=0 WHERE biz_id='$businessId'");
				if($deleteBusiness===true){
					$dataDetails = array("header"=>"successful","message" => "Record Deleted"); 
				}
				else{
					$error = mysqli_error($db_conn);
					$dataDetails = array("header"=>"error","message" => "$error"); 
				}
			}
			else{
				$index = intval($businessId);
				if(isset($_SESSION['businessDetails'][$index])) {
					unset($_SESSION['businessDetails'][$index]);
					$_SESSION['businessDetails'] = array_values($_SESSION['businessDetails']);
					$dataDetails = array("header"=>"successful","message" => "Record Deleted"); 
				} else {
					$dataDetails = array("header"=>"error","message" => "Record Not Found"); 
				}
			}
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='back-btn'){
			if($_SESSION['page']!='1'){
				$_SESSION['page'] = $_SESSION['page']-1;
			}
			else{
				unset($_SESSION['page']);
			}
			$dataDetails = array("header"=>"successful","message" => "Done"); 
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='upload-signature'){
            
            /* Getting file name */
            $filename = $_FILES['file']['name'];
            
            $target_webdir = $dir."assets/img/signatures/";
			if(!is_dir($dir."assets/img/signatures/")){
				mkdir($dir."assets/img/signatures/");
			}
			
            $image = $target_webdir . basename($filename);
            $imageFileType = strtolower(pathinfo($image,PATHINFO_EXTENSION));
            if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" ) {
                $dataDetails = [
                    "header"=> "Invalid file",
                    "data"=> "",
                    "message" => "Only JPEG, JPG or PNG files allowed"
                ]; 
            }
            else{
                ////get the image extension////////
                $ext = explode(".", $image);
                $ext = strtolower(end($ext));
                $newName = strtolower($_SESSION['firstname'].'-'.$_SESSION['lastname'])."-".mt_rand(00000000000, time()).'.'.$ext;
                $newName = str_replace(' ', '', $newName);
                
				if(move_uploaded_file($_FILES["file"]["tmp_name"], $target_webdir.$newName)) {
                    if(isset($_SESSION['signature'])){
						$formerName = $_SESSION['signature'];
					}
					else{
						$formerName = '';
					}
					
					if(isset($_SESSION['edit_trader'])){
						$matanId = $_SESSION['matanid'];
						mysqli_query($db_conn, "UPDATE tbl_traders_enumeration SET signature='$newName' WHERE matan_id='$matanId' LIMIT 1");
					}
					$_SESSION['signature'] = $newName;
					
					if(isset($formerName)){
						unlink($target_webdir.$formerName);
					}
					
					$displayImage = str_replace($dir,'',$target_webdir.$newName);
					$dataDetails = array(
						"header"=> "successful",
						"data"=> "$displayImage",
						"message" => "Signature Uploaded"
					); 
                }else {
                    $dataDetails = [
                        "header"=> "file not uploaded",
                        "data"=> "",
                        "message" => "Could not upload the image file"
                    ]; 
                }
            }

            echo json_encode($dataDetails);
        }
		elseif($_POST['action']=='upload-passport'){
            
            /* Getting file name */
            $filename = $_FILES['file']['name'];
            
            $target_webdir = $dir."assets/img/users/";
			if(!is_dir($dir."assets/img/users/")){
				mkdir($dir."assets/img/users/");
			}
            $image = $target_webdir . basename($filename);
            $imageFileType = strtolower(pathinfo($image,PATHINFO_EXTENSION));
            if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" ) {
                $dataDetails = [
                    "header"=> "Invalid file",
                    "data"=> "",
                    "message" => "Only JPEG, JPG or PNG files allowed"
                ]; 
            }
            else{
                ////get the image extension////////
                $ext = explode(".", $image);
                $ext = strtolower(end($ext));
                $newName = strtolower($_SESSION['firstname'].'-'.$_SESSION['lastname'])."-".mt_rand(00000000000, time()).'.'.$ext;
                $newName = str_replace(' ', '', $newName);
                
				if(move_uploaded_file($_FILES["file"]["tmp_name"], $target_webdir.$newName)) {
                    if(isset($_SESSION['passport'])){
						$formerName = $_SESSION['passport'];
					}
					else{
						$formerName = '';
					}
					
					if(isset($_SESSION['edit_trader'])){
						$matanId = $_SESSION['matanid'];
						mysqli_query($db_conn, "UPDATE tbl_traders_enumeration SET passport='$newName' WHERE matan_id='$matanId' LIMIT 1");
					}
					
					$_SESSION['passport'] = $newName;
					
					if(isset($formerName)){
						unlink($target_webdir.$formerName);
					}
					
					$displayImage = str_replace($dir,'',$target_webdir.$newName);
					$dataDetails = array(
						"header"=> "successful",
						"data"=> "$displayImage",
						"message" => "Passport Uploaded"
					); 
                }else {
                    $dataDetails = [
                        "header"=> "file not uploaded",
                        "data"=> "",
                        "message" => "Could not upload the Passport"
                    ]; 
                }
            }

            echo json_encode($dataDetails);
        }
		elseif($_POST['action']=='generate-account'){
			/* $dataDetails = array(
				"header"=> "successful",
				"message" => "<h1 class=\"\"><i class=\"fas fa-check-circle text-success\"></i></h1>The <b class=\"text-primary\">Bank account</b> and <b class=\"text-primary\">JTB TIN</b> were successfully generated. Kindly print the Acknowledgement slip."
			); */ 
			$dataDetails = array(
				"header"=> "Error",
				"message" => "The <b class=\"text-danger\">Bank account</b> and <b class=\"text-danger\">JTB TIN</b> could not be generated at the moment.<br>Don't worry, you can save this and generate later"
			); 
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='generate-bank-account'){
			$matanId = $_POST['matanid'];
			$queryTrader = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE matan_id='$matanId' LIMIT 1");
			
			if(mysqli_num_rows($queryTrader)>0){
				$traderDetails = mysqli_fetch_assoc($queryTrader);
				$traderName = $traderDetails['lastname'].' '.$traderDetails['firstname'].' '.$traderDetails['middlename'];
				if(empty($traderDetails['passport']) || empty($traderDetails['signature'])){
					$dataDetails = array(
						"header"=> "Error",
						"message" => "<h3 class=\"text-primary\"><i class=\"fas fa-times-circle\"></i> Update Required</h3>
							<br>You need to update the remaining details on this account "
					); 
				}
				else{
					////////generate bank account script///////
					$dataDetails = array(
						"header"=> "Error",
						"message" => "<h3 class=\"text-danger\"><i class=\"fas fa-times-circle\"></i> Error Occurred</h3>
							<br>The <b class=\"text-danger\">Bank account</b> and <b class=\"text-danger\">JTB TIN</b> generation for <b><u>$traderName</u></b> could not be completed at the moment.
							<br>Please, try again later and if this error persists kindly contact the MATAN National Admin"
					); 
				}
				
			}
			else{
				$dataDetails = array(
					"header"=> "Error",
					"message" => "<h3 class=\"text-danger\"><i class=\"fas fa-times-circle\"></i> Error Occurred</h3><br>We could not find any record for the Trader you are trying to Generate Bank account for."
				); 
			}
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='edit-trader-details'){
			$matanId = $_POST['matanid'];
			$queryTrader = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE matan_id='$matanId' LIMIT 1");
			if(mysqli_num_rows($queryTrader)>0){
				$traderDetails = mysqli_fetch_assoc($queryTrader);
				$_SESSION['matanid'] = $matanId;
				$_SESSION['nin'] = $traderDetails['nin'];
				$_SESSION['bvn'] = $traderDetails['bvn'];
				$_SESSION['dateOfBirth'] = $traderDetails['dateofbirth'];
				$_SESSION['gender'] = $traderDetails['gender'];
				$_SESSION['maritalStatus'] = $traderDetails['maritalstatus'];
				$_SESSION['genotype'] = $traderDetails['genotype'];
				$_SESSION['bloodGroup'] = $traderDetails['bloodgroup'];
				$_SESSION['stateOfOrigin'] = $traderDetails['stateoforigin'];
				$_SESSION['lgaOfOrigin'] = $traderDetails['lgaoforigin'];
				$_SESSION['houseNumber'] = $traderDetails['housenumber'];
				$_SESSION['streetName'] = $traderDetails['streetname'];
				$_SESSION['stateOfResidence'] = $traderDetails['stateofresidence'];
				$_SESSION['residenceCity'] = $traderDetails['cityofresidence'];
				$_SESSION['lgaOfResidence'] = $traderDetails['lgaofresidence']; 
				$_SESSION['firstname'] = $traderDetails['firstname'];
				$_SESSION['lastname'] = $traderDetails['lastname'];
				$_SESSION['middlename'] = $traderDetails['middlename'];
				$_SESSION['email'] = $traderDetails['email'];
				$_SESSION['phone'] = $traderDetails['phone'];
				$_SESSION['title'] = $traderDetails['title'];
				$_SESSION['signature'] = $traderDetails['signature'];
				$_SESSION['passport'] = $traderDetails['passport'];
								
				$_SESSION['page'] = '0';
				$_SESSION['edit_trader'] = 'Edit Trader';
				
				$dataDetails = array(
					"header"=> "successful",
					"message" => "<h3>Loading...<i class='fa fa-spinner fa-spin'></i></h3>"
				); 
			}
			else{
				$dataDetails = array(
					"header"=> "Error",
					"message" => "<h3 class=\"text-danger\"><i class=\"fas fa-times-circle\"></i> Error Occurred</h3><br>We could not find any record for the Trader you are trying to Generate Bank account for."
				); 
			}
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='start-over'){
			echo exitEnumeration();
		}
		elseif($_POST['action']=='print-slip'){
			$_SESSION['print'] = $_SESSION['matanid'];
			exitEnumeration();
			$_SESSION['session'] = 'traders/print-slip.php';
			$dataDetails = array(
				"header"=> "successful",
				"message" => "Print Initiated"
			); 
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='save-details'){
			$_SESSION['matanid'] = 'MATAN-'.mt_rand(10000,99999).'-'.mt_rand(10000,99999);
			$nin = $_SESSION['nin'];
			$bvn = $_SESSION['bvn'];
			$dateOfBirth = $_SESSION['dateOfBirth'];
			$gender = $_SESSION['gender'];
			$maritalStatus = $_SESSION['maritalStatus'];
			$genotype = $_SESSION['genotype'];
			$bloodGroup = $_SESSION['bloodGroup'];
			$stateOfOrigin = $_SESSION['stateOfOrigin'];
			$lgaOfOrigin = $_SESSION['lgaOfOrigin'];
			$houseNumber = $_SESSION['houseNumber'];
			$streetName = $_SESSION['streetName'];
			$stateOfResidence = $_SESSION['stateOfResidence'];
			$residenceCity = $_SESSION['residenceCity'];
			$lgaOfResidence = $_SESSION['lgaOfResidence']; 
			$firstname = $_SESSION['firstname'];
			$lastname = $_SESSION['lastname'];
			$middlename = $_SESSION['middlename'];
			$email = $_SESSION['email'];
			$phone = $_SESSION['phone'];
			$title = $_SESSION['title'];
			$matanId = $_SESSION['matanid'];
			$signature = $_SESSION['signature'];
			$passport = $_SESSION['passport'];
			
			$accountNumber = $_SESSION['accountnumber'];
			$accountName = $_SESSION['accountname'];
			$bankName = $_SESSION['bankname'];
			$jtbTin = $_SESSION['jtbtin'];
			
			mysqli_query($db_conn, "CREATE TABLE IF NOT EXISTS tbl_traders_enumeration(
					id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
					matan_id VARCHAR(30) NOT NULL UNIQUE KEY,
					title VARCHAR(50) NOT NULL,
					firstname VARCHAR(50) NOT NULL,
					lastname VARCHAR(50) NOT NULL,
					middlename VARCHAR(50) NOT NULL,
					email VARCHAR(100) NOT NULL,
					phone VARCHAR(20) NOT NULL,
					nin VARCHAR(15) NOT NULL UNIQUE KEY,
					bvn VARCHAR(15) NOT NULL UNIQUE KEY,
					dateofbirth VARCHAR(10) NOT NULL,
					gender VARCHAR(10) NOT NULL,
					maritalstatus VARCHAR(20) NOT NULL,
					genotype VARCHAR(5) NOT NULL,
					bloodgroup VARCHAR(5) NOT NULL,
					stateoforigin VARCHAR(50) NOT NULL,
					lgaoforigin VARCHAR(50) NOT NULL,
					housenumber VARCHAR(20) NOT NULL,
					streetname VARCHAR(200) NOT NULL,
					stateofresidence VARCHAR(20) NOT NULL,
					lgaofresidence VARCHAR(50) NOT NULL,
					cityofresidence VARCHAR(100) NOT NULL,
					signature VARCHAR(200) NOT NULL,
					passport VARCHAR(200) NOT NULL,
					bankname VARCHAR(100),
					accountnumber VARCHAR(11),
					accountname VARCHAR(100),
					accounttype VARCHAR(50),
					jtbtin VARCHAR(20),
					firstin VARCHAR(20),
					cardstatus VARCHAR(50),
					dateadded VARCHAR(30) NOT NULL,
					addedby VARCHAR(100) NOT NULL,
					status VARCHAR(50) NOT NULL
				)
			");
			/////insert the record/////////
			$dateAdded = date("Y-m-d h:i:s a", time());
			if(isset($accountNumber) && isset($jtbTin)){
				$status = 'Complete';
				$enumerationStatusMsg = "The enumeration for $lastname $firstname $middlename was successfully completed with <b>Account Number</b> and <b>JTB TIN</b> successfully generated.";
				$enumHeading = 'Complete Enumeration';
			}
			else{
				$status = 'Incomplete';
				$enumerationStatusMsg = "The enumeration for $lastname $firstname $middlename was saved. You will have to generate account number later to complete the enumeration.";
				$enumHeading = 'Incomplete Enumeration';
			}
			
			/////check if the record already added/////////
			$checkRecord = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE
				title = '$title' AND firstname = '$firstname' AND lastname = '$lastname' AND middlename = '$middlename' AND
				email = '$email' AND phone = '$phone' AND nin = '$nin' AND bvn = '$bvn' AND dateofbirth = '$dateOfBirth' AND
				gender = '$gender' AND maritalstatus = '$maritalStatus' AND genotype = '$genotype' AND
				bloodgroup = '$bloodGroup' AND stateoforigin = '$stateOfOrigin' AND
				lgaoforigin = '$lgaOfOrigin' AND housenumber = '$houseNumber' AND streetname = '$streetName' AND
				stateofresidence = '$stateOfResidence' AND lgaofresidence = '$lgaOfResidence' AND
				cityofresidence = '$residenceCity' AND signature = '$signature' AND
				passport = '$passport' AND bankname = '$bankName' AND accountnumber = '$accountNumber' AND
				accountname = '$accountName' AND accounttype = '$accountType' AND jtbtin = '$jtbTin' AND
				firstin = '$firsTin' AND cardstatus = '$cardStatus'
			");
			
			if(mysqli_num_rows($checkRecord)<1){
				$insertRecord = mysqli_query($db_conn, "INSERT INTO tbl_traders_enumeration SET
					matan_id = '$matanId',
					title = '$title',
					firstname = '$firstname',
					lastname = '$lastname',
					middlename = '$middlename',
					email = '$email',
					phone = '$phone',
					nin = '$nin',
					bvn = '$bvn',
					dateofbirth = '$dateOfBirth',
					gender = '$gender',
					maritalstatus = '$maritalStatus',
					genotype = '$genotype',
					bloodgroup = '$bloodGroup',
					stateoforigin = '$stateOfOrigin',
					lgaoforigin = '$lgaOfOrigin',
					housenumber = '$houseNumber',
					streetname = '$streetName',
					stateofresidence = '$stateOfResidence',
					lgaofresidence = '$lgaOfResidence',
					cityofresidence = '$residenceCity',
					signature = '$signature',
					passport = '$passport',
					bankname = '$bankName',
					accountnumber = '$accountNumber',
					accountname = '$accountName',
					accounttype = '$accountType',
					jtbtin = '$jtbTin',
					firstin = '$firsTin',
					cardstatus = '$cardStatus',
					dateadded = '$dateAdded',
					addedby = '$myId',
					status = '$status'
				");
			
				if($insertRecord===true){
					///first create the table/////////
					mysqli_query($db_conn, "CREATE TABLE IF NOT EXISTS tbl_businesses(
							id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
							trader_id VARCHAR(50) NOT NULL,
							biz_id VARCHAR(20) NOT NULL,
							businessname VARCHAR(200) NULL,
							businessnumber VARCHAR(30) NULL,
							businessphone VARCHAR(20) NOT NULL,
							businessemail VARCHAR(100) NOT NULL,
							marketid VARCHAR(30) NOT NULL,
							shopnumber VARCHAR(20),
							businessaddress VARCHAR(100) NOT NULL,
							natureofbusiness VARCHAR(100) NOT NULL,
							businesscategory VARCHAR(100) NOT NULL,
							businesscale VARCHAR(100) NOT NULL,
							businesstin VARCHAR(30) NOT NULL,
							businessstate VARCHAR(20) NOT NULL,
							businesslga VARCHAR(20) NOT NULL,
							businesstown VARCHAR(100) NOT NULL,
							status INT DEFAULT '1'
						)
					");
					
					////insert the businesses/////
					foreach ($_SESSION['businessDetails'] as $index => $business) {
						$market = $business['market'];
						$natureOfBusiness = $business['natureOfBusiness'];
						$businessCategory = $business['businessCategory'];
						$businessState = $business['businessState'];
						$businessCity = $business['businessCity'];
						$businessScale = $business['businessScale'];
						$businessPhone = $business['businessPhone'];
						$businessEmail = $business['businessEmail'];
						$shopNumber = $business['shopNumber'];
						$businessAddress = $business['businessAddress'];
						$companyName = $business['companyName'];
						$companyNumber = $business['companyNumber'];
						$companyTin = $business['companyTin'];
						$businessTown = $business['businessTown'];
						$matanId = $_SESSION['matanid'];
						
						$businessId = $appInitial.'-'.mt_rand(100000,999999);
						
						mysqli_query($db_conn, "INSERT INTO tbl_businesses SET
							biz_id = '$businessId',
							trader_id = '$matanId',
							businessname = '$companyName',
							businessnumber = '$companyNumber',
							businessphone = '$businessPhone',
							businessemail = '$businessEmail',
							marketid = '$market',
							shopnumber = '$shopNumber',
							businessaddress = '$businessAddress',
							natureofbusiness = '$natureOfBusiness',
							businesscategory = '$businessCategory',
							businesscale = '$businessScale',
							businesstin = '$companyTin',
							businessstate = '$businessState',
							businesslga = '$businessCity',
							businesstown = '$businessTown'
						");
						
						$counter++;
					}
					
					$_SESSION['print'] = $_SESSION['matanid'];
					exitEnumeration();
			
					$dataDetails = array(
						"header"=> "successful",
						"heading"=> "enumHeading",
						"message" => "$enumerationStatusMsg"
					);
				}
				else{
					$error = mysqli_error($db_conn);
					$dataDetails = array(
						"header"=> "Error",
						"message" => "Error Occurred: $error"
					);
				}
			}
			else{
				exitEnumeration();
				
				$dataDetails = array(
					"header"=> "Error",
					"message" => "This user record already added."
				);
			}
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='exit-edit-trader'){
			unset($_SESSION['edit_trader']);
			exitEnumeration();
			$_SESSION['session'] = 'traders/view.php';
			$dataDetails = array(
				"header"=> "successful",
				"message" => "Trader Editing Completed"
			);
			
			echo json_encode($dataDetails);
		}
		elseif($_POST['action']=='load-markets'){
			$cityId = $_POST['cityid'];
			$queryMarkets = mysqli_query($db_conn, "SELECT * FROM tbl_markets WHERE city='$cityId' AND status=1");
			if(mysqli_num_rows($queryMarkets)>0){
				$dataDetails = '<option value="">Select Market</option>';
				while($market=mysqli_fetch_assoc($queryMarkets)){
					$dataDetails .= '<option value="'.$market['market_id'].'">'.$market['market_name'].'</option>';
				}
			}
			else{
				$dataDetails = '<option value="">Markets not available</option>';
			}
			echo $dataDetails;
		}
		elseif($_POST['action']=='load-states'){
			$getStates = mysqli_query($db_conn, "SELECT * FROM states WHERE status=1 AND country_id='$nigeriaId'");
			if(mysqli_num_rows($getStates)>0){
				$dataDetails = '<option value="">Select State</option>';
				while($state=mysqli_fetch_assoc($getStates)){
					$dataDetails .= '<option value="'.$state['state_id'].'">'.$state['state_name'].'</option>';
				}
			}
			else{
				$dataDetails = '<option value="">States not available</option>';
			}
			echo $dataDetails;
		}
		elseif($_POST['action']=='load-project-states'){
			$getStates = mysqli_query($db_conn, "SELECT * FROM states WHERE status=1 AND country_id='$nigeriaId'");
			if(mysqli_num_rows($getStates)>0){
				$dataDetails = '<option value="">Select State</option>';
				while($state=mysqli_fetch_assoc($getStates)){
					$dataDetails .= '<option value="'.$state['state_id'].'">'.$state['state_name'].'</option>';
				}
			}
			else{
				$dataDetails = '<option value="">States not available</option>';
			}
			echo $dataDetails;
		}
		elseif($_POST['action']=='load-projects'){
			$userType = $user['user_type'];
			$dataDetails = '';
			if($userType=='National Project Manager' || $userType=='State Project Manager' || $userType=='LG Project Manager'){
				$projectId = $user['dept_id'];
				$project = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT project_name FROM tbl_projects WHERE project_id='$projectId'"));
				$dataDetails .= '<option value="'.$projectId.'">'.$project['project_name'].'</option>';
			}
			elseif($userType=='Super Administrator' || $userType=='Administrator'){
				$queryProjects = mysqli_query($db_conn, "SELECT * FROM tbl_projects WHERE status=1");
				if(mysqli_num_rows($queryProjects)>0){
					$dataDetails .= '<option value="">Select Project</option>';
					while($project=mysqli_fetch_assoc($queryProjects)){
						$dataDetails .= '<option value="'.$project['project_id'].'">'.$project['project_name'].'</option>';
					}
				}
				else{
					$dataDetails .= '<option value="">No Projects Available</option>';
				}
			}
			echo $dataDetails;
		}
		elseif($_POST['action']=='load-business-category'){
			$queryCategory = mysqli_query($db_conn, "SELECT * FROM tbl_business_category WHERE status=1 ORDER BY name ASC");
			if(mysqli_num_rows($queryCategory)>0){
				$dataDetails = '<option value="">Select Business Category</option>';
				while($category = mysqli_fetch_assoc($queryCategory)){
					$dataDetails .= '<option value="'.$category['name'].'">'.$category['name'].'</option>';
				}
			}
			else{
				$dataDetails = '<option value="">Category not available</option>';
			}
			echo $dataDetails;
		}
		elseif($_POST['action']=='load-business-scale'){
			$queryScale = mysqli_query($db_conn, "SELECT * FROM tbl_business_scale WHERE status=1");
			if(mysqli_num_rows($queryScale)>0){
				$dataDetails = '<option value="">Select Business Scale</option>';
				while($scale = mysqli_fetch_assoc($queryScale)){
					$dataDetails .= '<option value="'.$scale['scale'].'">'.$scale['scale'].'</option>';
				}
			}
			else{
				$dataDetails = '<option value="">Scale not available</option>';
			}
			echo $dataDetails;
		}
		elseif($_POST['action']=='import-user'){
			$userType = mysqli_real_escape_string($db_conn, $_POST['userType']);
			$project = mysqli_real_escape_string($db_conn, $_POST['project']);
			$state = mysqli_real_escape_string($db_conn, $_POST['state']);
			$city = mysqli_real_escape_string($db_conn, $_POST['city']);
			  
			if(!empty($_FILES['file']['name'])){
				// Get File extension eg. 'xlsx' to check file is excel sheet
				$pathinfo = pathinfo($_FILES['file']['name']);
				$filedetail = $_FILES['file']['name'];

				// check file has extension xlsx, xls and also check
				// file is not empty
				if(($pathinfo['extension'] == 'xlsx' || $pathinfo['extension'] == 'xls')){
					$file = $_FILES['file']['tmp_name'];
					$fileName = $_FILES['file']['name'];

					// Read excel file by using ReadFactory object.
					$reader = ReaderFactory::create(Type::XLSX);

					// Open file
					$reader->open($file);
					$count = 0;
					$skipped = 0;
					$added = 0;
					$notAdded = 0;
					$errMessage = '';
					$textScript = '';
					$successMsg = '';
					

					// Number of sheet in excel file
					foreach ($reader->getSheetIterator() as $sheet){
						// Number of Rows in Excel sheet
						foreach ($sheet->getRowIterator() as $row){
							if($count >= 2){
								$lastName = $row[0];
								$firstName = $row[1];
								$middleName = $row[2];
								$phone = $row[3];
								$email = $row[4];
								$address = $row[5];
								
								if($lastName && $firstName && $middleName && $phone && $email && $address){
									$checkEmail = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_users WHERE email='$email' $extraData"));
									if($checkEmail>0){
										if($successMsg){
											$successMsg .= "<br><span class='text-danger'><i class='fa fa-check-circle'></i> $email </span>";
										}
										else{
											$successMsg = "<span class='text-danger'><i class='fa fa-check-circle'></i> $email </span>";
										}
									}
									$checkPhone = mysqli_num_rows(mysqli_query($db_conn, "SELECT * FROM tbl_users WHERE phone='$phone' $extraData"));
									if($checkPhone>0){
										if($successMsg){
											$successMsg .= "and $phone already in use</span>";
										}
										else{
											$successMsg = "<span class='text-danger'><i class='fa fa-check-circle'></i> $phone already in use</span>";
										}
									}
									if($successMsg){
										
									}
									else{
										$uniqueId = md5($email);
										$dateAdded = date("Y-m-d h:i:sa", time());
										$userPassword = password_generate(10);
										$password = md5($userPassword);
										if($user['user_type']=='Super Administrator'){
											$activeStatus = 1;
										}
										else{
											$activeStatus = 0;
										}
										$insertUser = mysqli_query($db_conn, "INSERT INTO tbl_users SET 
											unique_id='$uniqueId',
											first_name='$firstName',
											last_name='$lastName',
											middle_name='$middleName',
											email='$email',
											phone='$phone',
											dept_id='$project',
											active_status='$activeStatus',
											added_on='$dateAdded',
											added_by='$myId',
											password='$password',
											user_type='$userType',
											country='$countryId',
											state='$state',
											city='$city'
										");
										
										if($insertUser===true){
											
											///////send mail to the user with login details///////////////////
											include_once($dir.'resources/scripts/mail.php');
											$body = $superOtpMail;
											$to = $email; 
											$subject = "$userType Account Creation on $appName";
											$from = "$appName <no-reply$mailLink>";
											$reply_to = "no-reply$mailLink";
											// To send HTML mail, the Content-type header must be set

											$headers  = 'MIME-Version: 1.0' . "\r\n";

											$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

											// Create email headers
											$headers .= 'From: '.$from."\r\n".
												'Reply-To: '.$reply_to."\r\n" .
												'X-Mailer: PHP/' . phpversion();

											// Sending email
											if(mail($to, $subject, $body, $headers)===true){
												/////////update the user table/////////
												mysqli_query($db_conn, "UPDATE tbl_users SET profile_updated='Yes' WHERE unique_id='$uniqueId' LIMIT 1");
												if($successMsg){
													$successMsg .= "<br><span class='text-success'><i class='fa fa-check-circle'></i> $lastName $firstName successfully Added and Mail Sent</span>";
												}
												else{
													$successMsg .= "<span class='text-success'><i class='fa fa-check-circle'></i> $lastName $firstName successfully Added and Mail Sent</span>";
												}
											}
											else{
												if($successMsg){
													$successMsg .= "<br><span class='text-warning'><i class='fa fa-check-circle'></i> $lastName $firstName successfully Added But Mail NOT Sent</span>";
												}
												else{
													$successMsg .= "<span class='text-warning'><i class='fa fa-check-circle'></i> $lastName $firstName successfully Added But Mail NOT Sent</span>";
												}
											}
										}
										else{
											$error = mysqli_error($db_conn);
											if($successMsg){
												$successMsg .= "<br><span class='text-danger'><i class='fa fa-check-circle'></i> $lastName $firstName Not added($error)</span>";
											}
											else{
												$successMsg .= "<span class='text-danger'><i class='fa fa-check-circle'></i> $lastName $firstName Not added($error)</span>";
											}
										}
									}
								}
								else{
									$errMessage++;
								}
							}
							$count++;
						}
					}
					if(!$successMsg){
						$dataDetails = array(
							"header"=> "Error",
							"message" => "<i class='fa fa-times-circle'></i> You just uploaded an empty file"
						);
					}
					else{
						$dataDetails = array(
							"header"=> "success",
							"message" => "$successMsg"
						);
					}
				}
				else{
					$dataDetails = array(
						"header"=> "Error",
						"message" => "<span class='text-danger'><i class='fa fa-times-circle'></i> Invalid File Selected ($filedetail)</span>"
					);
				}
			}
			else{
				$dataDetails = array(
					"header"=> "Error",
					"message" => "<span class='text-danger'>File not selected. Choose an Excel file</span>"
				);
			}
			echo json_encode($dataDetails);
		}
    }