﻿<?php
	$title = 'Subscribers Management | '.$appName;
	$subscriberMenu = 'class="active"';
	$page = 'User Management';
	$usertype = 'Subscriber';
	include('pages/main/header.php');
?>
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4>Users Management</h4>
					<h6>List of OvaDraft Subscribers</h6>
				</div>
				<div class="page-btn">
					<a href="newuser.html" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add User</a>
				</div>
			</div>
			<div class="card">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
						<div class="search-path">
						<a class="btn btn-filter" id="filter_search">
						<img src="assets/img/icons/filter.svg" alt="img">
						<span><img src="assets/img/icons/closes.svg" alt="img"></span>
						</a>
						</div>
						<div class="search-input">
						<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
						</div>
						</div>
						<div class="wordset">
						<ul>
						<li>
						<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
						</li>
						<li>
						<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
						</li>
						<li>
						<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
						</li>
						</ul>
						</div>
					</div>

					<div class="card" id="filter_inputs">
						<div class="card-body pb-0">
							<div class="row">
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter User Name">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Phone">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Email">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" class="datetimepicker cal-icon" placeholder="Choose Date">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<select class="select">
											<option>Disable</option>
											<option>Enable</option>
										</select>
									</div>
								</div>
								<div class="col-lg-1 col-sm-6 col-12 ms-auto">
									<div class="form-group">
										<a class="btn btn-filters ms-auto"><img src="assets/img/icons/search-whites.svg" alt="img"></a>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="table-responsive" id="dataTableView">
						<?php
							$userType = $usertype;

							$tableDetails = '<table class="table  datanew">
								<thead>
									<tr>
										<th>#</th>
										<th>
											<label class="checkboxs">
												<input type="checkbox">
												<span class="checkmarks"></span>
											</label>
										</th>
										<th>Fullname</th>
										<th>Contact</th>
										<th>User Type</th>
										<th>Created On</th>
										<th>Status</th>
										<th>Last Login</th>
										<th>OvaDraft Status</th>
										<th>Action</th>
									</tr>
								</thead>
								<tbody>';
									
										$queryUsers = mysqli_query($db_conn, "SELECT * FROM tbl_users WHERE user_type='$userType'");
										if(mysqli_num_rows($queryUsers)>0){
											$number = 1;
											while($userDetails=mysqli_fetch_assoc($queryUsers)){
												$btn = '<ul class="dropdown-menu">
													<li>
														<a href="sales-details.html" class="dropdown-item text-primary"><img src="assets/img/icons/eye1.svg" class="me-2 w-20" alt="img">Show Detail</a>
													</li>
													<li>
														<a href="edit-sales.html" class="dropdown-item text-info"><img src="assets/img/icons/edit.svg" class="me-2 w-20" alt="img">Edit</a>
													</li>';
													
												if(!empty($userDetails['last_login_time'])){
													$lastLogin = timeCheck($userDetails['last_login_time']);
												}
												else{
													$lastLogin = 'Never';
												}
												$dateAdded = timeCheck($userDetails['added_on']);
												
												if($userDetails['active_status']==1){
													$status = '<span class="bg-lightgreen badges">Active</span>';
													$btn .= '<li>
														<a href="edit-sales.html" class="dropdown-item text-warning suspend-user" name="'.$fullname.'" data-id="'.$userDetails['unique_id'].'"><img src="assets/img/icons/user-times.svg" width="20px" height="20px" class="me-2 w-20" alt="img">Suspend</a>
													</li>
													<li>
														<a href="javascript:void(0);" class="dropdown-item delete-user text-danger" name="'.$fullname.'" data-id="'.$userDetails['unique_id'].'"><img src="assets/img/icons/delete1.svg" class="me-2" alt="img">Delete</a>
													</li>';
												}
												elseif($userDetails['active_status']==0){
													$btn .= '<li>
															<a href="javascript:void();" name="'.$fullname.'" data-id="'.$userDetails['unique_id'].'" class="dropdown-item text-success approve-user"><img src="assets/img/icons/user-check.svg" width="20px" height="20px" class="me-2 w-20" alt="img">Approve</a>
														</li>';
												}
												else{
													$status = '<span class="bg-danger badges">Inactive</span>';
													$btn .= '<li>
														<a href="edit-sales.html" class="dropdown-item text-success restore-user" name="'.$fullname.'" data-id="'.$userDetails['unique_id'].'"><img src="assets/img/icons/restore.svg" width="20px" height="20px" class="me-2 w-20" alt="img">Restore</a>
													</li>';
												}
												$fullname = $userDetails['last_name'].' '.$userDetails['first_name'].' '.$userDetails['middle_name'];
												$userId = $userDetails['unique_id'];
												$plan = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT a.plan_code, b.plan_name FROM tbl_plan_selected a, tbl_plans WHERE a.user_id='$userId' AND b.plan_code=a.plan_code"));
												$plan = $plan['plan_name'];
												
												$btn .= '<li>
														<a href="javascript:void();" class="dropdown-item text-black change-password" name="'.$fullname.'" data-id="'.$userDetails['unique_id'].'"><img src="assets/img/icons/reset-password.svg" width="20px" height="20px" class="me-2 w-20" alt="img">Reset</a>
													</li></ul>';
												
												
												$tableDetails .= '<tr>
													<td>'.$number.'</td>
													<td>
														<label class="checkboxs">
														<input type="checkbox">
														<span class="checkmarks"></span>
														</label>
													</td>
													<td><b>'.ucwords(strtolower($fullname)).'</b></td>
													<td>'.$userDetails['phone'].'<br>'.$userDetails['email'].'</td>
													<td>'.$userDetails['user_type'].'</td>
													<td>'.$dateAdded.'</td>
													<td>'.$status.'</td>
													<td>'.$lastLogin.'</td>
													<td>'.$plan.'</td>
													<td class="text-center">
														<a class="action-set" href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="true">
															<i class="fa fa-ellipsis-v" aria-hidden="true"></i>
														</a>
														'.$btn.'
													</td>
												</tr>';
											}
											$number++;
										} 
								$tableDetails .= '</tbody>
									</table>';
							echo $tableDetails;
						?>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>


<div class="modal fade" id="showpayment" tabindex="-1" aria-labelledby="showpayment" aria-hidden="true">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Show Payments</h5>
				<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
			</div>
			<div class="modal-body">
				<div class="table-responsive">
					<table class="table">
						<thead>
							<tr>
								<th>Date</th>
								<th>Reference</th>
								<th>Amount </th>
								<th>Paid By </th>
								<th>Paid By </th>
							</tr>
						</thead>
						<tbody>
							<tr class="bor-b1">
								<td>2022-03-07 </td>
								<td>INV/SL0101</td>
								<td>$ 1500.00 </td>
								<td>Cash</td>
								<td>
									<a class="me-2" href="javascript:void(0);">
										<img src="assets/img/icons/printer.svg" alt="img">
									</a>
									<a class="me-2" href="javascript:void(0);" data-bs-target="#editpayment" data-bs-toggle="modal" data-bs-dismiss="modal">
										<img src="assets/img/icons/edit.svg" alt="img">
									</a>
									<a class="me-2 confirm-text" href="javascript:void(0);">
										<img src="assets/img/icons/delete.svg" alt="img">
									</a>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>


<div class="modal fade" id="delete-user" tabindex="-1" aria-labelledby="createpayment" aria-hidden="true">
<div class="modal-dialog modal-lg">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Create Payment</h5>
<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
</div>
<div class="modal-body">
<div class="row">
<div class="col-lg-6 col-sm-12 col-12">
<div class="form-group">
<label>Customer</label>
<div class="input-group">
<input type="text" value="2022-03-07" class="datetimepicker">
<a class="scanner-set input-group-text">
<img src="assets/img/icons/datepicker.svg" alt="img">
</a>
</div>
</div>
</div>
<div class="col-lg-6 col-sm-12 col-12">
<div class="form-group">
<label>Reference</label>
<input type="text" value="INV/SL0101">
</div>
</div>
<div class="col-lg-6 col-sm-12 col-12">
<div class="form-group">
<label>Received Amount</label>
<input type="text" value="1500.00">
</div>
</div>
<div class="col-lg-6 col-sm-12 col-12">
<div class="form-group">
<label>Paying Amount</label>
<input type="text" value="1500.00">
</div>
</div>
<div class="col-lg-6 col-sm-12 col-12">
<div class="form-group">
<label>Payment type</label>
<select class="select">
<option>Cash</option>
<option>Online</option>
<option>Inprogress</option>
</select>
</div>
</div>
<div class="col-lg-12">
<div class="form-group">
<label>Note</label>
<textarea class="form-control"></textarea>
</div>
</div>
</div>
</div>
<div class="modal-footer">
<button type="button" class="btn btn-submit">Submit</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>


	<div class="modal fade" id="editpayment" tabindex="-1" aria-labelledby="editpayment" aria-hidden="true">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Edit Payment</h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-lg-6 col-sm-12 col-12">
							<div class="form-group">
								<label>Customer</label>
								<div class="input-group">
									<input type="text" value="2022-03-07" class="datetimepicker">
									<a class="scanner-set input-group-text">
										<img src="assets/img/icons/datepicker.svg" alt="img">
									</a>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-sm-12 col-12">
							<div class="form-group">
							<label>Reference</label>
							<input type="text" value="INV/SL0101">
							</div>
						</div>
						<div class="col-lg-6 col-sm-12 col-12">
							<div class="form-group">
							<label>Received Amount</label>
							<input type="text" value="1500.00">
							</div>
						</div>
						<div class="col-lg-6 col-sm-12 col-12">
							<div class="form-group">
							<label>Paying Amount</label>
							<input type="text" value="1500.00">
							</div>
						</div>
						<div class="col-lg-6 col-sm-12 col-12">
							<div class="form-group">
							<label>Payment type</label>
							<select class="select">
							<option>Cash</option>
							<option>Online</option>
							<option>Inprogress</option>
							</select>
							</div>
						</div>
						<div class="col-lg-12">
							<div class="form-group">
							<label>Note</label>
							<textarea class="form-control"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-submit">Submit</button>
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
				</div>
			</div>
		</div>
	</div>
	

<?php include('pages/main/footer.php'); ?>