<?php 
	$usersMenu = 'class="active"';
	$usersManagementMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	$userType = 2;

	include('pages/main/header.php');
	
	
?>
	<input type="hidden" id="curPage" value="<?php echo str_replace('Users','', $mainPage); ?>" />
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
			</div>

			<?php include('pages/main/users-management/stats.php'); ?>

			<div class="card">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-path">
								<a class="btn btn-filter" id="filter_search">
								<img src="assets/img/icons/filter.svg" alt="img">
								<span><img src="assets/img/icons/closes.svg" alt="img"></span>
								</a>
							</div>
							<div class="search-input">
								<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" id="refreshPageUsers" data-bs-placement="top" title="Refresh"><i class="fa-solid fa-rotate"></i></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>

					<div class="table-responsive">
						<?php
							$query = mysqli_query($db_conn, "SELECT * FROM tbl_membership WHERE status=1");
							$dataDetails = '<table class="table">
								<thead>
									<tr>
										<th>
											
										</th>
										<th>Member ID</th>
										<th>Fullname</th>
										<th>Contact</th>
										<th>Position</th>
										<th>Category</th>
										<th>Date Added </th>
										<th>Status</th>
										<th class="no-sort"><i class="fas fa-cogs"></i></th>
									</tr>
								</thead>
								<tbody>';
							if(mysqli_num_rows($query) > 0){
							
								while($data = mysqli_fetch_assoc($query)){
									$userId = $data['MemberID'];
									$fullName = $data['Name'];
									$dateJoined = $data['DateAdded'];
									$dateJoined = dateAdded($dateJoined);
									if(!empty($data['Email'])){
										$contactDetails = $data['Phone'].'<br>'.$data['Email'];
									}
									else{
										$contactDetails = $data['Phone'];
									}
									
									if($data['Status']==0){
										$status = '<span class="badge  bg-warning">Inactive</span>';
										$btn = '
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									elseif($data['Status']==1){
										$status = '<span class="badge bg-success">Active</span>';
										$btn = '
											<a class="me-3 suspend-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'">
												<img src="assets/img/icons/user-xmark-solid.svg" width="25px" alt="img">
											</a>
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									elseif($data['Status']==2){
										$status = '<span class="badge  bg-danger">Suspended</span>';
										$btn = '
											<a class="me-3 restore-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'">
												<img src="assets/img/icons/restore.svg" width="25px" alt="img">
											</a>
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									elseif($data['Status']==3){
										$status = '<span class="badge  bg-danger">Deleted</span>';
										$btn = '
											<a class="me-3 restore-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'">
												<img src="assets/img/icons/restore.svg" width="25px" alt="img">
											</a>
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									
									$dataDetails .= '<tr>
										<td>
											<label class="checkboxs">
											<input type="checkbox">
											<span class="checkmarks"></span>
											</label>
										</td>
										<td><b>'.$userId.'</b></td>
										<td><b>'.$fullName.'</b></td>
										<td>'.$contactDetails.'</td>
										<td>'.$data['Position'].'</td>
										<td>'.$data['Category'].'</td>
										<td>'.$dateJoined.'</td>
										<td>'.$status.'</td>
										<td>
											'.$btn.'
										</td>
									</tr>';
								}
							}
							$dataDetails .= '</tbody>
										</table>';
							echo $dataDetails;
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function(){
		fetchUsers();
		
		function fetchUsers(){
			let formdata = new FormData();
			formdata.append('action','fetch-users');
			formdata.append('userType',curPage);
			$.ajax({
				url: 'resources/scripts/users/users.php',
				type: 'POST',
				data: formdata,
				dataType: 'JSON',
				contentType: false,
				processData: false,
				beforeSend: function(){
					$("#userData").html('<span class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading Data.</span>');
				},
				success: function(response) {
					if(response.header==='successful') {
						$("#userData").html(response.tabledata);
					}
				}
			});
			
		}
		
		$("#refreshPageUsers").on('click', function(){
			fetchUsers();
		});
	});
</script>

<?php include('pages/main/footer.php'); ?>