<?php 
	$adminMenu = 'class="active"';
	$usersManagementMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	$userType = 1;

	include('pages/main/header.php');
	
	
?>
	<input type="hidden" id="UserType" value="<?php echo $userType; ?>" />
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#addAdmin" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add Admin</a>
				</div>
			</div>

			<?php include('pages/main/users-management/stats.php'); ?>

			<div class="card">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-path">
								<a class="btn btn-filter" id="filter_search">
								<img src="assets/img/icons/filter.svg" alt="img">
								<span><img src="assets/img/icons/closes.svg" alt="img"></span>
								</a>
							</div>
							<div class="search-input">
								<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" id="refreshPageUsers" data-bs-placement="top" title="Refresh"><i class="fa-solid fa-rotate"></i></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>

					<div class="table-responsive">
						<?php
							$query = mysqli_query($db_conn, "SELECT * FROM bkq_user_login WHERE UserID!='$myId' AND UserRoleID=$userType AND UserStatus <= 2");
							$dataDetails = '<table class="table datanew">
								<thead>
									<tr>
										<th>
											
										</th>
										<th>Fullname</th>
										<th>Contact</th>
										<th>Location</th>
										<th>Date Added </th>
										<th>Status</th>
										<th class="no-sort"><i class="fas fa-cogs"></i></th>
									</tr>
								</thead>
								<tbody>';
							if(mysqli_num_rows($query) > 0){
							
								while($data = mysqli_fetch_assoc($query)){
									$userId = $data['UserID'];
									$mainUser = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT * FROM bkq_personnel WHERE UserID='$userId' LIMIT 1"));
									$fullName = $mainUser['First_Name'].' '.$mainUser['Last_Name'];
									$country = $mainUser['CountryID'];
									$state = $mainUser['StateID'];
									$dateJoined = $mainUser['RegDate'].' '.$mainUser['RegTime'];
									$dateJoined = dateAdded($dateJoined);
									
									if($data['UserStatus']==0){
										$status = '<span class="badge  bg-warning">Inactive</span>';
										$btn = '
											<a class="me-3 change-password" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Set Password '.$fullName.'">
												<img src="assets/img/icons/user-lock-solid.svg" width="25px" alt="img">
											</a>
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									elseif($data['UserStatus']==1){
										$status = '<span class="badge  bg-success">Active</span>';
										$btn = '
											<a class="me-3 suspend-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'">
												<img src="assets/img/icons/user-xmark-solid.svg" width="25px" alt="img">
											</a>
											<a class="me-3 change-password" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Set Password '.$fullName.'">
												<img src="assets/img/icons/user-lock-solid.svg" width="25px" alt="img">
											</a>
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									elseif($data['UserStatus']==2){
										$status = '<span class="badge  bg-danger">Suspended</span>';
										$btn = '
											<a class="me-3 restore-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'">
												<img src="assets/img/icons/restore.svg" width="25px" alt="img">
											</a>
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									elseif($data['UserStatus']==3){
										$status = '<span class="badge  bg-danger">Deleted</span>';
										$btn = '
											<a class="me-3 restore-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'">
												<img src="assets/img/icons/restore.svg" width="25px" alt="img">
											</a>
											<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>
										';
									}
									
									
									if(empty($country) && empty($state)){
										$location = 'Not Set';
									}
									else{
										$location = 'Will be Loaded';
									}
									
									$dataDetails .= '<tr>
										<td>
											<label class="checkboxs">
											<input type="checkbox">
											<span class="checkmarks"></span>
											</label>
										</td>
										<td><b>'.$fullName.'</b></td>
										<td>'.$data['Email'].'</td>
										<td>'.$location.'</td>
										<td>'.$dateJoined.'</td>
										<td>'.$status.'</td>
										<td>
											'.$btn.'
										</td>
									</tr>';
								}
							}
							$dataDetails .= '</tbody>
										</table>';
							echo $dataDetails;
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="modal custom-modal fade" id="addAdmin" role="dialog">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header border-0 pb-0 bg-success">
				<div class="form-header modal-header-title text-start text-white mb-0">
					<h4 class="mb-0 text-white">Add New Administrator</h4>
				</div>
				<button type="button" id="closeAddBusinessIcon" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				<br><br>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-md-12">
						<div class="card-body">
							<div class="row">
								<div class="col-lg-12 col-md-12 col-sm-12">
									<div class="input-block mb-3">
										<label>First Name</label>
										<input id="firstName" type="text" class="form-control" placeholder="Enter First Name">
									</div>
								</div>
								<div class="col-lg-12 col-md-12 col-sm-12">
									<div class="input-block mb-3">
										<label>Last Name</label>
										<input id="lastName" type="text" class="form-control" placeholder="Enter Surname">
									</div>
								</div>
								<div class="col-lg-12 col-md-12 col-sm-12">
									<div class="input-block mb-3">
										<label>Email Address</label>
										<input id="email" type="text" class="form-control" placeholder="Enter Email Address">
									</div>
								</div>
								
								<div class="col-md-12" id="bzMsgBox"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" id="closeAddAdmin" data-bs-dismiss="modal" class="btn btn-cancel">Cancel</button>
				<button type="button" id="addAminBtn" class="btn btn-success"><i class="fa fa-check-circle"></i> Submit</button>
			</div>
		</div>
	</div>
</div>

<?php include('pages/main/footer.php'); ?>