<?php 
	$addEnumerationMenu = 'class="active"';
	$enumerationMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$page = $currentPage;
	
	include('pages/main/header.php');
	
	if($userType=='Super Administrator' || $userType=='Administrator'){
		$queryUsers = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration");
	}elseif($userType=='National Project Manager'){
		$myDept = $user['dept_id'];
		$queryUsers = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration");
	}elseif($userType=='State Project Manager'){
		$myDept = $user['dept_id'];
		$myState = $user['state'];
		$queryUsers = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE stateofresidence='$myState'");
	}elseif($userType=='LG Project Manager'){
		$myDept = $user['dept_id'];
		$myState = $user['state'];
		$myLg = $user['city'];
		$queryUsers = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE stateofresidence='$myState' AND lgaofresidence='$myLg'");
	}
	elseif($userType=='Agent'){
		$myDept = $user['dept_id'];
		$myState = $user['state'];
		$myLg = $user['city'];
		$queryUsers = mysqli_query($db_conn, "SELECT * FROM tbl_traders_enumeration WHERE addedby='$myId'");
	}
	
?>
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<a href="addcustomer.html" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add Customer</a>
				</div>
			</div>

			<div class="card">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-path">
								<a class="btn btn-filter" id="filter_search">
								<img src="assets/img/icons/filter.svg" alt="img">
								<span><img src="assets/img/icons/closes.svg" alt="img"></span>
								</a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>

					<div class="card" id="filter_inputs">
						<div class="card-body pb-0">
							<div class="row">
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Customer Code">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Customer Name">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Phone Number">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Email">
									</div>
								</div>
								<div class="col-lg-1 col-sm-6 col-12  ms-auto">
									<div class="form-group">
										<a class="btn btn-filters ms-auto"><img src="assets/img/icons/search-whites.svg" alt="img"></a>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="table-responsive">
						<table class="table  datanew">
							<thead>
								<tr>
									<th>
										<label class="checkboxs">
										<input type="checkbox" id="select-all">
										<span class="checkmarks"></span>
										</label>
									</th>
									<th>Full Name</th>
									<th>Contact</th>
									<th>Origin</th>
									<th>Residence </th>
									<th>Businesses </th>
									<th>Added </th>
									<th>Status</th>
									<th class="no-sort"><i class="fas fa-cogs"></i></th>
								</tr>
							</thead>
							<tbody>
								<?php
									$number = 1;
									while($trader = mysqli_fetch_assoc($queryUsers)){
										$matanId = $trader['matan_id'];
										$businesses = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT COUNT(*) AS total FROM tbl_businesses WHERE trader_id='$matanId'"));
										$businesses = $businesses['total'];
										$fullName = $trader['lastname'].' '.$trader['firstname'].' '.$trader['middlename'];
										
										$addedOn = timeCheck($trader['dateadded']);
										
										if($trader['status']=='Complete'){
											$status = '<span class="badge  bg-success">'.$trader['status'].'</span>';
											$btn = '
												<a class="me-3" href="javascript:void(0);" data-id="'.$trader['matan_id'].'" name="'.$fullName.'" data-bs-toggle="modal" data-bs-target="#print_slip"><i class="fas fa-print me-2">
													<img src="assets/img/icons/printer.svg" alt="img">
												</a>';
										}
										else{
											$status = '<span class="badge  bg-warning">'.$trader['status'].'</span>';
											if(isset($trader['passport'])){
												$btn = '
													
													<a class="me-3 generate-account" href="javascript:void(0);" data-id="'.$trader['matan_id'].'" name="'.$fullName.'" data-bs-toggle="modal" data-bs-target="#generate_account">
														<img src="assets/img/icons/check-circle-broken.svg" width="20px" alt="img">
													</a>
													<a class="me-3 edit-account" href="javascript:void(0);" data-id="'.$trader['matan_id'].'" name="'.$fullName.'" data-bs-toggle="modal" data-bs-target="#edit_account_details">
														<img src="assets/img/icons/edit.svg" alt="img">
													</a>
													<a class="me-3 delete-account" href="javascript:void(0);" data-id="'.$trader['matan_id'].'" name="'.$fullName.'" data-bs-toggle="modal" data-bs-target="#delete_account">
														<img src="assets/img/icons/delete.svg" alt="img">
													</a>';
											}
											else{
												$btn = '
													<a class="me-3 edit-account" href="javascript:void(0);" data-id="'.$trader['matan_id'].'" name="'.$fullName.'" data-bs-toggle="modal" data-bs-target="#edit_account_details">
														<img src="assets/img/icons/edit.svg" alt="img">
													</a>
													<a class="me-3 delete-account" href="javascript:void(0);" data-id="'.$trader['matan_id'].'" name="'.$fullName.'" data-bs-toggle="modal" data-bs-target="#delete_account">
														<img src="assets/img/icons/delete.svg" alt="img">
													</a>';
											}
										}
										
								?>
								<tr>
									<td>
										<label class="checkboxs">
										<input type="checkbox">
										<span class="checkmarks"></span>
										</label>
									</td>
									<td><b><?php echo $fullName; ?></b></td>
									<td><?php echo $trader['email'].'<br>'.$trader['phone']; ?></td>
									<td><?php echo getCityName($trader['lgaoforigin']).', '.getStateName($trader['stateoforigin']); ?></td>
									<td><?php echo getCityName($trader['lgaofresidence']).', '.getStateName($trader['stateofresidence']); ?></td>
									<td><?php echo $businesses; ?></td>
									<td><?php echo $addedOn; ?></td>
									<td><?php echo $status; ?></td>
									<td>
										<?php echo $btn; ?>
									</td>
								</tr>
								<?php $number++; } ?>
								
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal custom-modal fade" id="generate_account" role="dialog">
	<div class="modal-dialog modal-dialog-centered modal-md">
		<div class="modal-content">
			<div class="modal-header border-0 pb-0 bg-success" id="generateAccountHeader">
				<div class="form-header modal-header-title text-start text-white mb-0">
					<h4 class="mb-0 text-white">Generate Account</h4>
				</div>
				<button type="button" class="btn-close" id="closeGenerateAccountIcon" data-bs-dismiss="modal" aria-label="Close"></button>
				<br><br>
			</div>
			<div class="modal-body">
				<div class="form-header text-center">
					<p id="generateAccountBody">
						Kindly note that you won't be able to make further changes to this account after generating Bank Account and JTB TIN.
						<br><b class="text-danger">Are you sure you want to continue?</b>
					</p>
				</div>
				<input type="hidden" id="generateAccountId" />
				<div class="modal-btn delete-action">
					<div class="row">
						<div class="col-6" id="genBtnView">
							<button type="button" id="generateBankAccountBtn" class="w-100 btn btn-primary"><i class="fas fa-bank"></i> Yes, Generate</button>
							<button type="button" style="display: none;" id="printAccountSlip" class="w-100 btn btn-primary"><i class="fas fa-print"></i> Print Slip</button>
						</div>
						<div class="col-6" id="cancelView">
							<button type="button" id="closeGenerateAccountBtn" data-bs-dismiss="modal" class="w-100 btn btn-secondary"><i class="fas fa-times-circle"></i> No, Exit</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>


<div class="modal custom-modal fade" id="delete_account" role="dialog">
	<div class="modal-dialog modal-dialog-centered modal-md">
		<div class="modal-content">
			<div class="modal-header border-0 pb-0 bg-danger">
				<div class="form-header modal-header-title text-start text-white mb-0">
					<h4 class="mb-0 text-white">Delete Account</h4>
				</div>
				<button type="button" class="btn-close" id="closeDeleteAccountIcon" data-bs-dismiss="modal" aria-label="Close"></button>
				<br><br>
			</div>
			<div class="modal-body">
				<div class="form-header text-center">
					<p id="deleteAccountBody">
						This action will delete the trader enumeration details for <b id="deleteAccountName"></b>
						<br><b class="text-danger">Are you sure you want to continue?</b>
					</p>
				</div>
				<input type="hidden" id="deleteAccountId" />
				<div class="modal-btn delete-action">
					<div class="row">
						<div class="col-6">
							<button type="button" id="deleteAccountBtn" class="w-100 btn btn-danger"><i class="fas fa-trash"></i> Yes, Delete</button>
						</div>
						<div class="col-6">
							<button type="button" id="closeDeleteAccountBtn" data-bs-dismiss="modal" class="w-100 btn btn-secondary"><i class="fas fa-times-circle"></i> No, Cancel</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php include('pages/main/footer.php'); ?>