<?php 
	$dir = '../';
	$settingMenu = 'class="active"';
	$generalSettingMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
	
?>
	<input type="hidden" id="curPage" value="<?php echo str_replace('Users','', $mainPage); ?>" />
	<input type="hidden" id="mainPage" value="<?php echo $mainPage; ?>" />
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
			</div>

			<div class="card">
				<div class="card-body">
					<div class="row">
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Website Name <span class="manitory">*</span></label>
								<input type="text" value="<?php echo $appName; ?>" id="websiteName" placeholder="Enter Website Name">
							</div>
						</div>
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Website Tag Line <span class="manitory">*</span></label>
								<input type="text" value="<?php echo $appTagline; ?>" id="websiteTagline" placeholder="Enter Tag Line">
							</div>
						</div>
						
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Website Address<span class="manitory">*</span></label>
								<input type="text" value="<?php echo $appWebsite; ?>" id="websiteAddress" placeholder="Enter email">
							</div>
						</div>
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Default Url<span class="manitory">*</span></label>
								<input type="text" value="<?php echo $defaultUrl; ?>" id="defaultUrl" placeholder="Enter Website Address">
							</div>
						</div>
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Email Address<span class="manitory">*</span></label>
								<input type="text" value="<?php echo $appEmail; ?>" id="emailAddress" placeholder="Enter email">
							</div>
						</div>
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Phone</label>
								<input type="text" value="<?php echo $appPhone; ?>" id="phone" placeholder="Enter Phone">
							</div>
						</div>
						<div class="col-lg-6 col-sm-12">
							<div class="form-group">
								<label>Address</label>
								<input type="text" value="<?php echo $appAddress; ?>" id="address" placeholder="Enter Address">
							</div>
						</div>
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Facebook Url</label>
								<input type="text" value="<?php echo $appFacebook; ?>" id="facebook" placeholder="Enter Facebook Url">
							</div>
						</div>
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>X Handle <span class="manitory">*</span></label>
								<input type="text" value="<?php echo $appTwitter; ?>" id="twitter" placeholder="Enter X Handle">
							</div>
						</div>
						<div class="col-lg-6 col-sm-6 col-12">
							<div class="form-group">
								<label>Instagram Handle <span class="manitory">*</span></label>
								<input type="text" value="<?php echo $appInstagram; ?>" id="instagram" placeholder="Enter Instagram Handle">
							</div>
						</div>
						<div class="row">
							<div class="col-lg-12">
								<a href="javascript:void(0);" id="updateWebsite" class="btn btn-submit me-2">Submit</a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-6">
					<div class="form-group">
						<label> Website Logo</label>
						<div class="image-upload">
							<input type="file" id="websiteLogo">
							<div class="image-uploads">
								<img src="assets/img/icons/upload.svg" alt="Website Logo">
								<h4>Click or Drag and drop a file to upload</h4>
							</div>
							<div class="input-block service-upload service-upload-info mb-0 bg-dark text-center" style="border: 1;">
								<span id="websiteLogoDisplay" style="background-color: black;"><?php if(isset($appLogo)){ echo '<img src="'.$defaultUrl.'assets/images/'.$appLogo.'" width="150px" alt="signature">';} ?></span>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="form-group">
						<label> Website Favicon</label>
						<div class="image-upload">
							<input type="file" id="websiteFavicon">
							<div class="image-uploads">
								<img src="assets/img/icons/upload.svg" alt="Website Logo">
								<h4>Click or Drag and drop a file to upload</h4>
							</div>
							<div class="input-block service-upload service-upload-info mb-0 text-center" style="border: 1;">
								<span id="websiteFaviconDisplay"><?php if(isset($appFavicon)){ echo '<img src="'.$defaultUrl.'assets/images/'.$appFavicon.'" width="100px" alt="Website Favicon">';} ?></span>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="form-group">
						<label> User Dashboard Logo</label>
						<div class="image-upload">
							<input type="file" id="userDashLogo">
							<div class="image-uploads">
								<img src="assets/img/icons/upload.svg" alt="User Dash Logo">
								<h4>Click or Drag and drop a file to upload</h4>
							</div>
							<div class="input-block service-upload service-upload-info mb-0 bg-dark text-center" style="border: 1;">
								<span id="userDashDisplay"><?php if(isset($appUserDashLogo)){ echo '<img src="'.$defaultUrl.'useraccount/main/images/'.$appUserDashLogo.'" width="150px" alt="Admin Logo">';} ?></span>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="form-group">
						<label> Admin Dashboard Logo</label>
						<div class="image-upload">
							<input type="file" id="adminDashLogo">
							<div class="image-uploads">
								<img src="assets/img/icons/upload.svg" alt="Admin Dash Logo">
								<h4>Click or Drag and drop a file to upload</h4>
							</div>
							<div class="input-block service-upload service-upload-info mb-0 text-center" style="border: 1;">
								<span id="adminDashDisplay"><?php if(isset($appAdminDashLogo)){ echo '<img src="'.$defaultUrl.'account/assets/img/'.$appAdminDashLogo.'" width="150px" alt="Admin Logo">';} ?></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
</div>
<script>
	$(document).ready(function(){
		$("#updateWebsite").on('click', function(){
			let formdata = new FormData();
			let errorMsg = '';
			let appName = $("#websiteName").val();
			if(appName){
				formdata.append('websiteName',appName);
				$("#websiteName").removeClass('is-invalid');
			}
			else{
				$("#websiteName").addClass('is-invalid');
				errorMsg = '<i class="fa fa-times"></i> Website Name required';
			}
			let appTagline = $("#websiteTagline").val();
			if(appTagline){
				formdata.append('websiteTagline',appTagline);
			}
			let emailAddress = $("#emailAddress").val();
			
			if(emailAddress){
				formdata.append('emailAddress',emailAddress);
				$("#emailAddress").removeClass('is-invalid');
			}
			else{
				$("#emailAddress").addClass('is-invalid');
				errorMsg = '<i class="fa fa-times"></i> Email Address is required';
			}
			let defaultUrl = $("#defaultUrl").val();
			if(defaultUrl){
				formdata.append('defaultUrl',defaultUrl);
				$("#defaultUrl").removeClass('is-invalid');
			}
			else{
				$("#defaultUrl").addClass('is-invalid');
				errorMsg = '<i class="fa fa-times"></i> Default Url is required';
			}
			
			let websiteAddress = $("#websiteAddress").val();
			if(websiteAddress){
				formdata.append('websiteAddress',websiteAddress);
				$("#websiteAddress").removeClass('is-invalid');
			}
			else{
				$("#websiteAddress").addClass('is-invalid');
				errorMsg = '<i class="fa fa-times"></i> Website Address is required';
			}
			let phone = $("#phone").val();
			if(phone){
				formdata.append('phone',phone);
			}
			let address = $("#address").val();
			if(address){
				formdata.append('address',address);
			}
			let facebook = $("#facebook").val();
			if(facebook){
				formdata.append('facebook',facebook);
			}
			let twitter = $("#twitter").val();
			if(twitter){
				formdata.append('twitter',twitter);
			}
			let instagram = $("#instagram").val();
			if(instagram){
				formdata.append('instagram',instagram);
			}
			
			if(!errorMsg){
				formdata.append('action','update-website-detail');
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Updating Details',
							html: "We are updating details.<br><i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response){
						if(response.header=='successful'){
							Swal.fire({
								icon: "success",
								title: "Website Updated",
								text: "The Website Details were Successfully Updated",
								confirmButtonClass: "btn btn-success",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							})
						}
						else{
							Swal.fire({
								icon: "error",
								title: "Error!",
								text: response.message || "Could not update details.",
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					},
					error: function(jqXHR, textStatus, errorThrown) {
						// Display detailed error information
						console.error("AJAX Request Error:");
						console.error("Status: " + textStatus); // Status of the request (e.g., "error", "timeout")
						console.error("Error Thrown: " + errorThrown); // Textual portion of the error
						console.error("Response Text: " + jqXHR.responseText); // Response from the server, if any
						alert(jqXHR.responseText);
						$("#genCert").html('Upload & Generate').removeAttr('disabled');
					}
				});
			}
			else{
				Swal.fire({
					icon: "error",
					title: "Error Occurred!",
					html: errorMsg,
					confirmButtonClass: "btn btn-danger",
					allowOutsideClick: false,
					allowEscapeKey: false,
					allowEnterKey: false
				});
			}
		});
		
		$('#websiteLogo').change(function(){
			var fd = new FormData();
			var websiteLogo = $('#websiteLogo')[0].files;
			if(websiteLogo){
				fd.append('file',websiteLogo[0]);
				fd.append('action','upload-website-logo');
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: fd,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Uploading...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response){
						if(response.header=='successful'){
							$("#websiteLogoDisplay").html('<img src="'+response.imgsrcurl+'" width="100px" alt="Website Favicon">');
							Swal.fire({
								icon: "success",
								title: "Uploaded",
								text: "Website Logo Uploaded",
								confirmButtonClass: "btn btn-success",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							})
						}
						else{
							Swal.fire({
								icon: "error",
								title: "Error!",
								text: response.message || "Could not upload Logo.",
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					}
				});
			}
		});
		
		$('#websiteFavicon').change(function(){
			var fd = new FormData();
			var websiteFavicon = $('#websiteFavicon')[0].files;
			if(websiteFavicon){
				fd.append('file',websiteFavicon[0]);
				fd.append('action','upload-website-favicon');
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: fd,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Uploading...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response){
						if(response.header=='successful'){
							$("#websiteFaviconDisplay").html('<img src="'+response.imgsrcurl+'" width="100px" alt="Website Favicon">');
							Swal.fire({
								icon: "success",
								title: "Uploaded",
								text: "Website Logo Uploaded",
								confirmButtonClass: "btn btn-success",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							})
						}
						else{
							Swal.fire({
								icon: "error",
								title: "Error!",
								text: response.message || "Could not upload Logo.",
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					}
				});
			}
		});
		
		$('#userDashLogo').change(function(){
			var fd = new FormData();
			var userDashLogo = $('#userDashLogo')[0].files;
			if(userDashLogo){
				fd.append('file',userDashLogo[0]);
				fd.append('action','upload-user-dash-logo');
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: fd,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Uploading...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response){
						if(response.header=='successful'){
							$("#userDashDisplay").html('<img src="'+response.imgsrcurl+'" width="100px" alt="Website Favicon">');
							Swal.fire({
								icon: "success",
								title: "Uploaded",
								text: "Website Logo Uploaded",
								confirmButtonClass: "btn btn-success",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							})
						}
						else{
							Swal.fire({
								icon: "error",
								title: "Error!",
								text: response.message || "Could not upload User Logo.",
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					}
				});
			}
		});
		
		$('#adminDashLogo').change(function(){
			var fd = new FormData();
			var adminDashLogo = $('#adminDashLogo')[0].files;
			
			if(adminDashLogo){
				fd.append('file',adminDashLogo[0]);
				fd.append('action','upload-admin-dash-logo');
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: fd,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Uploading...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response){
						if(response.header=='successful'){
							$("#adminDashDisplay").html('<img src="'+response.imgsrcurl+'" width="100px" alt="Website Favicon">');
							Swal.fire({
								icon: "success",
								title: "Uploaded",
								text: "Website Logo Uploaded",
								confirmButtonClass: "btn btn-success",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							})
						}
						else{
							Swal.fire({
								icon: "error",
								title: "Error!",
								text: response.message || "Could not upload User Logo.",
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					}
				});
			}
		});
	});
</script>

<?php include('pages/main/footer.php'); ?>