<?php 
	$questionCategoriesMenu = 'class="active"';
	$questionBankMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
	
?>
	<input type="hidden" id="curPage" value="<?php echo str_replace('Users','', $mainPage); ?>" />
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#addCategory" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add Category</a>
				</div>
			</div>

			<div class="card col-md-10 col-lg-6 col-sm-12 col-xs-12">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-input">
								<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="table-responsive">
						<table class="table  datanew">
							<thead>
								<tr>
									<th>
										
									</th>
									<th>Category Name</th>
									<th>Added By</th>
									<th>Status</th>
									<th class="text-end">Action</th>
								</tr>
							</thead>
							<tbody>
							<?php
								$queryCat = mysqli_query($db_conn, "SELECT a.QuestionCatID,a.category_name as category, a.date_added as date,
									a.status, b.First_Name, b.Last_Name FROM bkq_question_categories a, bkq_personnel b
									WHERE a.QuestionCatID>0 AND b.UserID=a.added_by AND status<2 ORDER BY category ASC
								");
								if(mysqli_num_rows($queryCat)>0){
									while($cat = mysqli_fetch_assoc($queryCat)){
										if($cat['status']==1){
											$statusTag = 'checked';
										}
										else{
											$statusTag = '';
										}
										echo '<tr>
											<td>
												<label class="checkboxs select-cat">
													<input type="checkbox" data-id="'.$cat['QuestionCatID'].'" name="'.$cat['category'].'">
													<span class="checkmarks"></span>
												</label>
											</td>
											<td>'.$cat['category'].'</td>
											<td>'.$cat['First_Name'].' '.$cat['Last_Name'].'</td>
											<td>
											<div class="status-toggle d-flex justify-content-between align-items-center">
											<input type="checkbox" id="'.$cat['QuestionCatID'].'" class="check change-status" '.$statusTag.' data-id="'.$cat['QuestionCatID'].'" name="'.$cat['category'].'">
											<label for="'.$cat['QuestionCatID'].'" class="checktoggle">checkbox</label>
											</div>
											</td>
											<td class="text-end">
											<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#editCategory" data-id="'.$cat['QuestionCatID'].'" name="'.$cat['category'].'">
											<img src="assets/img/icons/edit.svg" alt="img">
											</a>
											<a class="me-3 delete-category" href="javascript:void(0);" data-id="'.$cat['QuestionCatID'].'" name="'.$cat['category'].'">
											<img src="assets/img/icons/delete.svg" alt="img">
											</a>
											</td>
										</tr>';
									}
								}
							?>
							</tbody>
						</table>
					</div>
					
					<div class="table-foot">
						<hr />
						<input type="hidden" id="selectedId" />
						<input type="hidden" id="selectedNames" />
						<a class="me-3 delete-all-category" title="Delete all selected" href="javascript:void(0);">
							<img src="assets/img/icons/delete.svg" alt="img">
						</a>
					</div>
					<script>
						$(document).ready(function(){
							$(".table-foot").attr('style','display: none');
							$(".change-status").on('change', function(){
								
							});
							
							// Arrays to store selected IDs and names
							let selectedIds = [];
							let selectedNames = [];

							// Function to handle click events on .select-cat elements
							function updateSelection(event) {
								const dataId = event.target.getAttribute("data-id");
								const categoryName = event.target.getAttribute("name");

								// Ensure both dataId and categoryName exist before proceeding
								if (dataId && categoryName) {
									if (selectedIds.includes(dataId)) {
										// Remove data-id and name if it already exists in the array
										selectedIds = selectedIds.filter(id => id !== dataId);
										selectedNames = selectedNames.filter(name => name !== categoryName);
									} else {
										// Add data-id and name if it doesn't exist in the array
										selectedIds.push(dataId);
										selectedNames.push(categoryName);
									}
								}
								
								const formattedNames =
								selectedNames.length > 1
									? `${selectedNames.slice(0, -1).join(", ")} and ${selectedNames.slice(-1)}`
									: selectedNames.join("");
									
								// Update the selected IDs and names labels
								const idsLabel = document.getElementById("selected-label");
								const namesLabel = document.getElementById("selected-names-label");

								idsLabel.textContent = selectedIds.length ? selectedIds.join(",") : "None";
								namesLabel.textContent = selectedNames.length ? formattedNames : "None";
							
								if(idsLabel.textContent==="None"){
									$(".table-foot").attr('style','display: none');
									$("#selectedId").val('');
									$("#selectedNames").val('');
								}
								else{
									$(".table-foot").attr('style','display: block');
									$("#selectedId").val(idsLabel.textContent);
									$("#selectedNames").val(formattedNames);
								}
							}

							// Attach click event listeners to elements with .select-cat class
							document.querySelectorAll(".select-cat").forEach(element => {
								element.addEventListener("click", updateSelection);
							});
						});
					</script>
					<p id="selected-label" style="display:none;"></p>
					<p id="selected-names-label" style="display:none;"></p>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="addCategory" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Add Category </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeAddCatIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Category Name<span class="manitory">*</span></label>
								<input type="text" id="categoryName" placeholder="Category name">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="submitCategory" class="btn btn-submit">Submit</button>
					<button type="button" id="closeAddCatBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="editCategory" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Edit category </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeEditCatIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Category Name<span class="manitory">*</span></label>
								<input type="text" id="editCategoryName" placeholder="Enter category">
							</div>
						</div>
					</div>
				</div>
				<input type="hidden" id="editCatId" />
				<div class="modal-footer">
					<button type="button" id="editCategoryBtn" class="btn btn-submit">Confirm</button>
					<button type="button" id="closeEditCatBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>

	
</div>

<?php include('pages/main/footer.php'); ?>