<?php 
	$questionManagerMenu = 'class="active"';
	$questionBankMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
	
?>
<div class="page-wrapper cardhead">
<div class="content container-fluid">

<div class="page-header">
<div class="row">
<div class="col-sm-12">
<h3 class="page-title">Form Select2</h3>
<div class="page-btn">
					<button type="button" onclick="location.href='./?loc=question-bank/bulk-upload'" class="btn btn-success mr-1 mb-1"><i class="fas fa-cloud-upload"></i> Bulk Upload</button>
					<button type="button" data-bs-toggle="modal" data-bs-target="#addQuestion" class="btn btn-info mr-1 mb-1"><i class="fa fa-plus-circle"></i> Add Question</button>
				</div>
<ul class="breadcrumb">
<li class="breadcrumb-item"><a href="index.html">Dashboard</a></li>
<li class="breadcrumb-item active">Form Select2</li>
</ul>
</div>
</div>
</div>

<div class="row">
<div class="col-md-12">

	<div class="card">
		<div class="card-header">
			<h5 class="card-title">Basic</h5>
		</div>
		<div class="card-body">
			<div class="row">
				<div class="col-12">
					<div class="form-group">
						<label>Question<span class="manitory">*</span></label>
						<textarea rows="5" id="question" placeholder="Enter Question Here"></textarea>
					</div>
				</div>
				<div class="col-12">
					<div class="form-group">
						<label>Options<span class="manitory">*</span></label>
						<textarea rows="5" id="options" placeholder="Enter Options"></textarea>
					</div>
				</div>
				<div class="col-12">
					<div class="form-group">
						<label>Correct Answer<span class="manitory">*</span></label>
						<input type="text" id="correctAnswer" placeholder="Enter Correct Option" />
					</div>
				</div>
				<div class="col-12">
					<div class="form-group">
						<label>Description<span class="manitory">*</span></label>
						<textarea rows="5" id="description" placeholder="Enter Description here..."></textarea>
					</div>
				</div>
				<div class="col-md-4 col-sm-12 col-xs-12">
					<div class="form-group">
						<label>Category<span class="manitory">*</span></label>
						<select class="js-example-basic-single select2" id="catId">
							<?php
								$queryCat = mysqli_query($db_conn, "SELECT * FROM bkq_question_categories WHERE Status=1 ORDER BY category_name ASC");
								if(mysqli_num_rows($queryCat)>0){
									echo '<option value="" selected>Select Category</option>';
									while($cat=mysqli_fetch_assoc($queryCat)){
										echo '<option value="'.$cat['cat_id'].'">'.$cat['category_name'].'</option>';
									}
									echo '<option value="0">N/A</option>';
								}
								else{
									echo '<option value="">Category Not Available</option>';
								}
							?>
						</select>
					</div>
				</div>
				<div class="col-md-4 col-sm-12 col-xs-12">
					<div class="form-group">
						<label>Testament<span class="manitory">*</span></label>
						<select class="js-example-basic-single select2" id="testament">
							<?php
								$queryTestament = mysqli_query($db_conn, "SELECT * FROM bkq_testament WHERE Status=1 ORDER BY Testament ASC");
								if(mysqli_num_rows($queryTestament)>0){
									echo '<option value="">Select Testament</option>';
									while($testament=mysqli_fetch_assoc($queryTestament)){
										echo '<option value="'.$testament['TestamentID'].'">'.$testament['Testament'].'</option>';
									}
									echo '<option value="0">N/A</option>';
								}
								else{
									echo '<option value="">Testament Not Available</option>';
								}
							?>
						</select>
					</div>
				</div>
				<div class="col-md-4 col-sm-12 col-xs-12">
					<div class="form-group">
						<label>Level<span class="manitory">*</span></label>
						<select class="select" id="level" style="border-color: red;">
							<?php
								$queryLevel = mysqli_query($db_conn, "SELECT * FROM bkq_question_level WHERE Status=1");
								if(mysqli_num_rows($queryLevel)>0){
									echo '<option value="">Select Qestion Level</option>';
									while($level=mysqli_fetch_assoc($queryLevel)){
										echo '<option value="'.$level['LevelID'].'">'.$level['Level'].'</option>';
									}
									echo '<option value="0">N/A</option>';
								}
								else{
									echo '<option value="">Level Not Available</option>';
								}
							?>
						</select>
					</div>
				</div>
				<div class="col-md-4 col-sm-12 col-xs-12">
					<div class="form-group">
						<label>Age Category<span class="manitory">*</span></label>
						<select class="select" id="ageCat">
							<?php
								$queryAgeCat = mysqli_query($db_conn, "SELECT * FROM bkq_question_age_category WHERE Status=1 ORDER BY AgeFrom ASC");
								if(mysqli_num_rows($queryAgeCat)>0){
									echo '<option value="">Select Age Category</option>';
									while($ageCat=mysqli_fetch_assoc($queryAgeCat)){
										echo '<option value="'.$ageCat['AgeCatID'].'">'.$ageCat['AgeCat'].' ('.$ageCat['AgeFrom'].' - '.$ageCat['AgeTo'].' Years)</option>';
									}
									echo '<option value="0">N/A</option>';
								}
								else{
									echo '<option value="">Age Category Not Available</option>';
								}
							?>
						</select>
					</div>
				</div>
			</div>
		</div>
		<div class="card-footer">
			<button type="button" id="submitQuestion" class="btn btn-submit">Submit</button>
			<button type="button" id="closeAddQuesBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
		</div>
	</div>
</div>

<div class="col-md-6" style="display:none;">
<div class="card">
<div class="card-header">
<h5 class="card-title">Small Select2</h5>
</div>
<div class="card-body">
<div class="row">
<div class="col-md-12">
<p>Use data('select2') function to get container of select2.</p>
<select class="form-control form-small select">
<option selected="selected">orange</option>
<option>white</option>
<option>purple</option>
</select>
</div>
</div>
</div>
</div>
<div class="card">
<div class="card-header">
<h5 class="card-title">Disabling options</h5>
</div>
<div class="card-body">
<div class="row">
<div class="col-md-12">
<p>Disable Select using disabled attribute.</p>
<select class="form-control disabled-results">
<option value="one">First</option>
<option value="two" disabled="disabled">Second</option>
<option value="three">Third</option>
</select>
</div>
</div>
</div>
</div>
<div class="card">
<div class="card-header">
<h5 class="card-title">Limiting the number of Tagging</h5>
</div>
<div class="card-body">
<div class="row">
<div class="col-md-12">
<p>Set maximumSelectionLength: 2 with tags: true to limit selectin in Tag mode.</p>
<select class="form-control tagging" multiple="multiple">
<option>orange</option>
<option>white</option>
<option>purple</option>
</select>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>

<div class="modal fade" id="addQuestion" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Add Question </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeAddCatIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					
				</div>
				<div class="modal-footer">
					<button type="button" id="submitQuestion" class="btn btn-submit">Submit</button>
					<button type="button" id="closeAddQuesBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
<?php include('pages/main/footer.php'); ?>