$(document).ready(function(){
	function isValidPhoneNumber(phoneNumber) {
		// Define the regex pattern for a valid Nigerian phone number.
		// This pattern matches phone numbers in the formats: 08168290811, 2348168290811, +2348168290811.
		const pattern = /^(?:\+?234|0)?(7\d|8\d|9\d)\d{8}$/;
		
		// Test the phone number against the regex pattern.
		return pattern.test(phoneNumber);
	}
	
	let currentPage = $("#currentPage").val();
	let page = $("#page").val();
	let usertype = $("#user-type").val();
	
	var userType = $("#userType").val();
	
	$("#backBtn").on('click', function(){
		$.ajax({
			type: 'POST',
			url:'resources/scripts/enumeration/scripts.php',
			data: 'action=back-btn',
			dataType:'JSON',
			beforeSend: function(){
				$("#backBtn").html('<i class="fas fa-spinner fa-spin"></i>...wait').attr('disabled','disabled');
			},
			success:function(responseData){
				if(responseData.header==='successful'){
					location.href='./';
				}
			}
		});
	});
	
	if(currentPage=='Trader Enumeration' && page=='3'){
		/////reset all the fields///////
		function resetAddBusinessForm(){
			$("#natureOfBusiness").val('');
			$("#businessAddress").val('');
			$("#businessTown").val('');
			$("#businessPhone").val('');
			$("#businessEmail").val('');
			$("#companyName").val('');
			$("#companyNumber").val('');
			$("#companyTin").val('');
			$.ajax({
				type:'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data:'action=load-states',
				success:function(responseData){
					$("#state").html(responseData);
					$('#cityMarket').html('<option value="">Select State first</option>');
					$('#market').html('<option value="">Select Market LGA first</option>');
				}
			});
			$.ajax({
				type:'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data:'action=load-business-category',
				success:function(responseData){
					$("#businessCategory").html(responseData);
				}
			});
			$.ajax({
				type:'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data:'action=load-business-scale',
				success:function(responseData){
					$("#businessScale").html(responseData);
				}
			});
		}
	}
	else if(currentPage=='Farmer Enumeration'){
		function resetAddFarmForm(){
			$("#natureOfBusiness").val('');
			$("#businessAddress").val('');
			$("#businessTown").val('');
			$("#businessPhone").val('');
			$("#businessEmail").val('');
			$("#companyName").val('');
			$("#companyNumber").val('');
			$("#companyTin").val('');
			$.ajax({
				type:'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data:'action=load-states',
				success:function(responseData){
					$("#state").html(responseData);
					$('#cityMarket').html('<option value="">Select State first</option>');
					$('#market').html('<option value="">Select Market LGA first</option>');
				}
			});
			$.ajax({
				type:'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data:'action=load-business-category',
				success:function(responseData){
					$("#businessCategory").html(responseData);
				}
			});
			$.ajax({
				type:'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data:'action=load-business-scale',
				success:function(responseData){
					$("#businessScale").html(responseData);
				}
			});
		}
	}
	
	if(userType==='Agent'){
		function resetImportUserForm(){
			$.ajax({
				type:'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data:'action=load-projects',
				success:function(responseData){
					$("#importProject").html(responseData);
					$("#importState").html('<option value="">Select Project First</option>');
					$('#importCity').html('<option value="">Select State First</option>');
				}
			});
		}

		$("#importProject").on('change', function(){
			var project = $(this).val();
			if(project){
				$("#importProject").removeClass('is-invalid');
				$.ajax({
					type:'POST',
					url:'resources/scripts/enumeration/scripts.php',
					data:'action=load-project-states',
					success:function(responseData){
						$("#importState").html(responseData);
						$('#importCity').html('<option value="">Select State first</option>');
					}
				});
			}
			else{
				$("#importProject").addClass('is-invalid');
				$("#importState").html('<option value="">Select Project First</option>');
				$("#importCity").html('<option value="">Select State First</option>');
			}
		});
		
		$("#importState").on('change', function(){
			var state = $(this).val();
			if(state){
				$(this).removeClass('is-invalid');
				$.ajax({
					type: 'POST',
					url:'resources/scripts/settings/website.php',
					data:'action=load-new-cities&stateid='+state,
					success:function(responseData){
						//alert(responseData);
						$("#importCity").html(responseData);
					}
				});
			}
			else{
				$("#importCity").html('<option value="">Select State First</option>');
				$(this).addClass('is-invalid');
			}
		});
		$("#importCity").on('change', function(){
			var city = $(this).val();
			if(city){
				$(this).removeClass('is-invalid');
			}
			else{
				$(this).addClass('is-invalid');
			}
		});
		
		
		// Add an event listener to detect when a file is selected
		$('#agentList').on('change', function() {
			const fileInput = document.getElementById('agentList');
			var errorMsg = '';
			var fd = new FormData();
			var project = $("#importProject").val();
			if(project){
				fd.append('project',project);
			}
			else{
				$("#importProject").addClass('is-invalid');
			}
			var state = $("#importState").val();
			if(state){
				fd.append('state',state);
			}
			else{
				$("#importState").addClass('is-invalid');
			}
			var city = $("#importCity").val();
			if(city){
				fd.append('city',city);
			}
			else{
				$("#importCity").addClass('is-invalid');
			}
			
			if (fileInput.files.length > 0) {
				var file = $('#agentList')[0].files;
			
				const fileName = fileInput.files[0].name;
				let files = fileInput.files[0];

				// Check if the file extension is valid (.xls or .xlsx)
				const validExtensions = ['xls', 'xlsx']; // Allowed extensions
				const fileExtension = fileName.split('.').pop().toLowerCase(); // Get the file extension

				if(!(validExtensions.includes(fileExtension))) {
					if(errorMsg){
						errorMsg += '<br>Invalid file type. Please select an Excel file.';
					}
					else{
						errorMsg = 'Invalid file type. Please select an Excel file.';
					}
				}
				else{
					fd.append('file',file[0]);
				}
				$('#fileNameDisplay').html(fileName);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>No file selected';
				}
				else{
					errorMsg = 'No file selected';
				}
			}
			
			if(!errorMsg && project && state && city){
				fd.append('action','import-user');
				fd.append('userType',userType);
				
				$.ajax({
					url: 'resources/scripts/enumeration/scripts.php',
					type: 'POST',
					data: fd,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						$("#importMsg").html('Uploading. Please, wait...<i class="fa fa-spinner fa-spin"></i>').removeClass('text-danger');
					},
					success: function(response){
						if(response.header=='successful'){
							$('#agentList').val('');
							$("#importMsg").html(response.message);
							resetImportUserForm();
							$('#fileNameDisplay').html('Click or Drop Agent Template file here...');
						}
						else{
							$('#agentList').removeAttr('disabled').val('');
							$('#importMsg').addClass('text-danger').html(response.message);
							$('#fileNameDisplay').html('Click or Drop Agent Template file here...');
						}
					},
				});
			}
			else{
				$('#agentList').val('');
				$("#importMsg").html('<br><br>'+errorMsg).addClass('text-danger');
			}
		});
		
		$(document).delegate("[data-bs-target='#import-user']", "click", function() {
			$('#import-user').on('hide.bs.modal', function(e) {
				e.preventDefault();
			});
			resetImportUserForm();
		});
		$('#closeImportUserIcon').on('click', function(){
			$('#import-user').off("hide.bs.modal").trigger("click").modal('hide');
			location.href='';
		});
		$('#closeImportUserBtn').on('click', function(){
			$('#import-user').off("hide.bs.modal").trigger("click").modal('hide');
			location.href='';
		});
		
	}
	$(document).delegate("[data-bs-target='#add_business']", "click", function() {
        $('#add_business').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		resetAddBusinessForm();
	});
	$('#closeAddBusinessIcon').on('click', function(){
        $('#add_business').off("hide.bs.modal").trigger("click").modal('hide');
    });
	$('#closeAddBusinessBtn').on('click', function(){
        $('#add_business').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$("#addBusiness").on('click', function(){
		let formdata = new FormData();
		let errorMsg = '';
		
		let businessState = $("#state").val();
		if(businessState){
			$("#state").removeClass('is-invalid');
			formdata.append('businessState',businessState);
		}
		else{
			$("#state").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>State is required';
			}
			else{
				errorMsg += 'State is required';
			}
		}
		let businessCity = $("#cityMarket").val();
		if(businessCity){
			$("#cityMarket").removeClass('is-invalid');
			formdata.append('businessCity',businessCity);
		}
		else{
			$("#cityMarket").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>LGA is required';
			}
			else{
				errorMsg += 'LGA is required';
			}
		}
		let market = $("#market").val();
		if(market){
			formdata.append('market',market);
		}
		else{
			formdata.append('market','');
		}
		let shopNumber = $("#shopNumber").val();
		if(shopNumber){
			formdata.append('shopNumber',shopNumber);
		}
		else{
			formdata.append('shopNumber','');
		}
		let natureOfBusiness = $("#natureOfBusiness").val();
		if(natureOfBusiness){
			$("#natureOfBusiness").removeClass('is-invalid');
			formdata.append('natureOfBusiness',natureOfBusiness);
		}
		else{
			$("#natureOfBusiness").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Nature of Business is required';
			}
			else{
				errorMsg += 'Nature of Business is required';
			}
		}
		let businessCategory = $("#businessCategory").val();
		if(businessCategory){
			$("#businessCategory").removeClass('is-invalid');
			formdata.append('businessCategory',businessCategory);
		}
		else{
			$("#businessCategory").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Business Category is required';
			}
			else{
				errorMsg += 'Business Category is required';
			}
		}
		let businessScale = $("#businessScale").val();
		if(businessScale){
			$("#businessScale").removeClass('is-invalid');
			formdata.append('businessScale',businessScale);
		}
		else{
			$("#businessScale").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Business Scale is required';
			}
			else{
				errorMsg += 'Business Scale is required';
			}
		}
		let businessAddress = $("#businessAddress").val();
		if(businessAddress){
			$("#businessAddress").removeClass('is-invalid');
			formdata.append('businessAddress',businessAddress);
		}
		else{
			$("#businessAddress").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Business Address is required';
			}
			else{
				errorMsg += 'Business Address is required';
			}
		}
		let businessTown = $("#businessTown").val();
		if(businessTown){
			$("#businessTown").removeClass('is-invalid');
			formdata.append('businessTown',businessTown);
		}
		else{
			$("#businessTown").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Business Town is required';
			}
			else{
				errorMsg += 'Business Town is required';
			}
		}
		let businessPhone = $("#businessPhone").val();
		if(businessPhone){
			if(isValidPhoneNumber(businessPhone)){
				$("#businessPhone").removeClass('is-invalid');
				formdata.append('businessPhone',businessPhone);
			}
			else{
				$("#businessPhone").addClass('is-invalid');
				if(errorMsg){
					errorMsg += '<br>Invalid Phone Number';
				}
				else{
					errorMsg += 'Invalid Phone Number';
				}
			}
		}
		else{
			$("#businessPhone").addClass('is-invalid');
			errorMsg += 'Business Phone is required';
		}
		let businessEmail = $("#businessEmail").val();
		if(businessEmail){
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(businessEmail))){
				$("#businessEmail").addClass('is-invalid');
				if(errorMsg){
					errorMsg += '<br>Invalid Email Entered';
				}
				else{
					errorMsg += 'Invalid Email Entered';
				}
			}
			else{
				formdata.append('businessEmail',businessEmail);
			}
		}
		else{
			formdata.append('businessEmail','');
		}
		let companyName = $("#companyName").val();
		if(companyName){
			formdata.append('companyName',companyName);
		}
		else{
			formdata.append('companyName','');
		}
		let companyNumber = $("#companyNumber").val();
		if(companyNumber){
			formdata.append('companyNumber',companyNumber);
		}
		else{
			formdata.append('companyNumber','');
		}
		let companyTin = $("#companyTin").val();
		if(companyTin){
			formdata.append('companyTin',companyTin);
		}
		else{
			formdata.append('companyTin','');
		}
		
		if(!errorMsg){
			formdata.append('action','add-business');
			$.ajax({
				type: 'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#addBusiness").html('Please, wait...<i class="fas fa-spinner fa-spin"></i>').attr('disabled','disabled');
					$("#bzsgBox").html('');
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						$("#businessAdded").val(responseData.businessAdded);
						resetAddBusinessForm();
						loadBusinesses();
						$("#add_business").off("hide.bs.modal").modal('hide');
						$("#addBusiness").html('Submit Details <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
					}
					else{
						$("#bzMsgBox").html(responseData.message).addClass('text-danger');
						$("#addBusiness").html('Submit Details <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
					}
				}
			});
		}
		else{
			$("#bzMsgBox").html(errorMsg).addClass('text-danger');
		}
	});
	
	$(document).delegate("[data-bs-target='#edit_business']", "click", function() {
        let bizIndex = $(this).attr('data-id');
        let bizName = $(this).attr('name');
		$("#bizName").val(bizName);
		alert(bizIndex);
		/* if(bizIndex){
			$.ajax({
				type: 'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data: 'action=load-edit-business&bizIndex'+bizIndex,
				beforeSend: function(){
					$("#editBusinessBody").html('<h4 class="text-center">Please, wait...<i class="fas fa-spinner fa-spin"></i></h4>');
				},
				success:function(responseData){
					$("#editBusinessBody").html(responseData);
				}
			});
		} */
    });
	
	$(document).delegate("[data-bs-target='#delete_business']", "click", function() {
        let bizIndex = $(this).attr('data-id');
		
		$("#delId").val(bizIndex);
		$("#deleteBusinessBtn").removeAttr('disabled').html('<i class="fas fa-check-circle"></i> Yes, Delete');
		$("#deletePanel").html('This action cannot be reversed.<br>Are you sure you want to delete?');
		$('#delete_business').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
	});
	
	$("#closeDeleteBtn").on('click', function(){
		$('#delete_business').off("hide.bs.modal").trigger("click").modal('hide');
	});
	
	$("#deleteBusinessBtn").on('click', function(){
		var deleteId = $("#delId").val();
		if(deleteId){
			$.ajax({
				type: 'POST',
				url: 'resources/scripts/enumeration/scripts.php',
				data: 'action=delete-business&busId='+deleteId,
				dataType: 'JSON',
				beforeSend: function(){
					$("#deleteBusinessBtn").html('Please, wait...<i class="fas fa-spinner fa-spin"></i>').attr('disabled','disabled');
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						$("#deletePanel").html('<h2 class="text-success"><i class="fa fa-check-circle"></i><br>Business Successfully deleted</h2>');
						$('#delete_business').off("hide.bs.modal").modal('hide');
						loadBusinesses();
					}
					else{
						$("#deleteBusinessBtn").html('<i class="fas fa-check-circle"></i> Yes, Delete').removeAttr('disabled');
						$("#deletePanel").html(responseData.message);
					}
				}
			});
		}
		else{
			$("#deletePanel").html('Invalid Business ID');
		}
	});
	
	$(document).delegate("[data-bs-target='#add_farm']", "click", function() {
        $('#add_farm').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		resetAddBusinessForm();
	});
	$('#closeAddFarmIcon').on('click', function(){
        $('#add_farm').off("hide.bs.modal").trigger("click").modal('hide');
    });
	$('#closeAddFarmBtn').on('click', function(){
        $('#add_farm').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$("#natureOfOccupancy").on('change', function(){
		let natureOfOccupancy = $("#natureOfOccupancy").val();
		if(natureOfOccupancy){
			$("#natureOfOccupancy").removeClass('is-invalid');
			if(natureOfOccupancy==='Others'){
				$("#otherNatureView").attr('style', 'display: block');
				$("#otherNature").val('');
			}
			else{
				$("#otherNatureView").attr('style', 'display: none');
			}
		}
		else{
			$("#natureOfOccupancy").addClass('is-invalid');
		}
	})
	$("#ownershipPeriod").on('change', function(){
		let ownershipPeriod = $("#ownershipPeriod").val();
		if(ownershipPeriod){
			$("#ownershipPeriod").removeClass('is-invalid');
			if(ownershipPeriod==='Temporary'){
				$("#otherOwenershipView").attr('style', 'display: block');
				$("#otherOwenership").val('');
			}
			else{
				$("#otherOwenershipView").attr('style', 'display: none');
			}
		}
		else{
			$("#ownershipPeriod").addClass('is-invalid');
		}
	})
		
	$("#addFarm").on('click', function(){
		let formdata = new FormData();
		let errorMsg = '';
		
		let businessName = $("#businessName").val();
		if(businessName){
			formdata.append('businessName',businessName);
		}
		else{
			formdata.append('businessName','');
		}
		let businessScale = $("#businessScale").val();
		if(businessScale){
			$("#businessScale").removeClass('is-invalid');
			formdata.append('businessScale',businessScale);
		}
		else{
			$("#businessScale").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Business Scale is required';
			}
			else{
				errorMsg += 'Business Scale is required';
			}
		}
		let community = $("#community").val();
		if(community){
			$("#community").removeClass('is-invalid');
			formdata.append('community',community);
		}
		else{
			$("#community").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Community is required';
			}
			else{
				errorMsg += 'Community is required';
			}
		}
		let address = $("#address").val();
		if(address){
			$("#address").removeClass('is-invalid');
			formdata.append('address',address);
		}
		else{
			$("#address").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Address is required';
			}
			else{
				errorMsg += 'Address is required';
			}
		}
		let natureOfFarming = $("#natureOfFarming").val();
		if(natureOfFarming){
			$("#natureOfFarming").removeClass('is-invalid');
			formdata.append('natureOfFarming',natureOfFarming);
		}
		else{
			$("#natureOfFarming").addClass('is-invalid');
		}
		let state = $("#state").val();
		if(state){
			$("#state").removeClass('is-invalid');
			formdata.append('state',state);
		}
		else{
			$("#state").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>State is required';
			}
			else{
				errorMsg += 'State is required';
			}
		}
		let city = $("#city").val();
		if(city){
			$("#city").removeClass('is-invalid');
			formdata.append('city',city);
		}
		else{
			$("#city").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>LGA is required';
			}
			else{
				errorMsg += 'LGA is required';
			}
		}
		let phone = $("#phone").val();
		if(phone){
			if(isValidPhoneNumber(phone)){
				$("#phone").removeClass('is-invalid');
				formdata.append('phone',phone);
			}
			else{
				$("#phone").addClass('is-invalid');
				if(errorMsg){
					errorMsg += '<br>Invalid Phone Number';
				}
				else{
					errorMsg += 'Invalid Phone Number';
				}
			}
		}
		else{
			$("#phone").addClass('is-invalid');
			errorMsg += 'Business Phone is required';
		}
		let email = $("#email").val();
		if(email){
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
				$("#email").addClass('is-invalid');
				if(errorMsg){
					errorMsg += '<br>Invalid Email Entered';
				}
				else{
					errorMsg += 'Invalid Email Entered';
				}
			}
			else{
				formdata.append('email',email);
			}
		}
		else{
			formdata.append('email','');
		}
		
		let companyTin = $("#companyTin").val();
		if(companyTin){
			formdata.append('companyTin',companyTin);
		}
		else{
			formdata.append('companyTin','');
		}
		let natureOfOccupancy = $("#natureOfOccupancy").val();
		if(natureOfOccupancy){
			$("#natureOfOccupancy").removeClass('is-invalid');
			formdata.append('natureOfOccupancy',natureOfOccupancy);
		}
		else{
			$("#natureOfOccupancy").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Nature of Occupancy is required';
			}
			else{
				errorMsg += 'Nature of Occupancy is required';
			}
		}
		let ownershipPeriod = $("#ownershipPeriod").val();
		if(ownershipPeriod){
			$("#ownershipPeriod").removeClass('is-invalid');
			formdata.append('ownershipPeriod',ownershipPeriod);
		}
		else{
			$("#ownershipPeriod").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Period of Ownership is required';
			}
			else{
				errorMsg += 'Period of Ownership is required';
			}
		}
		
		let natureOfBusiness = $("#natureOfBusiness").val();
		if(natureOfBusiness){
			$("#natureOfBusiness").removeClass('is-invalid');
			formdata.append('natureOfBusiness',natureOfBusiness);
		}
		else{
			$("#natureOfBusiness").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Nature of Business is required';
			}
			else{
				errorMsg += 'Nature of Business is required';
			}
		}
		let businessCategory = $("#businessCategory").val();
		if(businessCategory){
			$("#businessCategory").removeClass('is-invalid');
			formdata.append('businessCategory',businessCategory);
		}
		else{
			$("#businessCategory").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Business Category is required';
			}
			else{
				errorMsg += 'Business Category is required';
			}
		}
		let sizeOfLand = $("#sizeOfLand").val();
		if(sizeOfLand){
			$("#sizeOfLand").removeClass('is-invalid');
			formdata.append('sizeOfLand',sizeOfLand);
		}
		else{
			$("#sizeOfLand").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Size of Land is required';
			}
			else{
				errorMsg += 'Size of Land is required';
			}
		}
		
		if(!errorMsg){
			formdata.append('action','add-farm');
			$.ajax({
				type: 'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#addBusiness").html('Please, wait...<i class="fas fa-spinner fa-spin"></i>').attr('disabled','disabled');
					$("#bzsgBox").html('');
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						$("#businessAdded").val(responseData.businessAdded);
						resetAddBusinessForm();
						loadBusinesses();
						$("#add_business").off("hide.bs.modal").modal('hide');
						$("#addBusiness").html('Submit Details <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
					}
					else{
						$("#bzMsgBox").html(responseData.message).addClass('text-danger');
						$("#addBusiness").html('Submit Details <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
					}
				}
			});
		}
		else{
			$("#bzMsgBox").html(errorMsg).addClass('text-danger');
		}
	});
	
	$(document).delegate("[data-bs-target='#edit_farm']", "click", function() {
        let bizIndex = $(this).attr('data-id');
        let bizName = $(this).attr('name');
		$("#bizName").val(bizName);
		alert(bizIndex);
		/* if(bizIndex){
			$.ajax({
				type: 'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data: 'action=load-edit-business&bizIndex'+bizIndex,
				beforeSend: function(){
					$("#editBusinessBody").html('<h4 class="text-center">Please, wait...<i class="fas fa-spinner fa-spin"></i></h4>');
				},
				success:function(responseData){
					$("#editBusinessBody").html(responseData);
				}
			});
		} */
    });
	
	$(document).delegate("[data-bs-target='#delete_farm']", "click", function() {
        let bizIndex = $(this).attr('data-id');
		
		$("#delId").val(bizIndex);
		$("#deleteBusinessBtn").removeAttr('disabled').html('<i class="fas fa-check-circle"></i> Yes, Delete');
		$("#deletePanel").html('This action cannot be reversed.<br>Are you sure you want to delete?');
		$('#delete_business').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
	});
	
	$("#closeDeleteFarmBtn").on('click', function(){
		$('#delete_business').off("hide.bs.modal").trigger("click").modal('hide');
	});
	
	$("#deleteFarmBtn").on('click', function(){
		var deleteId = $("#delId").val();
		if(deleteId){
			$.ajax({
				type: 'POST',
				url: 'resources/scripts/enumeration/scripts.php',
				data: 'action=delete-business&busId='+deleteId,
				dataType: 'JSON',
				beforeSend: function(){
					$("#deleteBusinessBtn").html('Please, wait...<i class="fas fa-spinner fa-spin"></i>').attr('disabled','disabled');
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						$("#deletePanel").html('<h2 class="text-success"><i class="fa fa-check-circle"></i><br>Business Successfully deleted</h2>');
						$('#delete_business').off("hide.bs.modal").modal('hide');
						loadBusinesses();
					}
					else{
						$("#deleteBusinessBtn").html('<i class="fas fa-check-circle"></i> Yes, Delete').removeAttr('disabled');
						$("#deletePanel").html(responseData.message);
					}
				}
			});
		}
		else{
			$("#deletePanel").html('Invalid Business ID');
		}
	});
	
	if(page==='3' || page=='5'){
		loadBusinesses();
	}
	
	function loadBusinesses(){
		$.ajax({
			type: 'POST',
			url:'resources/scripts/enumeration/scripts.php',
			data: 'action=fetch-companies&userType='+userType,
			dataType: 'JSON',
			beforeSend: function(){
				$("#loadBusinesses").html('<h4 class="text-center">Please, wait...<i class="fas fa-spinner fa-spin"></i></h4>');
			},
			success:function(responseData){
				$("#loadBusinesses").html(responseData.message);
				$("#businessAdded").val(responseData.businessAdded);
			}
		});
	}
	
	$("#continueBtnBvn").on('click', function(){
		let formdata = new FormData();
		let errorMsg = '';
		alert('Clicked');
		
		if(page===''){
			var bvn = $("#bvn").val();
			if(bvn){
				if(bvn.length!=11){
					$("#bvn").addClass('is-invalid');
					errorMsg += 'Invalid BVN';
				}
				else{
					$("#bvn").removeClass('is-invalid');
					formdata.append('bvn',bvn);
				}
			}
			else{
				if(errorMsg){
					errorMsg += '<br>BVN is required';
				}
				else{
					errorMsg += 'BVN is required';
				}
				$("#bvn").addClass('is-invalid');
			}
		}
		
		if(!errorMsg){
			formdata.append('action','trader-enumeration-bvn-validation');
			formdata.append('userType',userType);
			$.ajax({
				type: 'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#continueBtnBvn").html('Please, wait...<i class="fas fa-spinner fa-spin"></i>').attr('disabled','disabled');
					$("#msgBox").html('');
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						setTimeout(function(){
							$('#generateAccount').off("hide.bs.modal").trigger("click").modal('hide');
							location.href="./";
						},1000);
						if(responseData.recordField!=''){
							$("#bvnData").html(responseData.recordField).attr('style','display:block;');
							$("#continueBtn").html('Continue <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
						}
						else{
							$("#continueBtn").html('Continue <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
							location.href='./';
						}
					}
					else{
						$("#msgBox").html(responseData.message).addClass('text-danger');
						$("#continueBtn").html('Continue <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
					}
				}
			});
		}
		else{
			$("#msgBox").html(errorMsg).addClass('text-danger');
		}
	});
	
	$("#continueBtn").on('click', function(){
		let formdata = new FormData();
		let errorMsg = '';
		
		if(page==='' || page==='0'){
			var lastname = $("#lastname").val();
			if(lastname){
				$("#lastname").removeClass('is-invalid');
				formdata.append('lastname',lastname);
			}
			else{
				$("#lastname").addClass('is-invalid');
				errorMsg += 'Surname is required';
			}
			var firstname = $("#firstname").val();
			if(firstname){
				$("#firstname").removeClass('is-invalid');
				formdata.append('firstname',firstname);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>First Name is required';
				}
				else{
					errorMsg += 'First Name is required';
				}
				$("#firstname").addClass('is-invalid');
			}
			var title = $("#title").val();
			if(title){
				$("#title").removeClass('is-invalid');
				formdata.append('title',title);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Title is required';
				}
				else{
					errorMsg += 'Title is required';
				}
				$("#title").addClass('is-invalid');
			}
			var middlename = $("#middlename").val();
			if(middlename){
				formdata.append('middlename',middlename);
			}
			var email = $("#email").val();
			if(email){
				if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
					$("#email").addClass('is-invalid');
					if(errorMsg){
						errorMsg += '<br>Invalid Email Entered';
					}
					else{
						errorMsg += 'Invalid Email Entered';
					}
				}
				else{
					$("#email").removeClass('is-invalid');
					formdata.append('email',email);
				}
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Email is required';
				}
				else{
					errorMsg += 'Email is required';
				}
				$("#email").addClass('is-invalid');
			}
			var phone = $("#phone").val();
			if(phone){
				if(isValidPhoneNumber(phone)){
					$("#phone").removeClass('is-invalid');
					formdata.append('phone',phone);
				}
				else{
					$("#phone").addClass('is-invalid');
					if(errorMsg){
						errorMsg += '<br>Invalid Phone Number';
					}
					else{
						errorMsg += 'Invalid Phone Number';
					}
				}
			}
			else{
				$("#phone").addClass('is-invalid');
				if(errorMsg){
					errorMsg += '<br>Phone Number is required';
				}
				else{
					errorMsg += 'Phone Number is required';
				}
			}
			formdata.append('page',page);
		}
		else if(page==='1'){
			var nin = $("#nin").val();
			if(nin){
				if(nin.length!=11){
					$("#nin").addClass('is-invalid');
					errorMsg += 'Invalid NIN';
				}
				else{
					$("#nin").removeClass('is-invalid');
					formdata.append('nin',nin);
				}
			}
			else{
				$("#nin").addClass('is-invalid');
				errorMsg += 'NIN is required';
			}
			var bvn = $("#bvn").val();
			if(bvn){
				if(bvn.length!=11){
					$("#bvn").addClass('is-invalid');
					errorMsg += 'Invalid BVN';
				}
				else{
					$("#bvn").removeClass('is-invalid');
					formdata.append('bvn',bvn);
				}
			}
			else{
				if(errorMsg){
					errorMsg += '<br>BVN is required';
				}
				else{
					errorMsg += 'BVN is required';
				}
				$("#bvn").addClass('is-invalid');
			}
			
			var dateOfBirth = $("#dateOfBirth").val();
			if(dateOfBirth){
				$("#dateOfBirth").removeClass('is-invalid');
				formdata.append('dateOfBirth',dateOfBirth);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Date of Birth is required';
				}
				else{
					errorMsg += 'Date of Birth is required';
				}
				$("#dateOfBirth").addClass('is-invalid');
			}
			
			var gender = $("#gender").val();
			if(gender){
				$("#gender").removeClass('is-invalid');
				formdata.append('gender',gender);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Gender is required';
				}
				else{
					errorMsg += 'Gender is required';
				}
				$("#gender").addClass('is-invalid');
			}
			
			var maritalStatus = $("#maritalStatus").val();
			if(maritalStatus){
				$("#maritalStatus").removeClass('is-invalid');
				formdata.append('maritalStatus',maritalStatus);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Marital Status is required';
				}
				else{
					errorMsg += 'Marital Status is required';
				}
				$("#maritalStatus").addClass('is-invalid');
			}
			
			var genotype = $("#genotype").val();
			if(genotype){
				$("#genotype").removeClass('is-invalid');
				formdata.append('genotype',genotype);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Genotype is required';
				}
				else{
					errorMsg += 'Genotype is required';
				}
				$("#genotype").addClass('is-invalid');
			}
			var bloodGroup = $("#bloodGroup").val();
			if(bloodGroup){
				$("#bloodGroup").removeClass('is-invalid');
				formdata.append('bloodGroup',bloodGroup);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Blood Group is required';
				}
				else{
					errorMsg += 'Blood Group is required';
				}
				$("#bloodGroup").addClass('is-invalid');
			}
			
			var stateOfOrigin = $("#state").val();
			if(stateOfOrigin){
				$("#state").removeClass('is-invalid');
				formdata.append('stateOfOrigin',stateOfOrigin);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>State of Origin is required';
				}
				else{
					errorMsg += 'State of Origin is required';
				}
				$("#state").addClass('is-invalid');
			}
			var lgaOfOrigin = $("#city").val();
			if(lgaOfOrigin){
				$("#city").removeClass('is-invalid');
				formdata.append('lgaOfOrigin',lgaOfOrigin);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>City/LGA is required';
				}
				else{
					errorMsg += 'City/LGA is required';
				}
				$("#city").addClass('is-invalid');
			}
		}
		else if(page==='2'){
			var houseNumber = $("#houseNumber").val();
			if(houseNumber){
				$("#houseNumber").removeClass('is-invalid');
				formdata.append('houseNumber',houseNumber);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>House Number is required';
				}
				else{
					errorMsg += 'House Number is required';
				}
				$("#houseNumber").addClass('is-invalid');
			}
			
			var streetName = $("#streetName").val();
			if(streetName){
				$("#streetName").removeClass('is-invalid');
				formdata.append('streetName',streetName);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>Street Name is required';
				}
				else{
					errorMsg += 'Street Name is required';
				}
				$("#streetName").addClass('is-invalid');
			}
			var stateOfResidence = $("#state").val();
			if(stateOfResidence){
				$("#state").removeClass('is-invalid');
				formdata.append('stateOfResidence',stateOfResidence);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>State of Residence is required';
				}
				else{
					errorMsg += 'State of Residence is required';
				}
				$("#state").addClass('is-invalid');
			}
			var lgaOfResidence = $("#city").val();
			if(lgaOfResidence){
				$("#city").removeClass('is-invalid');
				formdata.append('lgaOfResidence',lgaOfResidence);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>LGA of Residence is required';
				}
				else{
					errorMsg += 'LGA of Residence is required';
				}
				$("#city").addClass('is-invalid');
			}
			let residenceCity = $("#residenceCity").val();
			if(residenceCity){
				$("#residenceCity").removeClass('is-invalid');
				formdata.append('residenceCity',residenceCity);
			}
			else{
				if(errorMsg){
					errorMsg += '<br>City of Residence is required';
				}
				else{
					errorMsg += 'City of Residence is required';
				}
				$("#residenceCity").addClass('is-invalid');
			}
			
			if(userType==='Farmer'){
				let yearsOfExperience = $("#yearsOfExperience").val();
				if(yearsOfExperience){
					$("#yearsOfExperience").removeClass('is-invalid');
					formdata.append('yearsOfExperience',yearsOfExperience);
				}
				else{
					if(errorMsg){
						errorMsg += '<br>Years of Experience is required';
					}
					else{
						errorMsg += 'Years of Experience is required';
					}
					$("#yearsOfExperience").addClass('is-invalid');
				}
			}
		}
		else if(page==='3'){
			let businessAdded = $("#businessAdded").val();
			if(businessAdded){
				errorMsg = '';
			}
			else{
				if(userType==='Farmer'){
					errorMsg = '<div class="text-center"><br>You <b>MUST</b> add at least one <b>Farm Land</b></div>';
				}
				else{
					errorMsg = '<div class="text-center"><br>You <b>MUST</b> add at least one <b>Business</b></div>';
				}
			}
		}
		else if(page==='4'){
			
		}
		else if(page==='5'){
			
		}
		
		if(!errorMsg){
			formdata.append('action','trader-enumeration');
			formdata.append('userType',userType);
			$.ajax({
				type: 'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#continueBtn").html('Please, wait...<i class="fas fa-spinner fa-spin"></i>').attr('disabled','disabled');
					$("#msgBox").html('');
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						$("#continueBtn").html('Continue <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
						location.href='./';
					}
					else{
						$("#msgBox").html(responseData.message).addClass('text-danger');
						$("#continueBtn").html('Continue <i class="fas fa-arrow-right"></i>').removeAttr('disabled');
					}
				}
			});
		}
		else{
			$("#msgBox").html(errorMsg).addClass('text-danger');
		}
	});
	
	$('#image_signature').change(function(){
		var fd = new FormData();
		var files = $('#image_signature')[0].files;
		fd.append('file',files[0]);
		fd.append('action','upload-signature');
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: fd,
			contentType: false,
			processData: false,
			dataType:'JSON',
			beforeSend:function(){
				$('#sign_frames').html('Uploading. Please, wait...<i class="fa fa-spinner fa-spin"></i>');
				$('#image_signature').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					$('#sign_frames').html('<img src="'+response.data+'" width="150px"><br>Click to Change File...');
					$('#image_signature').removeAttr('disabled');
					$("#signatureDisplay").html('');
				}
				else{
					$('#msgBox').addClass('text-danger').html('<i class="fa fa-times-circle"></i> '+response.message);
					$('#image_frames').html('Click or Drop file again');
					$('#image_signature').removeAttr('disabled');
				}
			},
		});
	});
	$('#image_passport').change(function(){
		var fd = new FormData();
		var files = $('#image_passport')[0].files;
		fd.append('file',files[0]);
		fd.append('action','upload-passport');
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: fd,
			contentType: false,
			processData: false,
			dataType:'JSON',
			beforeSend:function(){
				$('#passport_frame').html('Uploading. Please, wait...<i class="fa fa-spinner fa-spin"></i>');
				$('#image_passport').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					$('#passport_frame').html('<img src="'+response.data+'" width="150px"><br>Click to Change File...');
					$('#image_passport').removeAttr('disabled');
					$("#passportDisplay").html('');
				}
				else{
					$('#msgBox').addClass('text-danger').html('<i class="fa fa-times-circle"></i> '+response.message);
					$('#passport_frame').html('Click or Drop file again');
					$('#image_passport').removeAttr('disabled');
				}
			},
		});
	});
	
	///////generate account number///////
	// 
	$("#generateAccountBtn").on('click', function(){
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: 'action=generate-account',
			dataType:'JSON',
			beforeSend:function(){
				$('#generateAccountBtn').html('Please, wait...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					$("#generateBody").html(response.message).removeClass('text-danger');
					$("#generateAccountBtn").attr('style','display: none;');
					$("#cancelView").attr('style','display: none;');
					$("#printSlip").attr('style','display: block;');
				}
				else{
					$("#generateBody").html(response.message).addClass('text-danger');
					$("#genBtnView").attr('style','display: none;');
					$("#saveBtnView").attr('style','display: block;');
					$("#cancelView").attr('style','display: block;');
				}
			},
		});
	});
	
	$("#saveDetailsBtn").on('click', function(){
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: 'action=save-details',
			dataType:'JSON',
			beforeSend:function(){
				$('#saveDetailsBtn').html('Saving...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					setTimeout(function(){
						$('#generateAccount').off("hide.bs.modal").trigger("click").modal('hide');
						location.href="./";
					},1000);
				}
				else{
					$("#generateBody").html(response.message).addClass('text-danger');
					$('#saveDetailsBtn').html('<i class="fas fa-save"></i> Save Again').removeAttr('disabled');
				}
			},
		});
	});
	
	$("#saveEnumeration").on('click', function(){
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: 'action=save-details',
			dataType:'JSON',
			beforeSend:function(){
				$('#saveEnumeration').html('Saving...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					if(response.enumHeading==='Incomplete Enumeration'){
						$("#saveEnumMsg").html(response.message);
						$('#saveEnumeration').attr('style','display: none;');
						$("#startOverBtn").html('<i class="fas fa-times-circle"></i> Close')
					}
					else{
						$("#saveEnumMsg").html(response.message);
						$('#saveEnumeration').attr('style','display: none;');
						$("#startOverBtn").attr('style','display: none;');
						$('#printSlipMain').attr('style','display: block;');
					}
					
					location.href="./";
				}
				else{
					$("#saveEnumMsg").html(response.message);
					$('#saveEnumeration').html('<i class="fas fa-save"></i> Save Again').removeAttr('disabled');
				}
			},
		});
	});
	
	$(document).delegate("[data-bs-target='#startOver']", "click", function(){
        $('#saveEnumeration').html('<i class="fas fa-save"></i> Yes, Save').removeAttr('disabled');
		$('#startOver').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		var saveSession = $("#saveSession").val();
		
		$("#saveEnumMsg").html('Do you want to save your current process for <b>'+saveSession+'</b> and exit?');
	});
	
	$('#closeStartIcon').on('click', function(){
        $('#startOver').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$(document).delegate("[data-bs-target='#generateAccount']", "click", function() {
        $('#generateAccountBtn').html('<i class="fas fa-bank"></i> Yes, Generate').removeAttr('disabled').attr('style','display: block;');
		$('#generateAccount').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		$("#saveBtnView").attr('style','display: none;');
		$("#cancelView").attr('style','display: block;');
		$("#genBtnView").attr('style','display: block;');
		$("#generateBody").html('Kindly note that you won\'t be able to make further changes to this account after generating Bank Account and JTB TIN.<br><b class="text-danger">Are you sure you want to continue?</b>');
		$("#printSlip").attr('style','display: none;');
	});
	
	$("#startOverBtn").on('click', function(){
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: 'action=start-over',
			dataType:'JSON',
			beforeSend:function(){
				$('#startOverBtn').html('Please, wait...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					location.href="./";
				}
			},
		});
	});
	$("#printSlipMain").on('click', function(){
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: 'action=print-slip',
			dataType:'JSON',
			beforeSend:function(){
				$('#printSlipMain').html('Please, wait...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					location.href="./";
				}
			},
		});
	});
	$("#printSlip").on('click', function(){
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: 'action=print-slip',
			dataType:'JSON',
			beforeSend:function(){
				$('#printSlipMain').html('Please, wait...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					location.href="./";
				}
			},
		});
	});
	
	$('#closeGenerateBtn').on('click', function(){
		$.ajax({
			url: 'resources/scripts/enumeration/scripts.php',
			type: 'POST',
			data: 'action=start-over',
			dataType:'JSON',
			beforeSend:function(){
				$('#closeGenerateBtn').html('Exiting...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
			},
			success: function(response){
				if(response.header=='successful'){
					$('#generateAccount').off("hide.bs.modal").trigger("click").modal('hide');
					location.href="./";
				}
				else{
					$("#saveEnumMsg").html(response.message);
					$('#saveEnumeration').html('<i class="fas fa-save"></i> Save Again').removeAttr('disabled');
				}
			},
		});
    });
	$('#closeGenerateIcon').on('click', function(){
        $('#generateAccount').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	
	////////////////ACCOUNT MANAGEMENT////////////////
	$(document).delegate("[data-bs-target='#generate_account']", "click", function(){
        $('#generate_account').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		var generateAccountId = $(this).attr('data-id');
		var generateAccountName = $(this).attr('name');
		$("#generateAccountId").val(generateAccountId);
		$("#generateAccountHeader").addClass('bg-success').removeClass('bg-danger');
		$("#generateAccountBody").html('Kindly note that you won\'t be able to make further changes to this account for <b>'+generateAccountName+'</b> after generating Bank Account and JTB TIN. <br><b class="text-danger">Are you sure you want to continue?</b>')
		$("#generateBankAccountBtn").html('<i class="fas fa-bank"></i> Yes, Generate').removeAttr('disabled');
	});
	
	$("#generateBankAccountBtn").on('click', function(){
		var matanId = $("#generateAccountId").val();
		if(matanId){
			$.ajax({
				url: 'resources/scripts/enumeration/scripts.php',
				type: 'POST',
				data: 'action=generate-bank-account&matanid='+matanId,
				dataType:'JSON',
				beforeSend:function(){
					$('#generateBankAccountBtn').html('Please, wait...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
				},
				success: function(response){
					if(response.header=='successful'){
						setTimeout(function(){
							$('#generateAccountBody').html(response.message);
							$("#generateBankAccountBtn").attr('style','display: none;');
							$("#printAccountSlip").attr('style','display: block;');
							loadTraders();
						},1000);
					}
					else{
						$("#generateAccountHeader").addClass('bg-danger').removeClass('bg-success');
						$('#generateAccountBody').html(response.message);
						$('#generateBankAccountBtn').html('<i class="fas fa-redo"></i> Try Again').removeAttr('disabled');
					}
				},
			});
		}
	});
	
	$('#closeGenerateAccountIcon').on('click', function(){
        $('#generate_account').off("hide.bs.modal").trigger("click").modal('hide');
    });
	$('#closeGenerateAccountBtn').on('click', function(){
        $('#generate_account').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$(document).delegate("[data-bs-target='#edit_account_details']", "click", function(){
        $('#edit_account_details').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		var editAccountId = $(this).attr('data-id');
		var editAccountName = $(this).attr('name');
		$("#editAccountId").val(editAccountId);
		$("#editAccountBody").html('Kindly note that you are about editing the record for <b>'+editAccountName+'</b>. <br><b class="text-danger">Are you sure you want to continue?</b>')
		$("#editAccountBtn").html('<i class="fas fa-edit"></i> Yes, Edit').removeAttr('disabled');
	});
	$('#closeEditAccountIcon').on('click', function(){
        $('#edit_account_details').off("hide.bs.modal").trigger("click").modal('hide');
    });
	$('#closeEditAccountBtn').on('click', function(){
        $('#edit_account_details').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$("#editAccountBtn").on('click', function(){
		let matanId = $("#editAccountId").val();
		if(matanId){
			$.ajax({
				url: 'resources/scripts/enumeration/scripts.php',
				type: 'POST',
				data: 'action=edit-trader-details&matanid='+matanId,
				dataType:'JSON',
				beforeSend:function(){
					$('#editAccountBtn').html('Loading...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
				},
				success: function(response){
					if(response.header=='successful'){
						location.href="./?loc=traders/add";
					}
					else{
						$('#editAccountBody').html(response.message);
						$('#editAccountBtn').html('<i class="fas fa-redo"></i> Try Again').removeAttr('disabled');
					}
				},
			});
		}
	});
	
	//////EXIT THE TRADER EDITING SCRIPT////////
	$(document).delegate("[data-bs-target='#exit_edit_account_details']", "click", function(){
        $('#exit_edit_account_details').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		
		$.ajax({
			type: 'POST',
			url: 'resources/scripts/enumeration/scripts.php',
			data: 'action=exit-edit-trader',
			dataType: 'JSON',
			beforeSend:function(){
				$("#exitEditAccountBody").html('<h1 class="text-info">Saving...<i class="fa fa-spinner fa-spin"></i></h1>');
			},
			success:function(responseData){
				if(responseData.header==='successful'){
					$("#exitEditAccountBody").html('<h1 class="text-primary"><i class="fa fa-check-circle"></i><br>Details Updated</h1>');
				}
				else{
					$("#exitEditAccountBody").html('<h1 class="text-danger"><i class="fa fa-exclamation-circle"></i><br>Oops! Error Occurred.</h1>');
				}
			}
		});
	});
	$('#closeExitEditAccountIcon').on('click', function(){
        $('#exit_edit_account_details').off("hide.bs.modal").trigger("click").modal('hide');
		location.href='./';
    });
	
	/////exit the editing///
	$(document).delegate("[data-bs-target='#cancelEdit']", "click", function(){
        $('#cancelEdit').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
	});
	$("#exitEditTraderBtn").on('click', function(){
		$.ajax({
			type: 'POST',
			url: 'resources/scripts/enumeration/scripts.php',
			data: 'action=exit-edit-trader',
			dataType: 'JSON',
			beforeSend:function(){
				$("#exitEditTraderBtn").html('Exiting...<i class="fa fa-spinner fa-spin"></i></h1>');
			},
			success:function(responseData){
				if(responseData.header==='successful'){
					location.href='./';
				}
				
			}
		});
	});
	
	$('#closeEditTraderBtn').on('click', function(){
        $('#cancelEdit').off("hide.bs.modal").trigger("click").modal('hide');
    });
	$('#closeEditTraderIcon').on('click', function(){
        $('#cancelEdit').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$(document).delegate("[data-bs-target='#delete_account']", "click", function(){
        $('#delete_account').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		var deleteAccountId = $(this).attr('data-id');
		var deleteAccountName = $(this).attr('name');
		$("#deleteAccountId").val(editAccountId);
		$("#deleteAccountBody").html('This action will delete the trader enumeration details for <b id="deleteAccountName">'+deleteAccountName+'</b><br><b class="text-danger">Are you sure you want to continue?</b>')
		$("#editAccountBtn").html('<i class="fas fa-edit"></i> Yes, Edit').removeAttr('disabled');
	});
	$('#closeDeleteAccountIcon').on('click', function(){
        $('#delete_account').off("hide.bs.modal").trigger("click").modal('hide');
    });
	$('#closeDeleteAccountBtn').on('click', function(){
        $('#delete_account').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$("#cityMarket").on('change', function(){
        var city = $(this).val();
        //alert(state);
        if(city){
            $(this).removeClass('is-invalid');
			$.ajax({
                type: 'POST',
                url:'resources/scripts/enumeration/scripts.php',
                data:'action=load-markets&cityid='+city,
                success:function(responseData){
                    //alert(responseData);
                    $("#market").html(responseData);
                }
            });
        }
        else{
            $(this).addClass('is-invalid');
			$("#market").html('<option value="">Select Market LGA first</option>');
        }
    })
	
	//////////Add New Market//////////////
	$("#addMarket").on('click', function(){
		var formdata = new FormData();
		
		var marketname = $("#marketname").val();
		if(marketname===''){
			$("#marketname").addClass('is-invalid');
		}
		else{
			$("#marketname").removeClass('is-invalid');
			formdata.append('marketname',marketname);
		}
		var marketstate = $("#state").val();
		if(marketstate===''){
			$("#state").addClass('is-invalid');
		}
		else{
			$("#state").removeClass('is-invalid');
			formdata.append('marketstate',marketstate);
		}
		var marketcity = $("#city").val();
		if(marketcity===''){
			$("#city").addClass('is-invalid');
		}
		else{
			$("#city").removeClass('is-invalid');
			formdata.append('marketcity',marketcity);
		}
		var marketaddress = $("#marketaddress").val();
		if(marketaddress===''){
			$("#marketaddress").addClass('is-invalid');
		}
		else{
			$("#marketaddress").removeClass('is-invalid');
			formdata.append('marketaddress',marketaddress);
		}
		
		if(marketname && marketstate && marketcity && marketaddress){
			formdata.append('action', 'add-market');
			$.ajax({
                type: 'POST',
                url:'resources/scripts/enumeration/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#msgBox").html('Please, wait...<i class="fas fa-spinner fa-spin"></i> We are adding market.').addClass('text-info').removeClass('text-danger');
				},
                success:function(responseData){
					if(responseData.header==='successful'){
						$("#msgBox").html('<i class="fas fa-check"></i> Market successfully submitted.').addClass('text-success').removeClass('text-info');
						$("#enumerationForm").reset();
					}
					else{
						$("#msgBox").html('<i class="fas fa-times-circle"></i> '+responseData.message).addClass('text-danger').removeClass('text-info');
					}
                }
            });
		}
		else{
			$("#msgBox").html('<i class="fas fa-times-circle"></i> Please, fill the form properly').addClass('text-danger');
		}
	});
	
	////edit market/////
	$(document).delegate("[data-target='#edit_market']", "click", function() {
        var mktId = $(this).attr('data-id');
        var title = $(this).attr('title');
		$("#editMarketHeader").html(title);
        $.ajax({
            type: 'POST',
			url:'resources/scripts/enumeration/scripts.php',
			data: 'action=get-edit-market&mktid='+mktId,
			beforeSend: function(){
                $("#editMarketBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#editMarketBody").html(responseData);
                $("#editBtn").attr('style','display: block;');
            }
        });

    });
	
	$(document).delegate("[data-bs-target='#edit_user_modal']", "click", function() {
        var userId = $(this).attr('data-id');
		if(userId){
			$.ajax({
				type: 'POST',
				url:'resources/scripts.php',
				data: 'action=edit-trader',
				contentType: false,
				processData: false,
				dataType:'JSON',
				success:function(responseData){
					$("#traderFullName").html(responseData.fullname);
				}
			});
		}
		else{
			alert('Invalid User');
		}
    });
	////delete market/////
	$(document).delegate("[data-bs-target='#delete_market']", "click", function() {
        var mktId = $(this).attr('data-id');
        var title = $(this).attr('title');
		var name = $(this).attr('name');
		$("#delMktNameBody").html(name);
		$("#delMktName").val(name);
		$("#delMktId").val(mktId);
        /* $.ajax({
            type: 'POST',
			url:'resources/scripts/enumeration/scripts.php',
			data: 'action=get-edit-market&mktid='+mktId,
			beforeSend: function(){
                $("#editMarketBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#editMarketBody").html(responseData);
                $("#editBtn").attr('style','display: block;');
            }
        }); */

    });
	
	$("#mktDelButton").on('click', function(){
		var mktId = $("#delMktId").val();
		var mktName = $("#delMktName").val();
		
		if(mktId){
			$.ajax({
				type: 'POST',
				url:'resources/scripts/enumeration/scripts.php',
				data: 'action=delete-market&mktid='+mktId,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#mktDelButton").html('Deleting...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
					$("#mktDelCancelButton").attr('disabled','disabled');
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						$("#mktDelButton").html('<i class="fa fa-check-circle"></i> Deleted');
						$("#delMktMsg").html(mktName+" "+responseData.message);
					}
					else{
						$("#delMktMsg").html(responseData.message);
						$("#mktDelButton").html('<i class="fa fa-redo"></i> Try Again').removeAttr('disabled');
						$("#mktDelCancelButton").removeAttr('disabled');
					}
				}
			});
		}
		else{
			alert("Invalid Market ID");
		}
	});
	
	//////////Add New Project//////////////
	$("#projectname").on('blur', function(){
		var data = $(this).val();
		if(data){
			$("#projectname").removeClass('is-invalid');
		}
		else{
			$("#projectname").addClass('is-invalid');
		}
	});
	$("#projectinitial").on('blur', function(){
		var data = $(this).val();
		if(data){
			$("#projectinitial").removeClass('is-invalid');
		}
		else{
			$("#projectinitial").addClass('is-invalid');
		}
	});
	$("#projectdescription").on('blur', function(){
		var data = $(this).val();
		if(data){
			$("#projectdescription").removeClass('is-invalid');
		}
		else{
			$("#projectdescription").addClass('is-invalid');
		}
	});
	$("#addProject").on('click', function(){
		var formdata = new FormData();
		
		var projectname = $("#projectname").val();
		if(projectname===''){
			$("#projectname").addClass('is-invalid');
		}
		else{
			$("#projectname").removeClass('is-invalid');
			formdata.append('projectname',projectname);
		}
		var projectinitial = $("#projectinitial").val();
		if(projectinitial===''){
			$("#projectinitial").addClass('is-invalid');
		}
		else{
			$("#projectinitial").removeClass('is-invalid');
			formdata.append('projectinitial',projectinitial);
		}
		var projectdescription = $("#projectdescription").val();
		if(projectdescription===''){
			$("#projectdescription").addClass('is-invalid');
		}
		else{
			$("#projectdescription").removeClass('is-invalid');
			formdata.append('projectdescription',projectdescription);
		}
		
		if(projectname && projectdescription){
			formdata.append('action', 'add-project');
			$.ajax({
                type: 'POST',
                url:'resources/scripts/enumeration/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#msgBox").html('Please, wait...<i class="fas fa-spinner fa-spin"></i> We are adding Project.').addClass('text-info').removeClass('text-danger');
				},
                success:function(responseData){
					if(responseData.header==='successful'){
						$("#msgBox").html('<i class="fas fa-check"></i> Project successfully submitted.').addClass('text-success').removeClass('text-info');
						$("#projectname").val('');
						$("#projectdescription").html('');
					}
					else{
						$("#msgBox").html('<i class="fas fa-times-circle"></i> '+responseData.message).addClass('text-danger').removeClass('text-info');
					}
                }
            });
		}
		else{
			$("#msgBox").html('<i class="fas fa-times-circle"></i> Please, fill the form properly').addClass('text-danger');
		}
	});

	////////////ADD AGENT SCRIPT////////////////////
	$("#firstname").on('blur', function(){
		const data = $(this).val();
		if(data){
			$("#firstname").removeClass('is-invalid');
		}
		else{
			$("#firstname").addClass('is-invalid');
		}
	});
	$("#lastname").on('blur', function(){
		const data = $(this).val();
		if(data){
			$("#lastname").removeClass('is-invalid');
		}
		else{
			$("#lastname").addClass('is-invalid');
		}
	});
	$("#email").on('blur', function(){
		const data = $(this).val();
		if(data){
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(data))){
				$("#email").addClass('is-invalid');
			}
			else{
				$("#email").removeClass('is-invalid');
			}
		}
		else{
			$("#email").addClass('is-invalid');
		}
	});
	$("#phone").on('blur', function(){
		const data = $(this).val();
		if(data){
			if(isValidPhoneNumber(data)){
				$("#phone").removeClass('is-invalid');
			}
			else{
				$("#phone").addClass('is-invalid');
			}
		}
		else{
			$("#phone").addClass('is-invalid');
		}
	});
	
	$("#address").on('blur', function(){
		const data = $(this).val();
		if(data){
			$("#address").removeClass('is-invalid');
		}
		else{
			$("#address").addClass('is-invalid');
		}
	});
	
	$("#project").on('change', function(){
		const data = $(this).val();
		if(data){
			$("#project").removeClass('is-invalid');
		}
		else{
			$("#project").addClass('is-invalid');
		}
	});
	
	$("#addAgent").on('click', function(){
		var formdata = new FormData();
		
		var lastname = $("#lastname").val();
		if(lastname===''){
			$("#lastname").addClass('is-invalid');
		}
		else{
			$("#lastname").removeClass('is-invalid');
			formdata.append('lastname',lastname);
		}
		var firstname = $("#firstname").val();
		if(firstname===''){
			$("#firstname").addClass('is-invalid');
		}
		else{
			$("#firstname").removeClass('is-invalid');
			formdata.append('firstname',firstname);
		}
		var middlename = $("#middlename").val();
		if(middlename){
			formdata.append('middlename',middlename);
		}
		
		var email = $("#email").val();
		
		if(email===''){
			$("#email").addClass('is-invalid');
		}
		else{
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
				$("#email").addClass('is-invalid');
				var errorMsg = 'Invalid Email';
			}
			else{
				$("#email").removeClass('is-invalid');
				formdata.append('email',email);
			}
		}
		var phone = $("#phone").val();
		if(phone===''){
			$("#phone").addClass('is-invalid');
		}
		else{
			if(isValidPhoneNumber(phone)){
				$("#phone").removeClass('is-invalid');
				formdata.append('phone',phone);
			}
			else{
				$("#phone").addClass('is-invalid');
			}
		}
		var state = $("#state").val();
		if(state===''){
			$("#state").addClass('is-invalid');
		}
		else{
			$("#state").removeClass('is-invalid');
			formdata.append('state',state);
		}
		var city = $("#city").val();
		if(city===''){
			$("#city").addClass('is-invalid');
		}
		else{
			$("#city").removeClass('is-invalid');
			formdata.append('city',city);
		}
		
		var address = $("#address").val();
		if(address===''){
			$("#address").addClass('is-invalid');
		}
		else{
			$("#address").removeClass('is-invalid');
			formdata.append('address',address);
		}
		var project = $("#project").val();
		if(project===''){
			$("#project").addClass('is-invalid');
		}
		else{
			$("#project").removeClass('is-invalid');
			formdata.append('project',project);
		}
		
		
		if(firstname && lastname && email && phone && address && state && city && !errorMsg){
			formdata.append('action', 'add-user');
			formdata.append('user-type',userType);
			$.ajax({
                type: 'POST',
                url:'resources/scripts/enumeration/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#msgBox").html('Please, wait...<i class="fas fa-spinner fa-spin"></i> We are adding the '+userType).addClass('text-info').removeClass('text-danger');
				},
                success:function(responseData){
					if(responseData.header==='successful'){
						$("#msgBox").html('<i class="fas fa-check"></i> '+userType+' successfully added.').addClass('text-success').removeClass('text-info');
						$("#enumerationForm").reset();
					}
					else{
						$("#msgBox").html('<i class="fas fa-times-circle"></i> '+responseData.message).addClass('text-danger').removeClass('text-info');
					}
                }
            });
		}
		else{
			$("#msgBox").html('<i class="fas fa-times-circle"></i> Please, fill all fields properly').addClass('text-danger');
		}
	});
	
	////load all the agents
	/* function loadUsers(){
		$.ajax({
			type: 'POST',
			url:'resources/scripts/enumeration/scripts.php',
			data: 'action=load-users&user-type='+usertype,
			dataType: 'JSON',
			beforeSend: function(){
				$("#loadUsers").html('<h4 class="text-center">Please, wait...<i class="fas fa-spinner fa-spin"></i></h4>');
			},
			success:function(responseData){
				alert(responseData.message);
				$("#loadUsers").html(responseData.message);
			}
		});
	}
	
	if(usertype){
		loadUsers();
	} */
	
	
});