$(document).ready(function(){
	
	$("#signinBtn").on('click', function(){
		var username = $("#username").val();
		var pass = $("#password").val();
		
		if(username==''){
			$("#username").addClass('is-invalid');
		}
		else{
			$("#username").removeClass('is-invalid');
		}
		
		if(pass==''){
			$("#password").addClass('is-invalid');
		}
		else{
			$("#password").removeClass('is-invalid');
		}
		
		if(username && pass){
			$("#loginMsg").html('<h5 class="text-info"><br><i class="fas fa-spinner fa-spin"></i>...Loading</h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=login&username='+username+'&password='+pass,
				success:function(loginRet){
					if(loginRet=='invalid login'){
						$("#loginMsg").html('<h5 class="text-danger"><br><i class="fas fa-times"></i> Invalid username/password</h5>');
					}
					else if(loginRet=='first login'){
						$("#loginMsg").html('<h5 class="text-success"><br><i class="fas fa-spinner fa-spin"></i>...Loading dashboard for first time</h5>');
						setTimeout(function(){
							window.location = './';
						},4000);
					}
					else if(loginRet=='successful'){
						$("#loginMsg").html('<h5 class="text-success"><br><i class="fas fa-spinner fa-spin"></i>...Loading dashboard</h5>');
						setTimeout(function(){
							window.location = './';
						},4000);
					}
                    else{
						$("#loginMsg").html('<h5 class="text-danger"><br><i class="fas fa-times"></i> '+loginRet+'</h5>');
					}
				}
			});
		}
	});

    //////recover password/////
	$("#recoverPassword").on('click', function(){
		var email = $("#email").val();
		
		if(email==''){
			$("#email").addClass('is-invalid');
		}
		else{
			$("#email").removeClass('is-invalid');
		}
		
		if(email){
			$("#msg").html('<h5 class="text-info">Sending code...<i class="fas fa-spinner fa-spin"></i></h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=recover-password&email='+email,
				success:function(loginRet){
					if(loginRet=='successful'){
						$("#msg").html('<h5 class="text-success"><i class="fas fa-check-circle"></i> Verification Code Sent</h5>');
                        setTimeout(function(){
							window.location = './';
						},4000);
					}
					else{
						$("#msg").html('<h5 class="text-danger"><i class="fas fa-times-circle"></i> Invalid email address</h5>');
					}
				}
			});
		}
	});

    //////Verify Code/////
	$("#verifyCode").on('click', function(){
		var code = $("#code").val();
		
		if(code==''){
			$("#code").addClass('is-invalid');
		}
		else{
			$("#code").removeClass('is-invalid');
		}
		
		if(code){
			$("#msgV").html('<h5 class="text-info">Verifying code...<i class="fas fa-spinner fa-spin"></i></h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=verify-code&code='+code,
				success:function(loginRet){
					if(loginRet=='successful'){
						$("#msgV").html('<h5 class="text-success"><i class="fas fa-check-circle"></i> Verification Successful</h5>');
                        setTimeout(function(){
							window.location = './';
						},4000);
					}
					else{
						$("#msgV").html('<h5 class="text-danger"><i class="fas fa-times-circle"></i> Invalid Code</h5>');
					}
				}
			});
		}
	});

    //////Update Password/////
	$("#updatePassword").on('click', function(){
		var password = $("#password").val();
		var confirm = $("#confirm").val();
        var errorMsg = '';
		
		if(password==''){
			$("#password").addClass('is-invalid');
            errorMsg += 'Password is required'
		}
		else{
			$("#password").removeClass('is-invalid');
		}

		if(confirm==''){
			$("#confirm").addClass('is-invalid');
            if(errorMsg){
                errorMsg += '<br>Confirm Password required';
            }
            else{
                errorMsg += 'Confirm Password required';
            }
		}
		else{
            if(password==confirm){
                $("#confirm").removeClass('is-invalid');
            }
            else{
                $("#confirm").addClass('is-invalid');
                if(errorMsg){
                    errorMsg += '<br>Passwords do not match';
                }
                else{
                    errorMsg += 'Passwords do not match';
                }
            }
		}
		
		if(password && confirm && password==confirm){
			$("#msgUpdate").html('<h5 class="text-info">Updating Password...<i class="fas fa-spinner fa-spin"></i></h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=update-password&password='+password,
				success:function(loginRet){
					if(loginRet=='successful'){
						$("#msgUpdate").html('<h5 class="text-success"><i class="fas fa-check-circle"></i> Password Updated. Wait while we redirect you...<i class="fa fa-spinner fa-spin"></i></h5>');
                        setTimeout(function(){
							window.location = './';
						},4000);
					}
					else{
						$("#msgUpdate").html('<h5 class="text-danger"><i class="fas fa-times-circle"></i> '+loginRet+'</h5>');
					}
				}
			});
		}
        else{
            errorMsg = '<span class="text-danger">'+errorMsg+'</span>';
            $("#msgUpdate").html(errorMsg);
        }
	});
});