<?php
	//phpinfo();
	
	$to = 'ajah.j@smartclouds.com.ng';
	$subject = 'Multiple Image Attachments';
	$from = 'SALTCCIMA <info@saltccima.com>';
	$reply_to = 'no-reply@office.saltccima.com';
	$htmlBodyMain = '<p>This is the Mail body I just created</p>';

	$htmlBody = $htmlBodyMain; // Or use another variable if preferred

	$boundary = md5(time());

	// Set headers
	$headers = "From: $from\r\n";
	$headers .= "Reply-To: $reply_to\r\n";
	$headers .= "MIME-Version: 1.0\r\n";
	$headers .= "Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n";

	// Email body start (HTML part)
	$message = "--$boundary\r\n";
	$message .= "Content-Type: image/jpeg\r\n";
	$message .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
	$message .= "$htmlBody\r\n\r\n";

	// Attach Image Files
	$imageFiles = array(
		'assets/output/110001.jpg',
		'assets/output/110002.jpg',
		'assets/output/110003.jpg'
	);

	foreach ($imageFiles as $imageFile) {
		if (file_exists($imageFile)) {
			$fileContent = file_get_contents($imageFile);
			$fileContent = chunk_split(base64_encode($fileContent));
			$fileName = basename($imageFile);
			
			$message .= "--$boundary\r\n";
			$message .= "Content-Type: image/jpeg\r\n";
			$message .= "Content-Disposition: attachment; filename=\"$fileName\"\r\n";
			$message .= "Content-Transfer-Encoding: base64\r\n\r\n";
			$message .= $fileContent . "\r\n\r\n";
		} else {
			error_log("File not found: $imageFile");
		}
	}

	// End boundary
	$message .= "--$boundary--";

	// Send the email
	$mailSent = mail($to, $subject, $message, $headers);

	if ($mailSent) {
		echo "Email sent successfully with image attachments.";
	} else {
		echo "Failed to send email.";
	}