﻿<?php
    $websiteDescription = 'Welcome to the forefront of sustainable investment opportunities! At our platform, we empower individuals to contribute to a greener future while maximizing their financial potential. With a range of innovative investment plans, cutting-edge technology, and a commitment to environmental responsibility, we offer investors the chance to plug into profitable solutions. Join us in driving change, fueling progress, and electrifying your portfolio for a brighter tomorrow!';
    $keywords = 'Electric Vehicles, EV, electric vehicle charging station, charging station, car charger, investment opportunity, Sustainable investment,Electric vehicle charging investment,Green energy investment,Renewable energy investment,Clean energy investment,Profitable sustainability,Environmental investing,Eco-friendly investment,Sustainable finance,Green technology investment,Electric vehicle infrastructure investment,Clean energy solutions,Renewable energy projects,Sustainable portfolio management,Climate-conscious investing';
?>
<?php include('mainpage/header.php'); ?>

<!-- banner top begin -->
<section class="banner-section">
    <div class="overlay" style="background-image: url(img/banner.jpg)">
        <div class="container">
            <div class="total-slide">
                <div class="row text-center">
                    <div class="col-lg-12">
                        <div class="banner-text">
                            <h1 class="font-light">Welcome to </h1>
                            <h1 class="font-bold"><?php echo $appName; ?></h1>
                            <h2 class="font-regular" style="color: white; font-size: 45px;">Powering the Future</h2>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <h3 class="banner-bottom-text">Invest in Tomorrow's Technology Today</h3>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <div class="get-start">
                            <a  href="javascript:void();" onclick="location.href='./?action=register'">GET STARTED NOW!</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
    </div>
</section>
<!-- banner top end -->

<!-- calculator top begin -->
<section class="calculate-aria">
    <div class="container-fluid">
    <h1 style="padding-top: 10px;color: white;" class="text-center font-bold">Investment Calculator</h1>
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <div class="calculate-left">
                    <div class="row">
                        <div class="col-lg-2 col-md-2 col-sm-2">
                            <div class="icon-box">
                                <i class="ren-calculator"></i>
                            </div>
                        </div>
                        <div class="col-lg-10 col-md-10 col-sm-10">
                            <div class="form-group">
                                <h2 class="amount">Select Plan to view Stats</h2>
                                <div class="input-dropdown">
                                    <div class="form-dropdown col-md-12 col-lg-12 col-sm-12">
                                        <select class="form-btn-dropdown calculator-profit" id="investmentSelect">
                                            <?php
												$planDetails = '';
												$query = mysqli_query($db_conn, "SELECT * FROM tbl_plans ORDER BY amount ASC");
												if(mysqli_num_rows($query)>0){
													$planDetails = '<option value="">Select Plan</option>';
													while($plan=mysqli_fetch_assoc($query)){
														$planDetails .= '<option value="'.$plan['plan_code'].'">$'.numberFormat($plan['amount']).' - '.$plan['plan_name'].' ('.$plan['percent_roi'].'% Daily for '.$plan['investment_days'].' days) - '.$plan['full_roi'].'%</option>';
													}
												}
												else{
													$planDetails = '<option value="">No available plans now</option>';
												}
												echo $planDetails;
											?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                $(document).ready(function(){
					$("#investmentSelect").on('change', function(){
						let planCode = $("#investmentSelect").val();
						//alert(planCode);
						if(planCode){
							$.ajax({
								type: 'POST',
								url:'scripts/home.php',
								data:'action=load-stats&planCode='+planCode,
								success:function(response){
									//alert(response);
									$("#investmentCounters").html(response);
								}
							});
						}
						else{
							$("#investmentCounters").html('');
						}
					})
                    
                });
            </script>
            <div class="col-lg-10 col-md-10 text-center">
                <div class="calculate-right">
                    <div class="row justify-content-end" id="investmentCounters">
                        <div class="col-lg-3 col-md-3 col-sm-3">
							<div class="text-box">
								<span class="counter calculator-result-daily">0</span>
								<h4>Daily ROI</h4>
							</div>
						</div>
						<div class="col-lg-3 col-md-3 col-sm-3">
							<div class="text-box">
								<span class="counter calculator-result-weekly">0</span>
								<h4>Weekly ROI</h4>
							</div>
						</div>
						<div class="col-lg-3 col-md-3 col-sm-3">
							<div class="text-box">
								<span class="counter calculator-result-monthly">0</span>
								<h4>Monthly ROI</h4>
							</div>
						</div>
						<div class="col-lg-3 col-md-3 col-sm-3">
							<div class="text-box">
								<span class="counter calculator-result-monthly">0</span>
								<h4>Cummulative ROI</h4>
							</div>
						</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- calculator top end -->

<!-- about section begin -->
<section class="about-section navigation" id="about-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <div class="about-left">
                    <div class="about-text">
                        <h5 class="about-title">About</h5>
                        <h2 class="about-subtitle">ElkCharge</h2>
                        <h5 class="about-details">To meet <span>today's challenges</span>, we've created a unique fund management system</h5>
                        <p class="about-description">At ElkCharge, we're revolutionizing the way the world powers its vehicles. As the demand for electric vehicles (EVs) 
                            continues to surge, the need for accessible and efficient charging infrastructure becomes paramount. That's where we come in.</p>
                    </div>

                    <div class="about-box">
                        <div class="row text-center">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <div class="single-about-box">
                                    <div class="icon-box-outer bg-eff">
                                        <div class="icon-box">
                                            <i class="ren-efficiency"></i>
                                        </div>
                                    </div>
                                    <h3>Efficiency</h3>
                                    <div class="hover-box hover-left">
                                        <a href="#">READ MORE<i class="ren-arrowright"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <div class="single-about-box">
                                    <div class="icon-box-outer bg-ex">
                                        <div class="icon-box">
                                            <img src="img/expierence.svg" alt="#">
                                        </div>
                                    </div>
                                    <h3>Expierence</h3>
                                    <div class="hover-box hover-top">
                                        <a href="#">READ MORE<i class="ren-arrowright"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <div class="single-about-box">
                                    <div class="icon-box-outer bg-security">
                                        <div class="icon-box">
                                            <i class="ren-security"></i>
                                        </div>
                                    </div>
                                    <h3>Security</h3>
                                    <div class="hover-box hover-right">
                                        <a href="#">READ MORE<i class="ren-arrowright"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row text-center">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <div class="single-about-box">
                                    <div class="icon-box-outer bg-trans">
                                        <div class="icon-box">
                                            <i class="ren-transparent"></i>
                                        </div>
                                    </div>
                                    <h3>Transparent</h3>
                                    <div class="hover-box hover-left">
                                        <a href="#">READ MORE<i class="ren-arrowright"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <div class="single-about-box">
                                    <div class="icon-box-outer bg-simple">
                                        <div class="icon-box">
                                            <i class="ren-simple"></i>
                                        </div>
                                    </div>
                                    <h3>Simple</h3>
                                    <div class="hover-box hover-bottom">
                                        <a href="#">READ MORE<i class="ren-arrowright"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <div class="single-about-box">
                                    <div class="icon-box-outer bg-com">
                                        <div class="icon-box">
                                            <i class="ren-compliant"></i>
                                        </div>
                                    </div>
                                    <h3>Compliant</h3>
                                    <div class="hover-box hover-right">
                                        <a href="#">READ MORE<i class="ren-arrowright"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="about-right">
                    <div class="video-box">
                        <img src="img/bg-image.gif" alt="#">
                        <div class="icon-box">
                            <a href="https://www.youtube.com/watch?v=jvrayw6wANg" class="video-play-btn popup-video"><i class="ren-playicon"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- about section end -->

<!-- choose section begin -->
<section class="choose-section">
    <div class="overlay">
        <div class="container-fruit text-center">
            <div class="row mr-0 ml-0 d-flex justify-content-center">
                <div class="col-xl-8 col-lg-12">
                    <div class="choose-text">
                        <h5 class="choose-title">Boost Your Investment</h5>
                        <h2 class="choose-subtitle">Why ElkCharge?</h2>
                        <p class="choose-title-describe">Discover <b>ElkCharge</b>: where sustainable investment meets cutting-edge technology, empowering you to shape the future of clean energy transportation while maximizing financial returns.</p>
                    </div>
                </div>
            </div>

            <div class="choose-section-carousel">

                <div class="col">
                    <div class="single-item">
                        <div class="icon-box">
                            <img src="img/daily-income.svg" alt="#">
                        </div>
                        <div class="text-box">
                            <h2 class="single-item-title">Daily ROI</h2>
                            <h3 class="single-item-description">Earn daily returns on your investment with ElkCharge's investment plans.</h3>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="single-item">
                        <div class="icon-box">
                            <img src="img/withdraw1.svg" alt="#">
                        </div>
                        <div class="text-box">
                            <h2 class="single-item-title">FAST PAYOUTS</h2>
                            <h3 class="single-item-description">Get your returns swiftly with ElkCharge's lightning-fast payout system.</h3>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="single-item">
                        <div class="icon-box">
                            <img src="img/invest-fild.svg" alt="#">
                        </div>
                        <div class="text-box">
                            <h2 class="single-item-title">Easy to Use</h2>
                            <h3 class="single-item-description">Navigate our user-friendly platform effortlessly for a seamless experience.</h3>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="single-item">
                        <div class="icon-box">
                            <img src="img/security.svg" alt="#">
                        </div>
                        <div class="text-box">
                            <h2 class="single-item-title">HIGHLY SECURE</h2>
                            <h3 class="single-item-description">Relax knowing that your investments are protected by robust security measures.</h3>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="single-item">
                        <div class="icon-box">
                            <img src="img/customer-service.svg" alt="#">
                        </div>
                        <div class="text-box">
                            <h2 class="single-item-title">24/7 Support</h2>
                            <h3 class="single-item-description">Access expert assistance anytime, anywhere with our customer support team.</h3>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>
<!-- choose section end -->

<!-- invest section begin -->
<section class="invest-section">
    <div class="overlay">
        <div class="container">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="invest-text">
                        <h5 class="invest-title">Learn How</h5>
                        <h2 class="invest-subtitle">ElkCharge Works</h2>
                        <p class="invest-title-describe">Investors can choose to allocate funds towards virtual charging piles, which are then deployed across our extensive network. These virtual charging piles represent a stake in the burgeoning EV charging market, allowing investors to capitalize on the exponential growth of electric vehicles.</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-4 text-center reunir-content-center">
                    <div class="single-box location-left">
                        <div class="img-box">
                            <div class="font-side">
                                <img src="img/sign-up.svg" alt="#">
                            </div>
                            <div class="back-side">
                                <img src="img/sign-up.svg" alt="#">
                            </div>
                        </div>
                        <div class="text-box">
                            <a href="#">STEP 1<i class="ren-arrowright"></i></a>
                            <h3>Create Account</h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-4 text-center reunir-content-center">
                    <div class="single-box">
                        <div class="img-box">
                            <div class="font-side">
                                <img src="img/deposit.svg" alt="#">
                            </div>
                            <div class="back-side">
                                <img src="img/deposit.svg" alt="#">
                            </div>
                        </div>
                        <div class="text-box">
                            <a href="#">STEP 2<i class="ren-arrowright"></i></a>
                            <h3>Make a Deposit</h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-4 text-center reunir-content-center">
                    <div class="single-box location-right">
                        <div class="img-box">
                            <div class="font-side">
                                <img src="img/withdraw-1.svg" alt="#">
                            </div>
                            <div class="back-side">
                                <img src="img/withdraw-1.svg" alt="#">
                            </div>
                        </div>
                        <div class="text-box">
                            <a href="#">STEP 3<i class="ren-arrowright"></i></a>
                            <h3>Withdraw ROI</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- invest section end -->

<!-- advantage section begin -->
<section class="advantage-section">
    <div class="overlay">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <div class="advantage-text">
                        <h5 class="advantage-title">Our Profound Industry</h5>
                        <h2 class="advantage-subtitle">Advantage</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-4 text-center">
                    <div class="single-box">
                        <div class="icon-box">
                            <i class="ren-team"></i>
                        </div>
                        <div class="text-box">
                            <h2>PROFESSIONAL TEAM</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-4 text-center">
                    <div class="single-box">
                        <div class="icon-box">
                            <i class="ren-profitable-plan"></i>
                        </div>
                        <div class="text-box">
                            <h2>PROFITABLE PLANS</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-4 text-center">
                    <div class="single-box">
                        <div class="icon-box">
                            <i class="ren-control-panel"></i>
                        </div>
                        <div class="text-box">
                            <h2>Secure Control Panel</h2>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>
<!-- advantage section end -->

<!-- investment section begin -->
<section class="investment-section" id="investment-section">
    <div class="overlay">
        <div class="container-fluid text-center">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="investment-text">
                        <h5 class="investment-title">Our Highly Competitive</h5>
                        <h2 class="investment-subtitle">Investment Plans</h2>
                        <p class="investment-title-describe">Through our innovative investment model, investors can earn a remarkable 1.5-7% daily return on their investment for a period of 90 days, 
                            depending on the amount they've invested. This means that your money works for you, generating passive income while contributing to a sustainable future.</p>
                    </div>
                </div>
            </div>
			<script>
				$(document).ready(function(){
					$.ajax({
						type:'POST',
						url:'scripts/home.php',
						data:'action=load-plans',
						success:function(responseData){
							$("#InvestmentPanel").html(responseData);
						}
					});
				});
			</script>
            <div class="row">
                <div class="col-lg-12">
                    <div class="investment-section-carousel">
                        <?php
							$planDetails = '';
							$queryPlans = mysqli_query($db_conn, "SELECT * FROM tbl_plans ORDER BY amount ASC");
							while($plan=mysqli_fetch_assoc($queryPlans)){
								$fullRoi = numberFormat(($plan['full_roi']/100) * $plan['amount']);
								
								$planDetails .= '<div class="col text-center">
									<div class="single-item">
										<div class="single-image">
											<img src="img/plans/'.$plan['banner'].'" alt="#">
										</div>
										
										<div class="part-prize">
											<br><h4><b>'.strtoupper($plan['plan_name']).'</b></h4>
											<span class="percentage"><b>'.$plan['percent_roi'].'</b>%</span>
											<h3>Daily For '.$plan['investment_days'].' Days</h3>
											<h4 class="min-max">
												<span class="left">Amount: <b>$'.$plan['amount'].'</b></span>
												<span class="right">ROI: <b>$'.$fullRoi.'</b></span>
												<br><br><span class="right">Cummulative: <b>'.$plan['full_roi'].'%</b></span>
											</h4>
										</div>
										<div class="part-cart">
											<a href="./?action=register&selected='.$plan['plan_code'].'">Purchase Plan</a>
										</div>
									</div>
								</div>';
							}
							
							echo $planDetails;
						?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- investment section end -->

<!-- affiliate section begin -->
<section class="affiliate-section" id="affiliate-section">
    <div class="overlay">
        <div class="container-fluid">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="affiliate-text">
                        <h5 class="affiliate-title">Empowering Growth Together</h5>
                        <h2 class="affiliate-subtitle">The ElkCharge Referral Program</h2>
                        <p class="affiliate-title-describe">
							At <b>ElkCharge</b>, we believe in the power of collaboration and community. That's why we're thrilled to introduce our 
							three-level deep referral program, designed to reward our investors for sharing the benefits of <b>ElkCharge</b> with others. 
							With generous incentives at every level, our referral program is a win-win opportunity for all.
						</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- affiliate section end -->

<!-- referral section begin -->
<section class="referral-section">
    <div class="container-fluid">
        <div class="row referral-section-item">
            <div class="col-lg-2 col-md-2 col-sm-2">
                <div class="referral-img">
                    <img src="img/referral-img.png" alt="#">
                </div>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10">
                <div class="referral-section-right">
                    <div class="referral-text">
                        <h5 class="referral-title">Referral commission and</h5>
                        <h2 class="referral-subtitle">How it Works</h2>
                        <p class="referral-title-describe">Refferal Commmission and Membership Levels are of 3 levels as below</p>
                    </div>
                    <div class="row">
                        <div class="col-lg-11 col-sm-12">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                    <div class="referral-single-item">
                                        <div class="icon-box">
                                            <i class="ren-people1"></i>
                                        </div>
                                        <div class="text-box">
                                            <span class="percentage">8%</span>
                                            <h4 class="item-text">1st Generation</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                    <div class="referral-single-item">
                                        <div class="icon-box">
                                            <i class="ren-people2 bg-second"></i>
                                        </div>
                                        <div class="text-box">
                                            <span class="percentage">4%</span>
                                            <h4 class="item-text">Second Generation</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                    <div class="referral-single-item">
                                        <div class="icon-box">
                                            <i class="ren-people3 bg-third"></i>
                                        </div>
                                        <div class="text-box">
                                            <span class="percentage">2%</span>
                                            <h4 class="item-text">Third Generation</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					<div class="row">
						<div class="col-lg-12 text-center">
							<div class="cart-btn">
								<a href="javascript:void();" onclick="location.href='./?action=register';">I want to Join</a>
							</div>
						</div>
					</div>
                </div>
            </div>
			
        </div>
		
    </div>
</section>
<!-- referral section end -->

<!-- deposit section begin -->
<section class="deposit-section">
    <div class="container">
        <div class="row d-flex justify-content-center">
            <div class="col-lg-8 text-center">
                <div class="deposit-text">
                    <h5 class="deposit-title">Convenient Funds</h5>
                    <h2 class="deposit-subtitle">Deposit & Withdrawal</h2>
                    <p class="deposit-title-describe">
						At ElkCharge, we understand the importance of timely access to your earnings. That's why we've developed a withdrawal 
						policy that prioritizes convenience and reliability, ensuring that you can effortlessly access your profits throughout 
						your investment journey.
					</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6 col-md-5 col-sm-12 reunir-content-center">
                <div class="row d-flex justify-content-start">
                    <div class="col-lg-8">
                        <div class="payment-methods-outer">
                            <div class="payment-methods">
                                <div class="icon-gallery">
                                    <div class="icon-box">
                                        <div class="icon-img">
                                            <img src="img/card-icon.png" alt="#">
                                        </div>
                                        <h5 class="icon-title">Credit Card</h5>
                                    </div>
                                    <div class="icon-box">
                                        <div class="icon-img">
                                            <img src="img/paypal.png" alt="#">
                                        </div>
                                        <h5 class="icon-title">Paypal</h5>
                                    </div>
                                    <div class="icon-box">
                                        <div class="icon-img">
                                            <img src="img/bitcoin.png" alt="#">
                                        </div>
                                        <h5 class="icon-title">Bitcoin</h5>
                                    </div>
                                </div>
                                <div class="icon-gallery">
                                    <div class="icon-box">
                                        <div class="icon-img">
                                            <img src="img/litecoin.png" alt="#">
                                        </div>
                                        <h5 class="icon-title">Litecoin</h5>
                                    </div>
                                    <div class="icon-box">
                                        <div class="icon-img">
                                            <img src="img/ethereum.png" alt="#">
                                        </div>
                                        <h5 class="icon-title">Ethereum</h5>
                                    </div>
                                    <div class="icon-box">
                                        <div class="icon-img">
                                            <img src="img/ripple.png" alt="#">
                                        </div>
                                        <h5 class="icon-title">Ripple</h5>
                                    </div>
                                </div>
                                <div class="link-box">
                                    <a href="#">And More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-7 col-sm-12 mt-4">
                <div class="deposit-section-right">
                    <div class="icon-box-outer">
                        <div class="icon-box">
                            <i class="ren-withdraw2"></i>
                        </div>
                    </div>
                    <div class="icon-text">
                        <h2 class="icon-title">No Limit</h2>
                        <p class="icon-title-describe">Unlimited maximum withdrawal amount</p>
                    </div>
                </div>
                <div class="deposit-section-right">
                    <div class="icon-box-outer">
                        <div class="icon-box icon-box-orange">
                            <i class="ren-deposit5"></i>
                        </div>
                    </div>
                    <div class="icon-text">
                        <h2 class="icon-title">Withdrawal in 24/7</h2>
                        <p class="icon-title-describe">Deposit – instantaneous</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- deposit section end -->

<!-- signup section begin -->
<section class="signup-section">
    <div class="overlay">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-8">
                    <div class="signup-text">
                        <h5 class="signup-title">CREATE YOUR PERSONAL ACCOUNT</h5>
                        <h2 class="signup-subtitle">Get Started Now</h2>
                        <p class="signup-title-describe">Get Started Now,Create your personal account as a first step to become a sucessfull investor. Are you ready to start earning with us?</p>
                    </div>
                </div>
                <div class="col-lg-6 col-md-4 d-flex justify-content-end align-items-center reunir-content-center">
                    <div class="signup-right-text">
                        <a href="javascript:void();" onclick="location.href='./?action=register'">Signup Now<i class="ren-arrowright"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- signup section end -->

<!-- contact-us section begin -->
<section class="contact-us-section" id="contact-us-section">
    <div class="container">
        <div class="row d-flex justify-content-center">
            <div class="col-lg-8 text-center">
                <div class="contact-us-text">
                    <h5 class="contact-us-title">Contact Us</h5>
                    <h2 class="contact-us-subtitle">Get in Touch</h2>
                    <p class="contact-us-title-describe">
						Please feel free to contact us through our support center. Simply choose the appropriate support options to 
						send us your questions, concerns and/or feedback.Our customer service team is ready to attend to any issues that might occur.
					</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <div class="contact-img">
                    <img src="img/contact-us.jpg" alt="#">
                </div>
            </div>
            <div class="col-lg-5">
                <div class="contact-form">
                    <form id="contactForm" method="post" class="contact-form-aqua">
                        <h2 class="contact-head">Send Us a Massage</h2>
                        <input type="text" id="name" required="" placeholder="Name *" class="contact-frm active">
                        <input type="email" id="email" required="" placeholder="Email *" class="contact-frm">
                        <textarea id="message" id="message" placeholder="Your Message *" class="contact-msg"></textarea>
                        <input id="form-submit" type="button" value="SUBMIT NOW" class="contact-btn">
                        <br>
                        <br>
                        <span class="msgSubmit"></span>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- contact-us section end -->
<?php include('mainpage/footer.php'); ?>