(function ($) {

    "use strict";


    /*---------------------------
     MICHIMP INTEGRATION
    -----------------------------*/
    $('#mc-form').ajaxChimp({
        url: 'http://facebook.us14.list-manage.com/subscribe/post?u=b2a3f199e321346f8785d48fb&amp;id=6d023c55e5', //Set Your Mailchamp URL
        callback: function (resp) {
            if (resp.result === 'success') {
                $('.subscribe-form input, .subscribe-form button').fadeOut();
            }
        }
    });
    $(window).on("load", function () {
        $('.preloader').fadeOut(500);
    });

	
	$("#joinList").on('click', function(){
		let name = $("#name").val();
		let email = $("#email").val();
		let phone = $("#phone").val();
		var errorMsg = '';
		
		
		if(!name){
			$("#name").addClass('has-error');
			errorMsg = '<i class="fa fa-times"></i> Enter your full name (First & last names)';
		}
		else{
			var fullName = name.split(' ');
			if(fullName.length > 1){
				$("#name").removeClass('has-error');
				var firstName = fullName[0];
				var lastName = fullName[1];
				var middleName = fullName[2];
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> First name and Last name required';
				$("#name").addClass('has-error')
			}
		}
		
		if(!email){
			$("#email").addClass('has-error')
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Email required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Email required';
			}
		}
		else{
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
				if(errorMsg){
					errorMsg += '<br><i class="fa fa-times"></i> Invalid Email';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Invalid Email';
				}
				$("#email").addClass('has-error')
			}
			else{
				$("#email").removeClass('has-error');
			}
		}
		
		if(!phone){
			$("#phone").addClass('has-error');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Phone required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Phone required';
			}
		}
		else{
			$("#phone").removeClass('has-error');
		}
		
		
		if(!errorMsg){
			$.ajax({
				type: 'POST',
				url: 'script.php',
				data: 'action=join-wait-list&phone='+phone+'&email='+email+'&firstname='+firstName+'&lastname='+lastName+'&middlename='+middleName,
				dataType: 'JSON',
				beforeSend:function(){
					$("#errorMsg").removeAttr('style').html('<br><i class="fa fa-spinner fa-spin"></i>...please wait.').attr('style','color: blue;');
				},
				success:function(response){
					//alert(response);
					if(response.header=='successful'){
						$("#errorMsg").removeAttr('style').html('<br>You have joined the wait list. We will notify you immediately we go live. Do not submit your details again.').attr('style','color: while;');
					}
					else{
						$("#errorMsg").removeAttr('style').html(response.message).attr('style','color: red;');
					}
				}
			});
		}
		else{
			$("#errorMsg").removeAttr('style').html('<br>'+errorMsg).attr('style','color: red;');
		}
	});
			



})(jQuery);