<?php
    $dir = './';
    $title = 'Sales List';
    $page = 'Sales';
    $salesMenu = 'active';
    $salesMenuState = 'menu-open';
    $salesListMenu = 'active';
?>
<?php include($dir.'pages/universal/header.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
  <div id="systemNotification"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $title; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#"><?php echo $page; ?></a></li>
              <li class="breadcrumb-item active"><?php echo $title; ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <?php
    $queryPayments = mysqli_query($db_conn, "SELECT * FROM tbl_payments WHERE channel!='Crypto' ORDER BY id DESC");
?>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <button class="btn btn-info float-right" data-toggle="modal" data-target="#approveAll" data-id="Bank Transfer"><i class="fa fa-thumbs-up"></i> Approve All</button>  
            <button class="btn btn-success" data-toggle="modal" data-target="#addPayment"><i class="fa fa-plus"></i> Add Payment</button><br /><br />
            <div class="card card-info">
              <div class="card-header">
                <h3 class="card-title">Payments (<?php echo mysqli_num_rows($queryPayments); ?>)</h3>
              </div>
              
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th>Payer</th>
                        <th>Amount</th>
                        <th>Email</th>
                        <th>Channel</th>
                        <th>Date</th>
                        <th></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                        $number = 1;
                        $totalAmount = 0;
                        while($payments=mysqli_fetch_assoc($queryPayments)){
                    ?>
                    <tr>
                        <td><?php echo $number; ?></td>
                        <td><?php echo ucwords(strtolower($payments['last_name'].' '.$payments['first_name'])); ?></td>
                        <td><?php echo numberFormat($payments['amount']); ?></td>
                        <td><?php echo $payments['email']; ?></td>
                        <td><?php echo $payments['channel']; ?></td>
                        <td><?php echo timeCheck($payments['date_paid']); ?></td>
                        <td>
                            <?php if($payments['channel']!='Paystack' && $payments['status']=='Success'){ ?>
                            <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#view-details" data-id="<?php echo $payments['payment_id']; ?>"><i class="fa fa-eye"></i></button>
                            <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#approve" data-id="<?php echo $payments['payment_id']; ?>"><i class="fa fa-check-square"></i> </button>
                            <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#reject" data-id="<?php echo $payments['payment_id']; ?>"><i class="fa fa-times-circle"></i></button>
                            <button class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                            <?php } ?>
                        </td>
                    </tr>
                    <?php $number++; $totalAmount += $payments['amount']; } ?>
                  </tbody>
                  <tfoot>
                    <tr>
                        <th></th>
                        <th></th>
                        <th><?php echo numberFormat($totalAmount); ?></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php include($dir.'pages/universal/footer.php'); ?>