<?php
    $dir = './';
    $title = 'Properties List';
    $page = 'Properties';
    $propertyMenu = 'active';
    $propertyMenuState = 'menu-open';
    $propertyListMenu = 'active';
?>
<?php include($dir.'pages/universal/header.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <div id="systemNotification"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $title; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#"><?php echo $page; ?></a></li>
              <li class="breadcrumb-item active"><?php echo $title; ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12" id="propertyDetails"></div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>

  <script>
    $(document).ready(function(){
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data-1.php',
            data:'action=load-properties',
            dataType: 'JSON',
            beforeSend: function(){
                $("#propertyDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#propertyDetails").html(responseData.body);
            }
        });

      $(document).delegate("[data-target='#view-property']", "click", function() {
        var propId = $(this).attr('data-id');
        //alert(paymentId);

        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data-1.php',
            data:'action=view-property&property-id='+propId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#detailsBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#detailsHeader").html('<b>'+responseData.property_name+'</b>');
                //$("#rejectBody").html(responseDataMain).addClass('text-center');
                $("#detailsBody").html(responseData.property_body);
            }
        });
      });

      $(document).delegate("[data-target='#edit-property']", "click", function() {
        $('#edit-property').on('hide.bs.modal', function(e) {
          e.preventDefault();
        });

        var propId = $(this).attr('data-id');
        var name = $(this).attr('name');
        var title = $(this).attr('title');

        $("#editDetailsHeader").html('<b>'+title+'</b>');
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data-1.php',
            data:'action=edit-property'+name+'&property-id='+propId,
            beforeSend: function(){
                $("#editDetailsBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#editDetailsBody").html(responseData);
            }
        });

        if(name!=''){
          $.ajax({
              type:'POST',
              url:'resources/scripts/property/upload-images.php',
              data:'action=load-images-edit',
              beforeSend:function(){
                  $("#imgPreviewEdit").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
              },
              success:function(uploadResponse){
                  $("#imgPreviewEdit").html(uploadResponse);
              }
          });
        }
      });

      $('#closeEditBtn').on('click', function(){
        $('#edit-property').off("hide.bs.modal").trigger("click");
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data.php',
            data:'action=remove-images-edit',
            success:function(responseData){
                if(responseData=='successful'){
                    location.href='./';
                }
            }
        });
    });
    $('#closeEdit').on('click', function(){
        $('#edit-property').off("hide.bs.modal").trigger("click");
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data.php',
            data:'action=remove-images-edit',
            success:function(responseDataDel){
                if(responseDataDel=='successful'){
                    location.href='./';
                }
            }
        });
    });

      $('#closeAdd').on('click', function(){
        $('#add-property').off("hide.bs.modal").trigger("click");
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data-1.php',
            data:'action=remove-images',
            success:function(responseData){
              if(responseData=='successful'){
                location.href='./';
              }
            }
        });
      });

      $('#closeAddBtn').on('click', function(){
        $('#add-property').off("hide.bs.modal").trigger("click");
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data-1.php',
            data:'action=remove-images',
            success:function(responseData){
              if(responseData=='successful'){
                location.href='./';
              }
            }
        });
      });

      $('.addProperty').on('click', function(){
          $('#add-property').off("hide.bs.modal").trigger("click");
          $.ajax({
              type:'POST',
              url:'resources/scripts/property/data-1.php',
              data:'action=remove-images',
              success:function(responseData){
              if(responseData=='successful'){
                  location.href='./';
              }
              }
          });
      });
      
      $(document).delegate("[data-target='#add-property']", "click", function() {
        $('#add-property').on('hide.bs.modal', function(e) {
          e.preventDefault();
        });
        
        /* $.ajax({
            type:'POST',
            url:'resources/scripts/property/data-1.php',
            data:'action=add-property',
            beforeSend: function(){
                $("#addPropertyDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#addPropertyDetails").html(responseData);
            }
        }); */

        $.ajax({
            type:'POST',
            url:'resources/scripts/property/upload-images.php',
            data:'action=load-images',
            beforeSend:function(){
                $("#imgPreview").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
            },
            success:function(uploadResponse){
                $("#imgPreview").html(uploadResponse);
            }
        });

      });

       ///////load property delete modal confirm box///////////
    $(document).delegate("[data-target=#delete-property]", "click", function() {
        var propId = $(this).attr('data-id');
        var name = $(this).attr('name');
        var title = $(this).attr('title');

        $("#deleteHead").html(title);
        $("#delPropId").html(propId);
        $("#delPropName").html(name);
    }); 


    $(document).delegate("[data-target='#del-property']", "click", function() {
      var propId = $(this).attr('data-id');
        var name = $(this).attr('name');
        var title = $(this).attr('title');

        alert(title);

        $("#delPropHead").html(title);
        $("#delPropId").html(propId);
        $("#delPropName").html(name);

    });

      
    });
  </script>
  <!-- /.content-wrapper -->
  <?php include($dir.'pages/universal/footer.php'); ?>