
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $appName; ?> | Lockscreen</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <script src="<?php echo $dir; ?>jquery.min.js"></script>
  <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script>
  <link rel="shortcut icon" type="image/x-icon" href="<?php echo $dir; ?>../myaccount/images/main-logo.png">
</head>
<body class="hold-transition lockscreen bg-info">
<!-- Automatic element centering -->
<div class="lockscreen-wrapper">
  <!-- User name -->
  <div class="lockscreen-name">Welcome back,</div>
  <div class="lockscreen-name"><h4><b><?php echo $myName; ?></b></h4></div><br>
  <div class="lockscreen-name" id="msg"></div>
  <div class="lockscreen-item">
    <!-- lockscreen image -->
    
    <div class="lockscreen-image">
      <img src="<?php echo $userImage; ?>" alt="<?php echo $myName; ?>">
    </div>
    <!-- /.lockscreen-image -->

    <!-- lockscreen credentials (contains the form) -->
    <form class="lockscreen-credentials">
      <div class="input-group">
        <input type="password" id="password" class="form-control" placeholder="password">

        <div class="input-group-append">
          <button type="button" class="btn" id="lockLoginBtn">
            <i class="fas fa-arrow-right text-muted"></i>
          </button>
        </div>
      </div>
    </form>
    <!-- /.lockscreen credentials -->

  </div>
  <!-- /.lockscreen-item -->
  <div class="help-block text-center">
    Enter your password to retrieve your session
  </div>
  <div class="text-center">
    <a href="login.html" class="text-white">Or</a>
    <br><button class="btn btn-danger" id="logoutBtn"><i class="fa fa-power-off"></i> Logout me Out</button>
  </div>
</div>
<!-- /.center -->
<script>
    $(document).ready(function(){
        $("#lockLoginBtn").on('click', function(){
            password = $("#password").val();
            if(password){
                $("#password").removeClass('is-invalid');
                $.ajax({
                    type: 'POST',
                    url: 'resources/scripts/auth.php',
                    data: 'action=unlock&password='+password,
                    beforeSend: function(){
                        $("#lockLoginBtn").html('<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
                    },
                    success:function(response){
                        if(response=='login successful'){
                            //$("#msg").html('Successful. Wait...<i class="fa fa-spinner fa-spin"></i>').removeClass('text-danger');
                            setTimeout(function(){
                                window.location = './';
                            },2000);
                        }
                        else{
                            $("#msg").html('Invalid password').addClass('text-danger');
                            $("#lockLoginBtn").html('<i class="fas fa-arrow-right text-muted"></i>').removeAttr('disabled');
                        }
                    }
                });
            }
            else{
                $("#password").addClass('is-invalid');
            }
        });

        $("#logoutBtn").on('click', function(){
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/auth.php',
                data: 'action=logout',
                beforeSend: function(){
                    $("#logoutBtn").html('Loading...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
                },
                success:function(response){
                    setTimeout(function(){
                        window.location = './';
                    },2000);
                }
            });
        });
    });
</script>
<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
