<?php

    function sendSMS($phone, $message, $senderid, $token, $type){
        $refId = time(); //md5(date("d-M-Y H:i", time()));
        if(substr($phone, 0, 1)==0){
            $phone = '234'.substr($phone, 1, 15);
        }
        else{
            $phone = $phone;
        }
        
        if($type=='text'){
            $baseurl = 'https://smartsmssolutions.com/api/json.php?';
            
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://app.smartsmssolutions.ng/io/api/client/v1/sms/',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => array(
                    'token' => $token,
                    'sender' => $senderid,
                    'to' => $phone,
                    'message' => $message,
                    'type' => 0,
                    'routing' => 4,
                    'ref_id' => $refId
                ),
            ));

            $response = curl_exec($curl);

            $resValue = explode(':', $response);
            $msg = end($resValue);
            $msg = str_replace('"', '', $msg);
            $msg = str_replace('}', '', $msg);

            //return $msg;
            return $response;
        }
        elseif($type=='otp'){
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://app.smartsmssolutions.com/io/api/client/v1/smsotp/send/',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => array(
                    'token' => $token,
                    'sender' => $senderid,
                    'phone' => $phone,
                    'otp' => $message,
                    'template_code' => 'Use ##CODE## to log into your ##APP_NAME##.',
                    'ref_id' => $refId
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
        }
        
    }

    function fileSizeCheck($fileSize){
    if($fileSize>=1024){
        $fileSize = $fileSize/1024;
        if($fileSize>=1024){
            $fileSize = $fileSize/1024;
            if($fileSize>=1024){
                $fileSize = round(($fileSize/1024), 2).'GB';
            }
            else{
                $fileSize = round($fileSize, 2).'MB';
            }
        }
        else{
            $fileSize = round($fileSize, 2).'KB';
        }
    }
    else{
        $fileSize = $fileSize.'B';
    }
    return $fileSize;
}

function numberFormat($number){
    $value = explode('.', round($number, 2));
    $main = $value[0];
    $decimal = $value[1];
    if(empty($decimal)){
        $mainValue =  number_format($main);
    }
    else{
        $mainValue = number_format($main).'.'.$decimal;
    }

    return $mainValue;
}

function timeCheck($date){
    $date = strtotime($date);
    $today = strtotime("today");
    $yesterday = strtotime("yesterday");
    $thisWeek = strtotime("this week");
    $lastWeek = strtotime("last week");
    $dateN = time();
    $date2 = $dateN - $date;
    if(date("d M Y", $date) == date("d M Y", $today)){
        if($date2 < 60){
            $dateValue =  intval($date2).' secs ago'."\n";
        }
        elseif($date2 >= 60 && $date2 < (60*60)){
            $dateValue = intval($date2/(60));
            if($dateValue < 2){
                $dateValue = $dateValue .' min ago';
            }
            else{
                $dateValue = $dateValue .' mins ago';
            }
        }
        elseif($date2 >= (60*60) && $date2 < (60*60*6)){
            $dateValue = intval($date2/(60*60));
            if($dateValue < 2){
                $dateValue = $dateValue .' hr ago';
            }
            else{
                $dateValue = $dateValue .' hrs ago';
            }
        }
        else{
            $dateValue = "Today, ".date("h:ia", $date);
        }
    }
    elseif(date("d M Y", $date) == date("d M Y", $yesterday)){
        $dateValue = "Yesterday, ".date("h:ia", $date);
    }
    elseif(date("W Y", $thisWeek) == date("W Y", $date)){
        $dateValue = date("l, h:ia", $date);
    }
    else{
        $dateValue = date("d M, Y h:ia", $date);
    }

    return $dateValue;
}

function compressImage($source, $destination, $quality) { 
    // Get image info 
    $imgInfo = getimagesize($source); 
    $mime = $imgInfo['mime']; 
    // Create a new image from file 
    switch($mime){ 
        case 'image/jpeg': 
            $image = imagecreatefromjpeg($source); 
           imagejpeg($image, $destination, $quality);
            break; 
        case 'image/png': 
            $image = imagecreatefrompng($source); 
            imagepng($image, $destination, $quality);
            break; 
        case 'image/gif': 
            $image = imagecreatefromgif($source); 
            imagegif($image, $destination, $quality);
            break; 
        default: 
            $image = imagecreatefromjpeg($source); 
           imagejpeg($image, $destination, $quality);
    } 
    return $destination; 
} 

function currentPageURL(){
    $PageURL = 'http';
 if ($_SERVER["HTTPS"] == "on"){
    $PageURL .= "s";
 }
 
 $PageURL .= "://";
 if ($_SERVER["SERVER_PORT"] != "80"){
    $PageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
 }
 else{
    $PageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 }
 return $PageURL;
}


function numberTowords($num){
    $ones = array(
        0 =>"", 1 => "ONE", 2 => "TWO",3 => "THREE", 4 => "FOUR", 5 => "FIVE", 6 => "SIX", 7 => "SEVEN", 8 => "EIGHT",
        9 => "NINE", 10 => "TEN", 11 => "ELEVEN", 12 => "TWELVE", 13 => "THIRTEEN", 14 => "FOURTEEN", 15 => "FIFTEEN", 16 => "SIXTEEN",
        17 => "SEVENTEEN", 18 => "EIGHTEEN", 19 => "NINETEEN", "014" => "FOURTEEN"
    );
    $tens = array( 
        0 => "ZERO", 1 => "TEN", 2 => "TWENTY-", 3 => "THIRTY-", 4 => "FORTY-", 5 => "FIFTY-", 6 => "SIXTY-", 7 => "SEVENTY-", 8 => "EIGHTY-", 9 => "NINETY-" 
    ); 
    $hundreds = array( 
        "HUNDRED", "THOUSAND,", "MILLION,", "BILLION,", "TRILLION,", "QUARDRILLION," 
    ); /*limit t quadrillion */
    $num = number_format($num,2,".",","); 
    $num_arr = explode(".",$num); 
    $wholenum = $num_arr[0]; 
    $decnum = $num_arr[1]; 
    $whole_arr = array_reverse(explode(",",$wholenum)); 
    krsort($whole_arr,1); 
    $rettxt = ""; 

    foreach($whole_arr as $key => $i){
	
        while(substr($i,0,1)=="0")
            $i=substr($i,1,5);
            if($i < 20){ 
                $rettxt .= $ones[$i]; 
            }elseif($i < 100){ 
                if(substr($i,0,1)!="0")  $rettxt .= $tens[substr($i,0,1)]; 
                if(substr($i,1,1)!="0") $rettxt .= "".$ones[substr($i,1,1)]; 
            }else{ 
                if(substr($i,0,1)!="0"){
                    if(substr($i,-2,2)=='00'){
                        $rettxt .= $ones[substr($i,0,1)]." ".$hundreds[0];
                    }
                    else{
                        $rettxt .= $ones[substr($i,0,1)]." ".$hundreds[0]." AND";
                    }
                } 
                if(substr($i,1,1)!="0")$rettxt .= " ".$tens[substr($i,1,1)]; 
                if(substr($i,2,1)!="0")$rettxt .= "".$ones[substr($i,2,1)]; 
            } 
            if($key > 0){ 
                $rettxt .= " ".$hundreds[$key]." "; 
            }
    } 

    
    if($decnum > 0){
        $explodeFunction = explode('TY-', $rettxt);
        if(empty(end($explodeFunction))){
            $rettxt = str_replace('TY-', 'TY',$rettxt)." NAIRA";
        }
        else{
            $rettxt = str_replace('TY- ', 'TY',$rettxt)." NAIRA";
        }

        $rettxt .= ", ";
        if($decnum < 20){
            $rettxt .= $ones[$decnum];
        }elseif($decnum < 100){
            $rettxt .= $tens[substr($decnum,0,1)];
            $rettxt .= " ".$ones[substr($decnum,1,1)];
        }

        $explodeFunction = explode('TY- ', $rettxt);
        if(empty(end($explodeFunction))){
            $rettxt = str_replace('- ', ' ',$rettxt);
        }
        else{
            $rettxt = str_replace('TY- ', 'TY-',$rettxt);
        }

        $rettxt .= " KOBO";
    }
    else{
        $explodeFunction = explode('TY-', $rettxt);
        if(empty(end($explodeFunction))){
            $rettxt = str_replace('TY-', 'TY-',$rettxt)." NAIRA";
        }
        else{
            $rettxt = str_replace('TY- ', 'TY-',$rettxt)." NAIRA";
        }
    }

    $rettxt = ucwords(strtolower($rettxt." ONLY"));
    $rettxt = str_replace(',  Naira', ' Naira', $rettxt);
    $rettxt = str_replace('-thousand', ' Thousand', $rettxt);
    $rettxt = str_replace('-million', ' Million', $rettxt);
    $rettxt = str_replace('-billion', ' Billion', $rettxt);
    $rettxt = str_replace(',  Million,  Thousand Naira', ' Naira', $rettxt);
    return $rettxt;
}
 
?>