$(document).ready(function(){
	/////user login script//////
    var dataUrl = $("#dataUrl").val();
    var page = $("#page").attr("data-id");
    var currentPage = $("#currentPage").val();
    //alert(page);

    if(currentPage != 'directories'){
        setInterval(function(){
            $.ajax({
                type:'POST',
                url:'resources/scripts/notifications.php',
                data:'action=system-notification',
                success:function(response){
                    $("#systemNotification").html(response);
                }
            });
        }, 2000);
    }
	
	//////STICKERS MANAGEMENT//////
	if(currentPage=='Stickers Management'){
		$.ajax({
			type:'POST',
			url:'resources/scripts/settings/stickers.php',
			data:'action=view-stickers',
			dataType: 'JSON',
			beforeSend: function(){
				$("#stickerNumbers").html('');
				$("#stickerBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
			},
			success:function(responseData){
				$("#stickerBody").html(responseData.body);
				$("#stickerNumbers").html(responseData.numbers);
			}
		});
		
		$("#generateStickers").on('click', function(){
			var limit = 10000;
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/stickers.php',
				data:'action=generate-stickers&limit='+limit,
				dataType: 'JSON',
				beforeSend: function(){
					$("#generateStickers").html('<i class="fa fa-spinner fa-spin"></i>...Generating').attr('disabled','disabled');
				},
				success:function(responseData){
					//alert(responseData);
					if(responseData.header === 'successful'){
						$("#generateStickers").html('<i class="fas fa-plus"></i> Generate Sticker Numbers').removeAttr('disabled');
						toastr.success(responseData.message);
						
						/////reload the stickers
						$.ajax({
							type:'POST',
							url:'resources/scripts/settings/stickers.php',
							data:'action=view-stickers',
							dataType: 'JSON',
							beforeSend: function(){
								$("#stickerNumbers").html('');
								$("#stickerBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
							},
							success:function(responseData){
								$("#stickerBody").html(responseData.body);
								$("#stickerNumbers").html(responseData.numbers);
							}
						});
					}
					else{
						alert(responseData.header);
					}
				}
			});
		});
		
	}

	$("#signinBtn").on('click', function(){
		var username = $("#username").val();
		var pass = $("#password").val();
		
		if(username==''){
			$("#username").addClass('is-invalid');
		}
		else{
			$("#username").removeClass('is-invalid');
		}
		
		if(pass==''){
			$("#password").addClass('is-invalid');
		}
		else{
			$("#password").removeClass('is-invalid');
		}
		
		if(username && pass){
			$("#loginMsg").html('<h5 class="text-info"><i class="fas fa-spinner fa-spin"></i>...Loading</h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=login&username='+username+'&password='+pass,
				success:function(loginRet){
					if(loginRet=='invalid login'){
						$("#loginMsg").html('<h5 class="text-danger"><i class="fas fa-times"></i> Invalid username/password</h5>');
					}
					else if(loginRet=='first login'){
						$("#loginMsg").html('<h5 class="text-success"><i class="fas fa-spinner fa-spin"></i>...Loading dashboard for first time</h5>');
						setTimeout(function(){
							window.location = './';
						},4000);
					}
					else if(loginRet=='successful'){
						$("#loginMsg").html('<h5 class="text-success"><i class="fas fa-spinner fa-spin"></i>...Loading dashboard</h5>');
						setTimeout(function(){
							window.location = './';
						},4000);
					}
                    else{
						$("#loginMsg").html('<h5 class="text-danger"><i class="fas fa-times"></i> '+loginRet+'</h5>');
					}
				}
			});
		}
	});

    //////recover password/////
	$("#recoverPassword").on('click', function(){
		var email = $("#email").val();
		
		if(email==''){
			$("#email").addClass('is-invalid');
		}
		else{
			$("#email").removeClass('is-invalid');
		}
		
		if(email){
			$("#msg").html('<h5 class="text-info">Sending code...<i class="fas fa-spinner fa-spin"></i></h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=recover-password&email='+email,
				success:function(loginRet){
					if(loginRet=='successful'){
						$("#msg").html('<h5 class="text-success"><i class="fas fa-check-circle"></i> Verification Code Sent</h5>');
                        setTimeout(function(){
							window.location = './';
						},4000);
					}
					else{
						$("#msg").html('<h5 class="text-danger"><i class="fas fa-times-circle"></i> Invalid email address</h5>');
					}
				}
			});
		}
	});

    //////Verify Code/////
	$("#verifyCode").on('click', function(){
		var code = $("#code").val();
		
		if(code==''){
			$("#code").addClass('is-invalid');
		}
		else{
			$("#code").removeClass('is-invalid');
		}
		
		if(code){
			$("#msgV").html('<h5 class="text-info">Verifying code...<i class="fas fa-spinner fa-spin"></i></h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=verify-code&code='+code,
				success:function(loginRet){
					if(loginRet=='successful'){
						$("#msgV").html('<h5 class="text-success"><i class="fas fa-check-circle"></i> Verification Successful</h5>');
                        setTimeout(function(){
							window.location = './';
						},4000);
					}
					else{
						$("#msgV").html('<h5 class="text-danger"><i class="fas fa-times-circle"></i> Invalid Code</h5>');
					}
				}
			});
		}
	});

    //////Update Password/////
	$("#updatePassword").on('click', function(){
		var password = $("#password").val();
		var confirm = $("#confirm").val();
        var errorMsg = '';
		
		if(password==''){
			$("#password").addClass('is-invalid');
            errorMsg += 'Password is required'
		}
		else{
			$("#password").removeClass('is-invalid');
		}

		if(confirm==''){
			$("#confirm").addClass('is-invalid');
            if(errorMsg){
                errorMsg += '<br>Confirm Password required';
            }
            else{
                errorMsg += 'Confirm Password required';
            }
		}
		else{
            if(password==confirm){
                $("#confirm").removeClass('is-invalid');
            }
            else{
                $("#confirm").addClass('is-invalid');
                if(errorMsg){
                    errorMsg += '<br>Passwords do not match';
                }
                else{
                    errorMsg += 'Passwords do not match';
                }
            }
		}
		
		if(password && confirm && password==confirm){
			$("#msgUpdate").html('<h5 class="text-info">Updating Password...<i class="fas fa-spinner fa-spin"></i></h5>');
			
			$.ajax({
				type:'POST',
				url:'resources/scripts/auth.php',
				data:'action=update-password&password='+password,
				success:function(loginRet){
					if(loginRet=='successful'){
						$("#msgUpdate").html('<h5 class="text-success"><i class="fas fa-check-circle"></i> Password Updated. Wait while we redirect you...<i class="fa fa-spinner fa-spin"></i></h5>');
                        setTimeout(function(){
							window.location = './';
						},4000);
					}
					else{
						$("#msgUpdate").html('<h5 class="text-danger"><i class="fas fa-times-circle"></i> '+loginRet+'</h5>');
					}
				}
			});
		}
        else{
            errorMsg = '<span class="text-danger">'+errorMsg+'</span>';
            $("#msgUpdate").html(errorMsg);
        }
	});

    

    if(currentPage=='Dashboard'){
        setInterval(function(){
            $("#allUsers").load('resources/scripts/users/allusers.php?action=true'),
            $("#super-administrator").load('resources/scripts/users/super-administrator.php?action=true'),
            $("#administrator").load('resources/scripts/users/administrator.php?action=true'),
            $("#state-coordinator").load('resources/scripts/users/state-coordinator.php?action=true'),
            $("#lga-coordinator").load('resources/scripts/users/lga-coordinator.php?action=true'),
            $("#agent").load('resources/scripts/users/agents.php?action=true'),
            $("#vehicle-owners").load('resources/scripts/users/vehicle-owners.php?action=true'),
            $("#suspended-users").load('resources/scripts/users/suspended-users.php?action=true')
        }, 2000);
    }



    //////INVOICES///////////////

    var mainLoad = $("#main").val();

    if(page=='invoices' && mainLoad=='load-data'){
        /////load the details///
        $.ajax({
            type: 'POST',
            url:'resources/scripts/invoice-data.php',
            data:'action=load-invoice',
            beforeSend:function(){
                $("#mainLoad").html('<div class="text-center text-info"><h2><i class="fa fa-spinner fa-spin"></i></h2></div>');
            },
            success:function(response){
                $("#mainLoad").html(response);
            }
        });
    }


    //////EDIT INVOICE MODAL LOAD/////////
    $(document).delegate("[data-target='#edit-invoice']", "click", function() {
        var invoiceId = $(this).attr('data-id');
        //alert(invoiceId);

        $.ajax({
            type:'POST',
            url:'resources/scripts/invoice-data.php',
            data:'action=edit-invoice&invoice-id='+invoiceId,
            beforeSend: function(){
                $("#editInvoiceBody").html('<div class="col-md-12 text-center"><h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading</h3></div>');
            },
            success:function(responseData){
                $("#editInvoiceBody").html(responseData);
                $("#addInvoiceBody").html('');
            }
        });

    });


    ///////////////////COUNTRIES AND STATES DATA IN NATIONALITY PAGE////////////////////
    //////Country and details setting//////////////////
	$('#insertZone').on('click', function(){
		var stateName = $('#stateName').val();
		var stateNameVal = $('#stateNameVal').val();
		var zoneName = $('#zoneName').val();
		var selected = [];
		
		for(var option of document.getElementById('citiesName').options){
			if(option.selected){
				selected.push(option.value);
			}
		}
		
		if(stateName==''){
			$('#stateName').addClass('is-invalid');
		}
		else{
			$('#stateName').removeClass('is-invalid');
		}

		if(zoneName==''){
			$('#zoneName').addClass('is-invalid');
		}
		else{
			$('#zoneName').removeClass('is-invalid');
		}

		if(selected==''){
			$('#citiesName').addClass('is-invalid');
		}
		else{
			$('#citiesName').removeClass('is-invalid');
		}

		if(stateName && zoneName){
			$('#msgBox').html('<span class="text-info"><i class="fa fa-spinner fa-spin"></i>...adding <b>'+zoneName+'</b></span>')
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'state='+stateName+'&zone='+zoneName+'&cities='+selected,
				success: function(zoneRet){
					if(zoneRet=='Added with cities'){
						$('#msgBox').html('<span class="text-success"><b>'+zoneName+'</b> successfully added to <b>'+stateNameVal+'</b> ('+selected+')</span>');
						$('#zoneName').attr('value', '');
						
					}
					else if(zoneRet=='Successfully added'){
						$('#msgBox').html('<span class="text-success"><b>'+zoneName+'</b> successfully added to <b>'+stateNameVal+'</b></span>');
					}
					else if(zoneRet=='Already exists'){
						$('#msgBox').html('<span class="text-danger"><b>'+zoneName+'</b> already exists in <b>'+stateNameVal+'</b></span>');
					}
					else{
						$('#msgBox').html(zoneRet);
					}
				}
			});
		}
	});

	$('#stateName').on('change', function(){
		var sendState = $(this).val();
		if(sendState){
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'action=fetch&state='+sendState,
				success:function(retVal){
					$('#stateNameVal').attr('value', retVal);
				}
			});
		}
		else{
			$('#stateNameVal').attr('value', '');
		}
	});

	$('#stateName').on('change', function(){
		var state = $(this).val();
		if(state){
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'select=fetch&state='+state,
				success:function(retValState){
					$('#citiesName').html(retValState);
				}
			});
		}
		else{
			$('#citiesName').html('');
		}
	});

	//////add new country script/////////////
	$('#addCountry').on('click', function(){
		var countryToAdd = $('#countryToAdd').val();
		if(countryToAdd){
			$('#countryToAdd').addClass('is-valid');
			$('#msgCountryBox').html('<span class="text-info text-center"><i class="fa fa-spinner fa-spin"></i>...adding <b>'+countryToAdd+'</b> to countries</span><br><br>');
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'new_country=yes&country='+countryToAdd,
				success:function(counRet){
					if(counRet=='country exists'){
						$('#msgCountryBox').html('<span class="text-danger text-center"><i class="fa fa-times"></i> <b>'+countryToAdd+'</b> already exists</span><br><br>');
					}
					else if(counRet=='successfully added'){
						$('#msgCountryBox').html('<span class="text-success text-center"><i class="fa fa-check"></i> <b>'+countryToAdd+'</b> successfully added.</span><br><br>');
					}
					else{
						$('#msgCountryBox').html('<span class="text-danger text-center"><i class="fa fa-times"></i> '+counRet+'</span><br><br>');
					}
				}
			});
		}
		else{
			$('#countryToAdd').addClass('is-invalid');
		}
	});
	  
	$('#addStates').on('click', function(){
		var natCountryState = $('#natCountryState').val();
		var statesToAdd = $('#statesToAdd').val();
		var addCountryName = $('#addCountryName').val();
		if(natCountryState==''){
			$('#natCountryState').addClass('is-invalid');
		}
		else{
			$('#natCountryState').removeClass('is-invalid');
		}

		if(statesToAdd==''){
			$('#statesToAdd').addClass('is-invalid');
		}
		else{
			$('#statesToAdd').removeClass('is-invalid');
		}

		if(natCountryState && statesToAdd){
			$('#msgStatesBox').html('<span class="text-info text-center"><i class="fa fa-spinner fa-spin"></i>...adding cities</span><br><br>');
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'country='+natCountryState+'&states='+statesToAdd,
				success:function(addRet){
					if(addRet=='Successfully Added'){
						$('#msgStatesBox').html('<span class="text-success text-center"><i class="fa fa-check"></i> '+statesToAdd+' successfully added to <b>'+addCountryName+'</b>.</span><br><br>');
						document.getElementById('statesToAdd').value = '';
						document.getElementById('natCountryState').value = '';
					}
				}
			});
		}
	});

	$('#natCountryState').on('change', function(){
		var detCountry = $(this).val();
		if(detCountry){
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'country_id='+detCountry+'&action=fetch',
				success:function(counName){
					$('#addCountryName').attr('value', counName);
					$('#natCountryState').addClass('is-valid');
					document.getElementById('statesToAdd').value = '';
					$('#statesToAdd').addClass('is-invalid');
				}
			});
		}
		else{
			$('#natCountryState').addClass('is-invalid');
			document.getElementById('statesToAdd').value = '';
			$('#statesToAdd').addClass('is-invalid');
		}
	});

	$('#addLga').on('click', function(){
		var addToState = $('#addToState').val(), citiesToAdd = $('#lgaToAdd').val(), addToStateName=$('#addToStateName').val();
		if(addToState==''){
			$('#addToState').addClass('is-invalid');
		}
		else{
			$('#addToState').removeClass('is-invalid');
		}

		if(citiesToAdd==''){
			$('#lgaToAdd').addClass('is-invalid');
		}
		else{
			$('#lgaToAdd').removeClass('is-invalid');
		}

		if(addToState && citiesToAdd){
			$('#msgLgaBox').html('<span class="text-info text-center"><i class="fa fa-spinner fa-spin"></i>...adding LGAs</span><br><br>');
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'add_to_state='+addToState+'&lga_to_add='+citiesToAdd,
				success:function(addRet){
					if(addRet=='Successfully Added'){
						$('#msgLgaBox').html('<span class="text-success text-center"><i class="fa fa-check"></i> '+citiesToAdd+' successfully added.</span><br><br>');
						document.getElementById('lgaToAdd').value = '';
						document.getElementById('addToState').value = '';
					}
				}
			});
		}
	});

	

	$('#addCities').on('click', function(){
		var addToState = $('#addToStateNew').val(), citiesToAdd = $('#citiesToAdd').val(), addToStateName=$('#addToStateNewName').val();
		if(addToState==''){
			$('#addToStateNew').addClass('is-invalid');
		}
		else{
			$('#addToStateNew').removeClass('is-invalid');
		}

		if(citiesToAdd==''){
			$('#citiesToAdd').addClass('is-invalid');
		}
		else{
			$('#citiesToAdd').removeClass('is-invalid');
		}

		if(addToState && citiesToAdd){
			$('#msgCitiesBox').html('<span class="text-info text-center"><i class="fa fa-spinner fa-spin"></i>...adding cities</span><br><br>');
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'add_to_state='+addToState+'&cities_to_add='+citiesToAdd,
				success:function(addRet){
					if(addRet=='Successfully Added'){
						$('#msgCitiesBox').html('<span class="text-success text-center"><i class="fa fa-check"></i> '+citiesToAdd+' successfully added.</span><br><br>');
						document.getElementById('citiesToAdd').value = '';
						document.getElementById('addToState').value = '';
					}
				}
			});
		}
	});

	$('#addToState').on('change', function(){
		var detState = $(this).val();
		if(detState){
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'action=fetch&state='+detState,
				success:function(retValName){					
					$('#addToStateName').attr('value', retValName);
					$('#addToState').addClass('is-valid');
					document.getElementById('lgaToAdd').value = '';
					$('#lgaToAdd').addClass('is-invalid');					
				}
			});
		}
		else{
			$('#addToStateName').attr('value', '');
			$('#addToState').addClass('is-invalid');
			document.getElementById('lgaToAdd').value = '';
			$('#lgaToAdd').addClass('is-invalid');
		}
	});

	$('#addToStateNew').on('change', function(){
		var detState = $(this).val();
		if(detState){
			$.ajax({
				type:'POST',
				url:'resources/scripts/settings/nationality.php',
				data:'action=fetch&state='+detState,
				success:function(retValName){					
					$('#addToStateNewName').attr('value', retValName);
					$('#addToStateNew').addClass('is-valid');
					document.getElementById('citiesToAdd').value = '';
					$('#citiesToAdd').addClass('is-invalid');					
				}
			});
		}
		else{
			$('#addToStateNewName').attr('value', '');
			$('#addToStateNew').addClass('is-invalid');
			document.getElementById('citiesToAdd').value = '';
			$('#citiesToAdd').addClass('is-invalid');
		}
	});

	//////states select in setting///////////////
	$('#natCountryCities').on('change',function(){
        var natCountryId = $(this).val();
        if(natCountryId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/nationality.php',
                data:'country='+natCountryId+'&get_state=yes',
                success:function(html){
                    $('#addToState').html(html);
                }
            }); 
        }else{
            $('#addToState').html('<option value="">Select Country first</option>');
        }
    });

	$('#natCountryCitiesNew').on('change',function(){
        var natCountryId = $(this).val();
        if(natCountryId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/nationality.php',
                data:'country='+natCountryId+'&get_state=yes',
                success:function(html){
                    $('#addToStateNew').html(html);
                }
            }); 
        }else{
            $('#addToStateNew').html('<option value="">Select Country first</option>');
        }
    });
	
	$('#natCountryZone').on('change',function(){
        var natCountryId = $(this).val();
        if(natCountryId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/nationality.php',
                data:'country='+natCountryId+'&get_state=yes',
                success:function(html){
                    $('#stateName').html(html);
                }
            }); 
        }else{
            $('#stateName').html('<option value="">Select Country first</option>');
        }
    });

	$('#lgaToAdd').on('keyup', function(){
		var det = $(this).val();
		if(det==''){
			$('#lgaToAdd').addClass('is-invalid');
		}
		else{
			$('#lgaToAdd').addClass('is-valid');
		}
	});

	$('#citiesToAdd').on('keyup', function(){
		var det = $(this).val();
		if(det==''){
			$('#citiesToAdd').addClass('is-invalid');
		}
		else{
			$('#citiesToAdd').addClass('is-valid');
		}
	});
    
        
    //////Script to add cities to senatorial zone ///////////////
	$('#countryZone').on('change',function(){
        $("#citiesZoneName").html('');
        $("#viewZoneCities").attr('style','display:none;');
        $("#viewZoneCityName").attr('style','display:none;');
        $("#insertCitiesZone").attr('style','display:none;');
        var countryId = $(this).val();
        if(countryId){
            $("#viewZoneStateName").attr('style','display:block;');
            $('#countryZone').removeClass('is-invalid');
            $('#zoneCityName').html('<option value="">Select State first</option>');
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/nationality.php',
                data:'country='+countryId+'&get_state=yes',
                success:function(html){
                    $('#zoneStateName').html(html);
                }
            }); 
        }else{
            $("#viewZoneStateName").attr('style','display:none;');
            $('#zoneStateName').html('<option value="">Select Country first</option>');
            $('#zoneCityName').html('<option value="">Select State first</option>');
            $('#countryZone').addClass('is-invalid');
        }
    });

	$('#zoneStateName').on('change',function(){
        $("#viewZoneCities").attr('style','display:none;');
        $("#citiesZoneName").html('');
        $("#insertCitiesZone").attr('style','display:none;');
        var stateId = $(this).val();
        if(stateId){
            $("#viewZoneCityName").attr('style','display:block;');
            $("#zoneStateId").val(stateId);
            $('#zoneStateName').removeClass('is-invalid');
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/nationality.php',
                data:'state='+stateId+'&get_zones=yes',
                success:function(html){
                    $('#zoneCityName').html(html);
                }
            }); 
            
        }else{
            $('#zoneStateName').addClass('is-invalid');
            $('#zoneCityName').html('<option value="">Select State first</option>');
            $("#viewZoneCityName").attr('style','display:none;');
        }
    });

    $("#zoneCityName").on('change', function(){
        $("#citiesZoneName").html('');
        $("#insertCitiesZone").attr('style','display:none;');
        var zoneId = $(this).val();
        var stateId = $("#zoneStateId").val();
        if(zoneId){
            $(this).removeClass('is-invalid');
            $("#viewZoneCities").attr('style','display:block;');
            $(this).removeClass('is-invalid');
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/nationality.php',
                data:'state='+stateId+'&get_cities_zone=yes&zone_id='+zoneId,
                success:function(html){
                    if(html=='No Cities'){
                        $('#citiesZoneName').attr('data-placeholder','No LGAs/Cities to select');
                    }
                    else{
                        $('#citiesZoneName').html(html);
                        $('#citiesZoneName').attr('data-placeholder','Select LGAs/Cities');
                    }
                }
            }); 
        }
        else{
            $("#viewZoneCities").attr('style','display:none;');
            $(this).addClass('is-invalid');
        }
    });

    $("#citiesZoneName").on('change', function(){
        var city = $(this).val();
        
        if(city){
            $("#insertCitiesZone").attr('style','display:block;');
            $(this).removeClass('is-invalid');
        }
        else{
            $(this).addClass('is-invalid');
            $("#insertCitiesZone").attr('style','display:none;');
        }
    });
	
    $("#insertCitiesZone").on('click', function(){
        var zoneId = $("#zoneCityName").val();
        var cities =  $('#citiesZoneName').val();
        if(cities){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/nationality.php',
                data:'add_cities_zone=yes&zone_id='+zoneId+'&cities='+cities,
                success:function(html){
                    $("#zoneMsgBox").html(html);
                }
            }); 
        }
        else{
            $('#citiesZoneName').addClass('is-invalid');
        }
    });

    if(currentPage != 'directories' && currentPage !='payment'){
        ////////////////////Properties///////////////////////////////
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data-1.php',
            data:'action=load-properties',
            dataType: 'JSON',
            beforeSend: function(){
                $("#propertyDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#propertyDetails").html(responseData.body);
            }
        });

        $(document).delegate("[data-target='#view-property']", "click", function() {
            var propId = $(this).attr('data-id');
            //alert(paymentId);

            $.ajax({
                type:'POST',
                url:'resources/scripts/property/data-1.php',
                data:'action=view-property&property-id='+propId,
                dataType: 'JSON',
                beforeSend: function(){
                    $("#detailsBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                },
                success:function(responseData){
                    $("#detailsHeader").html('<b>'+responseData.property_name+'</b>');
                    //$("#rejectBody").html(responseDataMain).addClass('text-center');
                    $("#detailsBody").html(responseData.property_body);
                }
            });
        });

        $('#closeEditBtn').on('click', function(){
            $('#edit-property').off("hide.bs.modal").trigger("click");
            $.ajax({
                type:'POST',
                url:'resources/scripts/property/data.php',
                data:'action=remove-images-edit',
                success:function(responseData){
                    if(responseData=='successful'){
                        location.href='./';
                    }
                }
            });
        });
        $('#closeEdit').on('click', function(){
            $('#edit-property').off("hide.bs.modal").trigger("click");
            $.ajax({
                type:'POST',
                url:'resources/scripts/property/data.php',
                data:'action=remove-images-edit',
                success:function(responseDataDel){
                    if(responseDataDel=='successful'){
                        location.href='./';
                    }
                }
            });
        });

        $('#closeAdd').on('click', function(){
            $('#add-property').off("hide.bs.modal").trigger("click");
            $.ajax({
                type:'POST',
                url:'resources/scripts/property/data-1.php',
                data:'action=remove-images',
                success:function(responseData){
                if(responseData=='successful'){
                    location.href='./';
                }
                }
            });
        });

        $('#closeAddBtn').on('click', function(){
            $('#add-property').off("hide.bs.modal").trigger("click");
            $.ajax({
                type:'POST',
                url:'resources/scripts/property/data-1.php',
                data:'action=remove-images',
                success:function(responseData){
                if(responseData=='successful'){
                    location.href='./';
                }
                }
            });
        });

        $('.addProperty').on('click', function(){
            $('#add-property').off("hide.bs.modal").trigger("click");
            $.ajax({
                type:'POST',
                url:'resources/scripts/property/data-1.php',
                data:'action=remove-images',
                success:function(responseData){
                if(responseData=='successful'){
                    location.href='./';
                }
                }
            });
        });

        $(document).delegate("[data-target='#edit-property']", "click", function() {
            $('#edit-property').on('hide.bs.modal', function(e) {
            e.preventDefault();
            });

            var propId = $(this).attr('data-id');
            var name = $(this).attr('name');
            var title = $(this).attr('title');

            $("#editDetailsHeader").html('<b>'+title+'</b>');
            $.ajax({
                type:'POST',
                url:'resources/scripts/property/data-1.php',
                data:'action=edit-property'+name+'&property-id='+propId,
                beforeSend: function(){
                    $("#editDetailsBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                },
                success:function(responseData){
                    $("#editDetailsBody").html(responseData);
                }
            });

            if(name!=''){
            $.ajax({
                type:'POST',
                url:'resources/scripts/property/upload-images.php',
                data:'action=load-images-edit',
                beforeSend:function(){
                    $("#imgPreviewEdit").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
                },
                success:function(uploadResponse){
                    $("#imgPreviewEdit").html(uploadResponse);
                }
            });
            }
        }); 
        
        $(document).delegate("[data-target='#add-property']", "click", function() {
            $('#add-property').on('hide.bs.modal', function(e) {
            e.preventDefault();
            });
            
            /* $.ajax({
                type:'POST',
                url:'resources/scripts/property/data-1.php',
                data:'action=add-property',
                beforeSend: function(){
                    $("#addPropertyDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                },
                success:function(responseData){
                    $("#addPropertyDetails").html(responseData);
                }
            }); */

            $.ajax({
                type:'POST',
                url:'resources/scripts/property/upload-images.php',
                data:'action=load-images',
                beforeSend:function(){
                    $("#imgPreview").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
                },
                success:function(uploadResponse){
                    $("#imgPreview").html(uploadResponse);
                }
            });

        });

        ///////load property delete modal confirm box///////////
                    /*$(document).delegate("[data-target=#del-property]", "click", function() {
            var propId = $(this).attr(data-id);
            
 $.ajax({
                type:POST,
                url:'resources/scripts/property/data-1.php',
                data:'action=load-delete&prop-id='+propId,
                dataType: 'JSON',
                beforeSend: function(){
                    $("#propDelBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                },
                success:function(responseData){
                $("#propDelHead").html(responseData.head);
                $("#propDelBody").html(responseData.body);
                }
            }); 
        });*/

        /////DELETE PROPERTY CODE//////////////
        $("#deletePropBtn").on('click', function(){
            var propId = $("#prop-id").val();
            if(propId){

            }
            else{
            alert('No Property Selected');
            }
        });
    }
	

});