﻿<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">
		<link href="myaccount/images/main-logo.png" rel="icon">
		<title>Login - <?php echo $appName; ?> | <?php echo $appTagline; ?></title>
		<meta name="description" content="<?php echo $appName; ?> is your trusted solution for efficiently managing vehicle data, verifying credentials, and processing haulage fees. Designed specifically for the Association of Distributors and Transporters of Petroleum Products (ADITOP), our platform ensures seamless operations and compliance within the petroleum distribution network.">
		<meta name="author" content="SmartClouds">

		<!-- Web Fonts
		============================================= -->
		<link rel="stylesheet" href="css2?family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap">

		<!-- Stylesheet
		============================================= -->
		<link rel="stylesheet" type="text/css" href="myaccount/vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" type="text/css" href="myaccount/vendor/font-awesome/css/all.min.css">
		<link rel="stylesheet" type="text/css" href="myaccount/css/stylesheet.css">
		<!-- Colors Css -->
		<link id="color-switcher" type="text/css" rel="stylesheet" href="#">

		<script src="https://kit.fontawesome.com/4600147d2b.js" crossorigin="anonymous"></script>  
		<script src="jquery.min.js"></script>
		<!-- <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script> -->
		<script src="https://code.jquery.com/jquery-3.7.0.min.js" type="text/javascript"></script>
	</head>
	<body>

		<!-- Preloader ->
		<div id="preloader">
		  <div data-loader="dual-ring"></div>
		</div>
		<!-- Preloader End -->

		<div id="main-wrapper">
		  <div class="container-fluid px-0">
			<div class="row g-0 min-vh-100"> 
			  <!-- Welcome Text
			  ============================================= -->
			  <div class="col-md-6">
				<div class="hero-wrap d-flex align-items-center h-100">
				  <div class="hero-mask opacity-8 bg-primary"></div>
				  <div class="hero-bg hero-bg-scroll" style="background-image:url('myaccount/images/bg/petro-truck.jpg');"></div>
				  <div class="hero-content mx-auto w-100 h-100 d-flex flex-column">
					<div class="row g-0">
					  <div class="col-10 col-lg-9 mx-auto">
						<div class="logo mt-5 mb-5 mb-md-0"> <a class="d-flex" href="#" title="<?php echo $appName; ?>"><img src="myaccount/images/logo.png" width="150px" alt="<?php echo $appName; ?>"></a> </div>
					  </div>
					</div>
					<div class="row g-0 my-auto">
					  <div class="col-10 col-lg-9 mx-auto">
						<h1 class="text-11 text-white mb-4">Welcome back!</h1>
						<p class="text-4 text-white lh-base mb-5">
							Log in to access your personalized dashboard and experience the next level of fleet management with PetroFleet. 
							Manage vehicle data, verify credentials, and streamline haulage fee payments effortlessly—all in one place.
						</p>
					  </div>
					</div>
				  </div>
				</div>
			  </div>
			  <!-- Welcome Text End --> 
			  
			  <!-- Login Form
			  ============================================= -->
			  <div class="col-md-6 d-flex align-items-center">
				<div class="container my-4">
				  <div class="row g-0">
					<div class="col-11 col-lg-9 col-xl-8 mx-auto">
					  <h5 class="fw-400 mb-4">Enter your email and password to continue</h5>
					  
					  <form id="loginForm" method="post">
						<div class="mb-3">
						  <label for="email" class="form-label">Email Address</label>
						  <input type="email" class="form-control" auto-complete="off" id="email" required="" placeholder="Enter Your Email">
						</div>
						<div class="mb-3">
						  <label for="password" class="form-label">Password</label>
						  <input type="password" class="form-control" id="password" required="" placeholder="Enter your Password">
						</div>
						<div class="row mb-3">
						  <div class="col-sm text-end"><a class="btn-link" href="#">Forgot Password ?</a></div>
						</div>
						<div class="d-grid mb-3"><button class="btn btn-primary" type="button" id="loginBtn"> Login <i class="fas fa-sign-in"></i></button></div>
					  </form>
					  <h6 id="errorMsg" class="text-center"></h6>
					</div>
				  </div>
				</div>
			  </div>
			  <!-- Login Form End --> 
			</div>
		  </div>
		</div>

		<!-- Styles Switcher End --> 

		<!-- Script --> 
		<script src="myaccount/vendor/jquery/jquery.min.js"></script> 
		<script src="myaccount/vendor/bootstrap/js/bootstrap.bundle.min.js"></script> 
		<!-- Style Switcher --> 
		<script src="myaccount/js/switcher.min.js"></script> 
		<script src="myaccount/js/theme.js"></script>
		<script>
			$(document).ready(function(){
				$("#loginBtn").on('click', function(){
					let email = $("#email").val();
					let password = $("#password").val();
					let errorMsg = '';

					if(!email){
						$("#email").attr('style','border-color: red;');
						if(errorMsg){
							errorMsg = '<i class="fa fa-times"></i> Email required';
						}
						else{
							errorMsg = '<i class="fa fa-times"></i> Email required';
						}
					}
					else{
						if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
							if(errorMsg){
								errorMsg = '<i class="fa fa-times"></i> Invalid Email';
							}
							else{
								errorMsg = '<i class="fa fa-times"></i> Invalid Email';
							}
							$("#email").attr('style','border-color: red;');
						}
						else{
							$("#email").removeAttr('style');
						}
					}

					if(!password){
						$("#password").attr('style','border-color: red;');
						if(errorMsg){
							errorMsg += '<br><i class="fa fa-times"></i> Password required';
						}
						else{
							errorMsg += '<i class="fa fa-times"></i> Password required';
						}
					}
					else{
						$("#password").removeAttr('style');
					}

					if(!errorMsg){
						$.ajax({
							type: 'POST',
							url: 'scripts/auth.php',
							data: 'action=login&email='+email+'&password='+password,
							dataType: 'JSON',
							beforeSend:function(){
								$("#errorMsg").removeAttr('style').html('<i class="fa fa-spinner fa-spin"></i>...please wait.').attr('style','color: blue;');
							},
							success:function(response){
								if(response.header=='successful'){
									$("#errorMsg").removeAttr('style').html('Loading Dashboard...<i class="fa fa-spinner fa-spin"></i>').attr('style','color: green;');
									setTimeout(function(){
										window.location = './';
									},4000);
								}
								else{
									$("#errorMsg").removeAttr('style').html('<i class="fa fa-times"></i> Incorrect email/password').attr('style','color: red;');
								}
							}
						});
					}
					else{
						$("#errorMsg").removeAttr('style').html(errorMsg).attr('style','color: red;');
					}
					
				});
			});
		</script>
	</body>
</html>