$(document).ready(function(){
	var dataUrl = $("#dataUrl").val();
    var page = $("#page").attr("data-id");
    var currentPage = $("#currentPage").val();
	var type = $("#paymentType").val();
	
	if(currentPage=='payment'){
		
		$.ajax({
            type:'POST',
            url:'resources/scripts/payments/data.php',
            data:'action=load-payments&type='+type,
            beforeSend: function(){
                $("#paymentsPanel").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading</h3>');
            },
            success:function(responseData){
                $("#paymentsPanel").html(responseData);
            }
        });
	}
	
	////////PAYMENTS PAGE/////////////////
    ////VIEW PAYMENT DETAILS/////////////
    $(document).delegate("[data-target='#view-details']", "click", function() {
        var paymentId = $(this).attr('data-id');
        //alert(paymentId);

        $.ajax({
            type:'POST',
            url:'resources/scripts/data.php',
            data:'action=view-details&paymentid='+paymentId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#detailsBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#detailsHeader").html('Reject Payment for <b>'+responseData.payer_name+'</b>');
                //$("#rejectBody").html(responseDataMain).addClass('text-center');
                $("#detailsBody").html(responseData.tableDetails);
            }
        });

    });


    ///////CRYPTO APPROVAL//////////////////
    $(document).delegate("[data-target='#approve']", "click", function() {
        var paymentId = $(this).attr('data-id');
        //alert(paymentId);

        $.ajax({
            type:'POST',
            url:'resources/scripts/payments/data.php',
            data:'action=get-details-approve&paymentid='+paymentId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#approveBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $ ("#approveHeader").html('Approve Payment for <b>'+responseData.payer_name+'</b>');
                //$("#approveBody").html(responseData).addClass('text-center');
                $("#approveBody").html('Are you sure you have verified this payment of <b>'+responseData.currency+responseData.amount+'</b> from <b>'+responseData.payer_name+'</b> and want to approve it? <br>This action cannot be reversed.').addClass('text-center');
                $("#paymentIdApprove").val(paymentId);
            }
        });

    });

    $("#approveBtn").on('click', function(){
        var paymentId = $("#paymentIdApprove").val();
        $.ajax({
            type:'POST',
            url:'resources/scripts/payments/data.php',
            data:'action=approve-payment&paymentid='+paymentId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#approveBtn").attr('disabled','disabled');
                var defaultMsg = $("#approveBody").html();
                $("#approveBtn").html('Working...<i class="fa fa-spinner fa-spin"></i>');
            },
            success:function(response){
                if(response.header=='successful'){
                    document.getElementById('approve').style.display='none';
                    $(document).Toasts('create', {
                        class: 'bg-success',
                        title: 'Payment Approved',
                        body: 'Payment was successfully approved'
                    });
                    setTimeout(function(){
                        $.ajax({
							type:'POST',
							url:'resources/scripts/payments/data.php',
							data:'action=load-payments&type='+type,
							beforeSend: function(){
								$("#paymentsPanel").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading</h3>');
							},
							success:function(responseData){
								$("#paymentsPanel").html(responseData);
							}
						});
                    }, 5000);
                    
                }
                else{
                    $(document).Toasts('create', {
                        class: 'bg-danger',
                        title: response.header,
                        body: response.message
                    });
                    $("#approveBtn").removeAttr('disabled').html('Retry');
                    $("#approveBody").html(response.message);
                    $(this).html('Try Again');
                }
                
            }
        });
    });


    ///////APPROVE ALL///////////////////
    $(document).delegate("[data-target='#approveAll']", "click", function() {
        var paymentId = $(this).attr('data-id');
        //alert(paymentId);

        $.ajax({
            type:'POST',
            url:'resources/scripts/data.php',
            data:'action=get-approve-all&channel='+paymentId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#approveAllBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $ ("#approveAllHeader").html('Approve All Payments');
                //$("#approveBody").html(responseData).addClass('text-center');
                $("#approveAllBody").html(responseData.message).addClass('text-center');
                $("#channel").val(paymentId);
            }
        });

    });

    $("#approveAllBtn").on('click', function(){
        var channel = $("#channel").val();
        $.ajax({
            type:'POST',
            url:'resources/scripts/data.php',
            data:'action=approve-all-payment&channel='+channel,
            dataType: 'JSON',
            beforeSend: function(){
                $("#approveAllBtn").attr('disabled','disabled');
                var defaultMsg = $("#approveAllBody").html();
                $("#approveAllBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...please, wait');
            },
            success:function(response){
                if(response.header=='successful'){
                    $("#approveAllHeader").html(response.title);
                    $("#approveAllBody").html(response.message);
                    //document.getElementById('approve').style.display='none';
                    $(document).Toasts('create', {
                        class: 'bg-success',
                        title: response.title,
                        body: response.message
                    });
                    setTimeout(function(){
                        location.href="./";
                    }, 5000);
                    
                }
                else{
                    $(document).Toasts('create', {
                        class: 'bg-danger',
                        title: response.header,
                        body: response.body
                    });
                    $("#approveAllBtn").removeAttr('disabled');
                    $("#approveAllBody").html(response.message);
                    $(this).html('Try Again');
                }
                
            }
        });
    });

    //////REJECT PAYMENT
    $(document).delegate("[data-target='#reject']", "click", function() {
        var paymentId = $(this).attr('data-id');
        //alert(paymentId);

        $.ajax({
            type:'POST',
            url:'resources/scripts/data.php',
            data:'action=get-details-reject&paymentid='+paymentId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#rejectBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#rejectHeader").html('Reject Payment for <b>'+responseData.payer_name+'</b>');
                //$("#rejectBody").html(responseDataMain).addClass('text-center');
                $("#rejectBody").html('Are you sure you have verified this payment of <b>'+responseData.currency+responseData.amount+'</b> from <b>'+responseData.payer_name+'</b> and want to reject it? <br>This action cannot be reversed.').addClass('text-center');
                $("#paymentId").val(paymentId);
            }
        });

    });

    $("#rejectBtn").on('click', function(){
        var paymentId = $("#paymentId").val();
        $.ajax({
            type:'POST',
            url:'resources/scripts/data.php',
            data:'action=reject-payment&paymentid='+paymentId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#rejectBtn").attr('disabled','disabled');
                var defaultMsg = $("#rejectBody").html();
                $("#rejectBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...please, wait');
            },
            success:function(response){
                if(response.header=='successful'){
                    document.getElementById('reject').style.display='none';
                        $(document).Toasts('create', {
                            class: 'bg-success',
                            title: 'Payment Rejected',
                            body: response.message
                        });
                    setTimeout(function(){
                        location.href="./";
                    }, 5000);
                }
                else{
                    $(document).Toasts('create', {
                        class: 'bg-danger',
                        title: response.header,
                        body: response.body
                    });
                    /* $("#rejectBtn").removeAttr('disabled');
                    $("#rejectBody").html(response.message); */
                }
                
            }
        });
    });

    ////add new payment//////
    $("#paymentChannel").on("change", function(){
        var channel = $(this).val();
        if(channel!=''){
            $(this).removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/data.php',
                data:'action=load-channel&channel='+channel,
                success:function(response){
                    $("#paymentPanel").html(response);
                    $("#addPaymentBtn").attr('style', 'display: block;');
                }
            });
        }
        else{
            $(this).addClass('is-invalid');
            $("#paymentPanel").html('');
        }
    });

    /////trxRef auto generator
    function trxReference(length) {
        let result = '';
        const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        const charactersLength = characters.length;
        let counter = 0;
        while (counter < length) {
          result += characters.charAt(Math.floor(Math.random() * charactersLength));
          counter += 1;
        }
        return result;
    }

    /////add the payment/////
    $("#addPaymentBtn").on('click', function(){
        var name = $("#fullname").val();
        var email = $("#email").val();
        var channel = $("#paymentChannel").val();
        var amount = $("#amount").val();
        var emailError = '';
        var nameError = '';
        var channelError = '';
        var amountError = '';
        var trxRef = trxReference(32);

        if(email){
            if(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email)){
                email = email;
                $("#emailError").addClass('is-invalid').html('');
            }
            else{
                emailError = 'Invalid Email';
                $("#emailError").addClass('is-invalid').html('<i class="fa fa-times"></i> Invalid Email');
            }
        }
        else{
            emailError = 'required';
            $("#emailError").addClass('is-invalid').html('<i class="fa fa-times"></i> Email is required');
        }

        if(name){
            var fullName = name.split(' ');
            if(fullName.length > 1){
                var firstName = fullName[0];
                var lastName = fullName[1];
                $("#nameError").html('');
            }
            else{
                nameError = '<i class="fa fa-times"></i> First name and Last name required';
                $("#nameError").addClass('is-invalid').html('<i class="fa fa-times"></i> First and last names required');
            }
        }
        else{
            $("#nameError").addClass('is-invalid').html('<i class="fa fa-times"></i> Name required');
            nameError = 'Required';
        }

        if(channel){
            $("#channelError").html('');
            $("#paymentChannel").removeClass('is-invalid');

            if(channel=='Crypto'){
                var currency = '<i class="fa fa-usd"></i>';
            }
            else{
                var currency = '&#8358;';
            }
        }
        else{
            $("#channelError").addClass('is-invalid').html('<i class="fa fa-times"></i> Select Channel');
            $("#paymentChannel").addClass('is-invalid');
            channelError = 'Required';
        }

        if(amount){
            $("#amountError").html('');
            $("#amount").removeClass('is-invalid');
        }
        else{
            $("#amountError").addClass('is-invalid').html('<i class="fa fa-times"></i> Enter amount Paid');
            $("#amount").addClass('is-invalid');
            amountError = 'Required';
        }

        if(!nameError && !emailError && !channelError && !amountError){
            $.ajax({
                type: 'POST',
                url:'resources/scripts/data.php',
                data:'action=add-payment&channel='+channel+'&firstname='+firstName+'&lastname='+lastName+'&email='+email+'&trxref='+trxRef+'&amount='+amount,
                success:function(response){
                    if(response==='Successful'){
                        $(document).Toasts('create', {
                            class: 'bg-success',
                            title: 'Payment Submitted',
                            body: 'The payment of <b>'+currency+amount+'</b> for <b>'+firstName+'</b> was successful.'
                        });

                        $("#fullname").val('');
                        $("#email").val('');
                        $("#paymentChannel").val('Select Option');
                        $("#amount").val('');
                        $("#paymentPanel").html('');

                    }
                    else{
                        $(document).Toasts('create', {
                            class: 'bg-danger',
                            title: 'Payment Failed',
                            body: response
                        });
                    }
                }
            });
        }
        
    });


    /////autoload details/////////////
    if(currentPage=='payment'){
        setInterval(function(){
            $("#usdtAll").load('resources/scripts/payments/allusdt.php?action=true'),
            $("#usdtApproved").load('resources/scripts/payments/approvedusdt.php?action=true'),
            $("#usdtPending").load('resources/scripts/payments/pendingusdt.php?action=true'),
            $("#usdtRejected").load('resources/scripts/payments/rejectedusdt.php?action=true'),
            $("#allBankTransfer").load('resources/scripts/payments/allBankTransfer.php?action=true'),
            $("#allLocal").load('resources/scripts/payments/allLocal.php?action=true'),
            $("#allPaystack").load('resources/scripts/payments/allPaystack.php?action=true'),
            $("#approvedBankTransfer").load('resources/scripts/payments/approvedBankTransfer.php?action=true'),
            $("#pendingBankTransfer").load('resources/scripts/payments/pendingBankTransfer.php?action=true')
        }, 500);
    }
});